/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.samples.wizards.launch;

import java.text.MessageFormat;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.m2m.internal.qvt.oml.samples.QVTSamplesPlugin;
import org.eclipse.m2m.internal.qvt.oml.samples.ui.SampleProject;
import org.eclipse.m2m.internal.qvt.oml.samples.ui.wizard.SamplesWizard;
import org.eclipse.m2m.internal.qvt.oml.samples.ui.wizard.SamplesWizardPage;
import org.eclipse.m2m.internal.qvt.oml.samples.wizards.Messages;
import org.eclipse.m2m.internal.qvt.oml.samples.wizards.launch.ILaunchData;
import org.eclipse.m2m.internal.qvt.oml.samples.wizards.launch.Launch;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class LaunchWizard
extends SamplesWizard {
    private static final String DEFAULT_IMAGE_PATH = "icons/pr-MDA_wizard.gif";
    private PageWithLaunch myLaunchPage;
    private Launch myLaunch;
    private final SampleProject[] myProjects;

    protected LaunchWizard(SampleProject[] projects) {
        super(projects);
        this.myProjects = projects;
        this.setDefaultPageImageDescriptor(QVTSamplesPlugin.getImageDescriptor(DEFAULT_IMAGE_PATH));
    }

    protected LaunchWizard(SampleProject project) {
        this(new SampleProject[]{project});
    }

    protected void setLaunchData(String defaultName, ILaunchData launchData) {
        this.myLaunch = new Launch(defaultName, launchData);
    }

    public boolean performFinish() {
        if (!super.performFinish()) {
            return false;
        }
        try {
            this.myLaunch.registerLaunchConfiguration((IContainer)ResourcesPlugin.getWorkspace().getRoot().getProject(this.myProjects[0].getName()));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return true;
    }

    protected SamplesWizardPage createPage(SampleProject[] projects) {
        this.myLaunchPage = new PageWithLaunch(projects);
        return this.myLaunchPage;
    }

    protected SampleProject getProject(int index) {
        return this.myProjects[index];
    }

    private final class PageWithLaunch
    extends SamplesWizardPage {
        private Text myLaunchText;

        PageWithLaunch(SampleProject[] projects) {
            super(projects);
        }

        public String getLaunchName() {
            return this.myLaunchText.getText();
        }

        protected boolean validatePage() {
            boolean result = super.validatePage();
            if (!result) {
                return result;
            }
            String configName = this.myLaunchText.getText();
            if (configName.trim().length() == 0) {
                this.setErrorMessage(Messages.SamplesWizardPage_notLaunchName);
                return false;
            }
            try {
                if (DebugPlugin.getDefault().getLaunchManager().isExistingLaunchConfigurationName(configName)) {
                    this.setErrorMessage(MessageFormat.format(Messages.SamplesWizardPage_existingLaunch, configName));
                    return false;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            return result;
        }

        protected void doCreateContents(Composite parent) {
            super.doCreateContents(parent);
            Label label = new Label(parent, 0);
            label.setText(Messages.SamplesWizardPage_LaunchConfiguration);
            this.myLaunchText = new Text(parent, 2052);
            this.myLaunchText.setLayoutData((Object)new GridData(768));
            this.myLaunchText.setText(LaunchWizard.this.myLaunch.getLaunchName());
            ModifyListener modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PageWithLaunch.this.setPageComplete(PageWithLaunch.this.validatePage());
                    LaunchWizard.this.myLaunch.setLaunchName(PageWithLaunch.this.myLaunchText.getText());
                }
            };
            this.myLaunchText.addModifyListener(modifyListener);
        }
    }
}

