/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.evaluator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphWalker {
    public static final int MAX_WEIGHT = Integer.MAX_VALUE;
    private final NodeProvider myNodeProvider;

    public GraphWalker(NodeProvider nodeProvider) {
        this.myNodeProvider = nodeProvider;
    }

    public boolean walkBreadthFirst(Object root, VertexProcessor processor) {
        HashSet<Object> visited = new HashSet<Object>();
        ArrayList<Object> queue = new ArrayList<Object>();
        visited.add(root);
        queue.add(root);
        while (!queue.isEmpty()) {
            Object u = queue.remove(0);
            Object[] succ = this.myNodeProvider.getLinkedNodes(u);
            int i = 0;
            while (i < succ.length) {
                Object v = succ[i];
                if (!visited.contains(v)) {
                    queue.add(v);
                    visited.add(v);
                }
                ++i;
            }
            boolean stop = processor.process(u);
            if (!stop) continue;
            return true;
        }
        return false;
    }

    public boolean walkDepthFirst(Object root, VertexProcessor processor) throws CycleException {
        HashMap<Object, Integer> visited = new HashMap<Object, Integer>();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Traverser {
            Integer GREY = new Integer(1);
            Integer BLACK = new Integer(2);

            Traverser() {
            }

            boolean walkDepthFirst(Object u, Map<Object, Integer> visited, VertexProcessor processor) {
                visited.put(u, this.GREY);
                Object[] succ = GraphWalker.this.myNodeProvider.getLinkedNodes(u);
                int i = 0;
                while (i < succ.length) {
                    Object v = succ[i];
                    if (!visited.containsKey(v)) {
                        boolean stop = this.walkDepthFirst(v, visited, processor);
                        if (stop) {
                            return true;
                        }
                    } else if (this.GREY == visited.get(v)) {
                        throw new CycleException(u, v);
                    }
                    ++i;
                }
                boolean stop = processor.process(u);
                visited.put(u, this.BLACK);
                return stop;
            }
        }
        return new Traverser().walkDepthFirst(root, visited, processor);
    }

    public Object[] findFirstCycle(Object root) {
        try {
            this.walkDepthFirst(root, new VertexProcessor(){

                public boolean process(Object node) {
                    return false;
                }
            });
            return null;
        }
        catch (CycleException e) {
            return new Object[]{e.getFrom(), e.getTo()};
        }
    }

    public int getMinimumDistance(Object source, Object dest, int weight) {
        HashMap<ObjectPair, Integer> pathToWeight = new HashMap<ObjectPair, Integer>();
        this.getMinDistanceImpl(source, pathToWeight, weight);
        Integer d = (Integer)pathToWeight.get(new ObjectPair(source, dest));
        return d == null ? Integer.MAX_VALUE : d;
    }

    private void getMinDistanceImpl(Object s, Map<ObjectPair, Integer> path2Weight, int weight) {
        Object[] nodes = this.myNodeProvider.getLinkedNodes(s);
        int k = 0;
        while (k < nodes.length) {
            ObjectPair t2t;
            Object t = nodes[k];
            ObjectPair s2t = new ObjectPair(s, t);
            if (path2Weight.get(s2t) == null || path2Weight.get(s2t) > weight) {
                path2Weight.put(s2t, new Integer(weight));
            }
            if (path2Weight.get(t2t = new ObjectPair(t, t)) == null) {
                this.getMinDistanceImpl(t, path2Weight, weight);
            }
            HashSet paths = new HashSet(path2Weight.entrySet());
            for (Map.Entry entry : paths) {
                ObjectPair t2i = (ObjectPair)entry.getKey();
                if (!t.equals(t2i.getFirst())) continue;
                Integer t2iW = (Integer)entry.getValue();
                Object i = t2i.getSecond();
                ObjectPair s2i = new ObjectPair(s, i);
                if (path2Weight.get(s2i) != null && path2Weight.get(s2i) <= weight + t2iW) continue;
                path2Weight.put(s2i, new Integer(weight + t2iW));
            }
            ++k;
        }
        ObjectPair s2s = new ObjectPair(s, s);
        path2Weight.put(s2s, new Integer(0));
    }

    public static class CycleException
    extends RuntimeException {
        private static final long serialVersionUID = -7749663546813761182L;
        private final Object myFrom;
        private final Object myTo;

        public CycleException(Object from, Object to) {
            this.myFrom = from;
            this.myTo = to;
        }

        public Object getFrom() {
            return this.myFrom;
        }

        public Object getTo() {
            return this.myTo;
        }

        public String toString() {
            return "Cycle from " + this.myFrom + " to " + this.myTo;
        }
    }

    public static interface NodeProvider {
        public Object[] getLinkedNodes(Object var1);
    }

    public static class ObjectPair {
        private final Object myFirst;
        private final Object mySecond;

        public ObjectPair(Object first, Object second) {
            this.myFirst = first;
            this.mySecond = second;
        }

        public Object getFirst() {
            return this.myFirst;
        }

        public Object getSecond() {
            return this.mySecond;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ObjectPair)) {
                return false;
            }
            ObjectPair pair = (ObjectPair)o;
            return this.myFirst.equals(pair.myFirst) && this.mySecond.equals(pair.mySecond);
        }

        public int hashCode() {
            return 17 + this.myFirst.hashCode() * 37 + this.mySecond.hashCode();
        }
    }

    public static interface VertexProcessor {
        public boolean process(Object var1);
    }
}

