/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.env;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtEnvironmentBase;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.HiddenElementAdapter;
import org.eclipse.m2m.internal.qvt.oml.expressions.ContextualProperty;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.TypeResolver;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.types.MessageType;
import org.eclipse.ocl.types.TupleType;
import org.eclipse.ocl.types.TypeType;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.TypedElement;
import org.eclipse.ocl.utilities.UMLReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtTypeResolverImpl
implements TypeResolver<EClassifier, EOperation, EStructuralFeature> {
    private TypeResolver<EClassifier, EOperation, EStructuralFeature> fDelegate;
    private QvtEnvironmentBase fOwner;
    private boolean fdefinesOclAnyFeatures;
    private Map<EClassifier, List<ImperativeOperation>> fCtx2OperationMap;
    private Set<EClassifier> fAdditionalTypes;

    QvtTypeResolverImpl(QvtEnvironmentBase owningEnv, TypeResolver<EClassifier, EOperation, EStructuralFeature> delegate) {
        if (delegate == null || owningEnv == null) {
            throw new IllegalArgumentException();
        }
        this.fOwner = owningEnv;
        this.fDelegate = delegate;
        this.fdefinesOclAnyFeatures = false;
    }

    QvtEnvironmentBase getOwner() {
        return this.fOwner;
    }

    public void collectAdditionalOperationsInTypeHierarchy(EClassifier type, boolean subTypesOnly, Collection<EOperation> result) {
        if (this.fAdditionalTypes != null) {
            for (EClassifier nextType : this.fAdditionalTypes) {
                boolean isPartOfHierarchy;
                boolean bl = isPartOfHierarchy = TypeUtil.getRelationship((Environment)this.fOwner, (Object)type, (Object)nextType) == 4;
                if (type == nextType || !isPartOfHierarchy) continue;
                this.getLocalAdditionalOperations(nextType, result);
            }
        }
        for (QvtEnvironmentBase nextSiblingEnv : this.fOwner.getSiblings()) {
            nextSiblingEnv.getQVTTypeResolver().collectAdditionalOperationsInTypeHierarchy(type, subTypesOnly, result);
        }
    }

    public List<EStructuralFeature> getAdditionalAttributes(EClassifier owner) {
        ArrayList<EStructuralFeature> result = new ArrayList<EStructuralFeature>();
        this.getLocalAdditionalAttributes(owner, result);
        for (QvtEnvironmentBase nextSiblingEnv : this.fOwner.getSiblings()) {
            nextSiblingEnv.getQVTTypeResolver().getLocalAdditionalAttributes(owner, result);
        }
        return result;
    }

    protected void getLocalAdditionalAttributes(EClassifier owner, List<EStructuralFeature> result) {
        this.extractIntermediateProperties(owner, result);
        result.addAll(this.fDelegate.getAdditionalAttributes((Object)owner));
    }

    public List<EOperation> getAdditionalOperations(EClassifier owner) {
        ArrayList<EOperation> result = new ArrayList<EOperation>();
        this.getLocalAdditionalOperations(owner, result);
        for (QvtEnvironmentBase nextSiblingEnv : this.fOwner.getSiblings()) {
            List ops = nextSiblingEnv.getAdditionalOperations(owner);
            if (ops == null) continue;
            result.addAll(ops);
        }
        return result;
    }

    private void extractContextualOperations(EClassifier context, Collection<EOperation> result) {
        if (this.fCtx2OperationMap != null) {
            List<ImperativeOperation> operList = this.fCtx2OperationMap.get(context);
            if (operList != null) {
                result.addAll(operList);
            }
            return;
        }
    }

    private void extractIntermediateProperties(EClassifier context, Collection<EStructuralFeature> result) {
        if (context instanceof EClass) {
            Module moduleType = this.fOwner.getModuleContextType();
            if (moduleType == null) {
                return;
            }
            for (EStructuralFeature property : moduleType.getEStructuralFeatures()) {
                ContextualProperty ctxProperty;
                EClass nextContext;
                if (!(property instanceof ContextualProperty) || HiddenElementAdapter.isMarkedAsHidden((EObject)property) || (nextContext = (ctxProperty = (ContextualProperty)property).getContext()) == null || nextContext != context) continue;
                result.add(ctxProperty);
            }
        }
    }

    protected void getLocalAdditionalOperations(EClassifier owner, Collection<EOperation> result) {
        this.extractContextualOperations(owner, result);
        if (this.fdefinesOclAnyFeatures && !(owner instanceof CollectionType) && !(owner instanceof TupleType)) {
            this.extractContextualOperations((EClassifier)this.fOwner.getOCLStandardLibrary().getOclAny(), result);
        }
        result.addAll(this.fDelegate.getAdditionalOperations((Object)owner));
        if (this.fdefinesOclAnyFeatures && !(owner instanceof CollectionType) && !(owner instanceof TupleType)) {
            result.addAll(this.fDelegate.getAdditionalOperations((Object)((EClassifier)this.fOwner.getOCLStandardLibrary().getOclAny())));
        }
    }

    public Resource getResource() {
        return this.fDelegate.getResource();
    }

    public EClassifier resolve(EClassifier type) {
        return (EClassifier)this.fDelegate.resolve((Object)type);
    }

    public EStructuralFeature resolveAdditionalAttribute(EClassifier owner, EStructuralFeature property) {
        return (EStructuralFeature)this.fDelegate.resolveAdditionalAttribute((Object)owner, (Object)property);
    }

    public EOperation resolveAdditionalOperation(EClassifier owner, EOperation operation) {
        if (operation instanceof ImperativeOperation) {
            List<ImperativeOperation> operList;
            if (this.fCtx2OperationMap == null) {
                this.fCtx2OperationMap = new HashMap<EClassifier, List<ImperativeOperation>>();
            }
            if ((operList = this.fCtx2OperationMap.get(owner)) == null) {
                operList = new ArrayList<ImperativeOperation>();
                this.fCtx2OperationMap.put(owner, operList);
            }
            this.addAdditionalType(owner);
            operList.add((ImperativeOperation)operation);
            return operation;
        }
        EOperation resolve = (EOperation)this.fDelegate.resolveAdditionalOperation((Object)owner, (Object)operation);
        if (resolve != null) {
            this.addAdditionalType(owner);
            if (!this.fdefinesOclAnyFeatures && owner == this.fOwner.getOCLStandardLibrary().getOclAny()) {
                this.fdefinesOclAnyFeatures = true;
            }
        }
        return resolve;
    }

    public CollectionType<EClassifier, EOperation> resolveCollectionType(CollectionKind kind, EClassifier elementType) {
        return this.fDelegate.resolveCollectionType(kind, (Object)elementType);
    }

    public MessageType<EClassifier, EOperation, EStructuralFeature> resolveOperationMessageType(EOperation operation) {
        return this.fDelegate.resolveOperationMessageType((Object)operation);
    }

    public MessageType<EClassifier, EOperation, EStructuralFeature> resolveSignalMessageType(EClassifier signal) {
        return this.fDelegate.resolveSignalMessageType((Object)signal);
    }

    public TupleType<EOperation, EStructuralFeature> resolveTupleType(EList<? extends TypedElement<EClassifier>> parts) {
        return this.fDelegate.resolveTupleType(parts);
    }

    public TypeType<EClassifier, EOperation> resolveTypeType(EClassifier type) {
        return this.fDelegate.resolveTypeType((Object)type);
    }

    UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> uml() {
        return this.fOwner.getUMLReflection();
    }

    private void addAdditionalType(EClassifier type) {
        if (this.fAdditionalTypes == null) {
            this.fAdditionalTypes = new HashSet<EClassifier>();
        }
        this.fAdditionalTypes.add(type);
    }
}

