/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.outline;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalTypesUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalUtil;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingDeclarationCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingMethodCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingModuleCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingQueryCS;
import org.eclipse.m2m.internal.qvt.oml.cst.ModelTypeCS;
import org.eclipse.m2m.internal.qvt.oml.cst.ModulePropertyCS;
import org.eclipse.m2m.internal.qvt.oml.cst.PackageRefCS;
import org.eclipse.m2m.internal.qvt.oml.cst.ParameterDeclarationCS;
import org.eclipse.m2m.internal.qvt.oml.cst.RenameCS;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.outline.OutlineNode;
import org.eclipse.m2m.internal.qvt.oml.ui.QvtPluginImages;
import org.eclipse.ocl.cst.PathNameCS;
import org.eclipse.ocl.cst.StringLiteralExpCS;
import org.eclipse.ocl.cst.TypeCS;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtOutlineLabelProvider
implements ILabelProvider {
    public static final String RENAMES_NODE = "renamings";
    public static final String METAMODELS_NODE = "metamodels";
    public static final String IMPORTS_NODE = "imports";
    public static final String PROPERTIES_NODE = "properties";
    public static final String LIBRARY_NODE = "library";

    public Image getImage(Object element) {
        OutlineNode node = (OutlineNode)element;
        switch (node.getType()) {
            case 3: {
                return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.impc_obj.gif");
            }
            case 1: {
                return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.impc_obj.gif");
            }
            case 2: {
                return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.jar_l_obj.gif");
            }
            case 0: {
                return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.package_obj.gif");
            }
            case 5: {
                return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.impc_obj.gif");
            }
            case 4: {
                return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.methpub_obj.gif");
            }
            case 7: {
                return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.impc_obj.gif");
            }
            case 6: {
                return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.field_public_obj.gif");
            }
            case 8: {
                if (node.getSyntaxElement() instanceof MappingQueryCS) {
                    return QvtPluginImages.getInstance().getImage("qvt-query");
                }
                return QvtPluginImages.getInstance().getImage("qvt-mapping");
            }
            case 9: {
                return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.impc_obj.gif");
            }
        }
        return null;
    }

    public String getText(Object element) {
        return element.toString();
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public static String getMappingModuleLabel(MappingModuleCS m) {
        return m.getHeaderCS() == null || m.getHeaderCS().getPathNameCS() == null ? "" : QvtOutlineLabelProvider.getImportLabel(m.getHeaderCS().getPathNameCS());
    }

    public static String getMappingRuleLabel(MappingMethodCS r) {
        return QvtOutlineLabelProvider.getMappingDeclarationAsString(r.getMappingDeclarationCS());
    }

    public static String getRenameLabel(RenameCS r) {
        return String.valueOf(r.getOriginalName().getStringSymbol()) + " := " + r.getSimpleNameCS().getValue();
    }

    public static String getPropertyLabel(ModulePropertyCS prop) {
        return prop.getSimpleNameCS().getValue();
    }

    public static String getImportLabel(PathNameCS path) {
        StringBuffer buffer = null;
        for (String part : path.getSequenceOfNames()) {
            if (buffer != null) {
                buffer.append(".");
            } else {
                buffer = new StringBuffer();
            }
            buffer.append(part);
        }
        return buffer == null ? "" : buffer.toString();
    }

    public static String getMetamodelLabel(ModelTypeCS modelTypeCS) {
        StringLiteralExpCS uriCS = ((PackageRefCS)modelTypeCS.getPackageRefs().get(0)).getUriCS();
        if (uriCS == null) {
            return "";
        }
        return uriCS.getStringSymbol();
    }

    private static String getMappingDeclarationAsString(MappingDeclarationCS decl) {
        EObject rootContainer;
        if (decl == null) {
            return "";
        }
        ArrayList<String> listParam = new ArrayList<String>();
        for (ParameterDeclarationCS param : decl.getParameters()) {
            listParam.add(QvtOutlineLabelProvider.getParameterDeclarationAsString(param));
        }
        String context = QvtOutlineLabelProvider.getTypeAsString(decl.getContextType());
        if (decl.getContextType() == null && (rootContainer = EcoreUtil.getRootContainer((EObject)decl)) instanceof MappingModuleCS) {
            context = QvtOutlineLabelProvider.getMappingModuleLabel((MappingModuleCS)rootContainer);
        }
        return QvtOutlineLabelProvider.getMappingDeclarationAsString(decl.getSimpleNameCS().getValue(), context, listParam);
    }

    public static String getMappingDeclarationAsString(String name, String contextType, List<String> params) {
        StringBuffer result = new StringBuffer(contextType);
        result.append("::");
        result.append(name);
        result.append("(");
        Iterator<String> it = params.iterator();
        while (it.hasNext()) {
            result.append(it.next());
            if (!it.hasNext()) continue;
            result.append(", ");
        }
        result.append(")");
        return result.toString();
    }

    private static String getParameterDeclarationAsString(ParameterDeclarationCS decl) {
        StringBuffer result = new StringBuffer();
        if (decl.getDirectionKind().getValue() == 0) {
            result.append("in ");
        } else if (decl.getDirectionKind().getValue() == 0) {
            result.append("out ");
        } else if (decl.getDirectionKind().getValue() == 0) {
            result.append("inout ");
        }
        if (decl.getSimpleNameCS() != null) {
            result.append(decl.getSimpleNameCS().getValue());
        }
        String typeName = QvtOutlineLabelProvider.getTypeAsString(decl.getTypeSpecCS().getTypeCS());
        result.append(":").append(typeName);
        return result.toString();
    }

    private static String getTypeAsString(TypeCS type) {
        String typeName = type instanceof EClassifier ? QvtOperationalTypesUtil.getTypeFullName((EClassifier)((EClassifier)type)) : (type != null ? QvtOperationalUtil.getStringRepresentation((TypeCS)type) : "OclVoid");
        return typeName;
    }
}

