/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.codegen.qvti.java;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.AnalysisVisitor;
import org.eclipse.ocl.examples.codegen.analyzer.BoxingAnalyzer;
import org.eclipse.ocl.examples.codegen.analyzer.DependencyVisitor;
import org.eclipse.ocl.examples.codegen.analyzer.FieldingAnalyzer;
import org.eclipse.ocl.examples.codegen.analyzer.NameManager;
import org.eclipse.ocl.examples.codegen.analyzer.ReferencesVisitor;
import org.eclipse.ocl.examples.codegen.cgmodel.CGClass;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGModelFactory;
import org.eclipse.ocl.examples.codegen.cgmodel.CGNamedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGPackage;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.java.CG2JavaPreVisitor;
import org.eclipse.ocl.examples.codegen.java.ImportNameManager;
import org.eclipse.ocl.examples.codegen.java.ImportUtils;
import org.eclipse.ocl.examples.codegen.java.JavaCodeGenerator;
import org.eclipse.ocl.examples.codegen.java.JavaImportNameManager;
import org.eclipse.ocl.examples.codegen.utilities.CGModelResourceFactory;
import org.eclipse.ocl.examples.codegen.utilities.CGUtil;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.codegen.qvti.QVTiCodeGenOptions;
import org.eclipse.qvtd.codegen.qvti.analyzer.QVTiAS2CGVisitor;
import org.eclipse.qvtd.codegen.qvti.analyzer.QVTiAnalysisVisitor;
import org.eclipse.qvtd.codegen.qvti.analyzer.QVTiAnalyzer;
import org.eclipse.qvtd.codegen.qvti.analyzer.QVTiBoxingAnalyzer;
import org.eclipse.qvtd.codegen.qvti.analyzer.QVTiCG2StringVisitor;
import org.eclipse.qvtd.codegen.qvti.analyzer.QVTiDependencyVisitor;
import org.eclipse.qvtd.codegen.qvti.analyzer.QVTiFieldingAnalyzer;
import org.eclipse.qvtd.codegen.qvti.analyzer.QVTiReferencesVisitor;
import org.eclipse.qvtd.codegen.qvti.java.QVTiCG2JavaPreVisitor;
import org.eclipse.qvtd.codegen.qvti.java.QVTiCG2JavaVisitor;
import org.eclipse.qvtd.codegen.qvti.java.QVTiGlobalContext;
import org.eclipse.qvtd.codegen.qvticgmodel.CGMappingLoop;
import org.eclipse.qvtd.codegen.qvticgmodel.CGTransformation;
import org.eclipse.qvtd.codegen.utilities.QVTiCGModelResourceFactory;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiTransformationAnalysis;
import org.eclipse.qvtd.runtime.evaluation.AbstractTransformer;
import org.eclipse.qvtd.runtime.evaluation.ExecutionVisitable;
import org.eclipse.qvtd.runtime.evaluation.Transformer;
import org.eclipse.qvtd.runtime.internal.evaluation.AbstractTransformerInternal;

public class QVTiCodeGenerator
extends JavaCodeGenerator {
    protected final @NonNull QVTiAnalyzer cgAnalyzer;
    protected final @NonNull Transformation transformation;
    private CGPackage cgPackage;
    private String javaSourceCode = null;
    protected final @NonNull QVTiGlobalContext globalContext = new QVTiGlobalContext(this);
    protected final @NonNull Map<Transformation, QVTiTransformationAnalysis> transformation2analysis = new HashMap<Transformation, QVTiTransformationAnalysis>();

    public QVTiCodeGenerator(@NonNull QVTbaseEnvironmentFactory environmentFactory, @NonNull Transformation transformation) {
        super((EnvironmentFactoryInternal)environmentFactory);
        QVTiCG2StringVisitor.FACTORY.getClass();
        this.cgAnalyzer = new QVTiAnalyzer(this);
        this.transformation = transformation;
    }

    protected @NonNull QVTiAS2CGVisitor createAS2CGVisitor(@NonNull QVTiAnalyzer analyzer, @NonNull QVTiGlobalContext gContext) {
        return new QVTiAS2CGVisitor(analyzer, gContext);
    }

    public @NonNull AnalysisVisitor createAnalysisVisitor() {
        return new QVTiAnalysisVisitor(this.cgAnalyzer);
    }

    public @NonNull BoxingAnalyzer createBoxingAnalyzer() {
        return new QVTiBoxingAnalyzer(this.cgAnalyzer);
    }

    public @NonNull CG2JavaPreVisitor createCG2JavaPreVisitor() {
        return new QVTiCG2JavaPreVisitor(this.getGlobalContext());
    }

    protected @NonNull QVTiCG2JavaVisitor createCG2JavaVisitor(@NonNull CGPackage cgPackage, @Nullable List<@NonNull CGValuedElement> sortedGlobals) {
        return new QVTiCG2JavaVisitor(this, cgPackage, sortedGlobals);
    }

    protected @NonNull CGPackage createCGPackage() {
        QVTiAS2CGVisitor pivot2CGVisitor = this.createAS2CGVisitor(this.cgAnalyzer, this.getGlobalContext());
        CGTransformation cgTransformation = (CGTransformation)ClassUtil.nonNullState((Object)((CGNamedElement)this.transformation.accept((Visitor)pivot2CGVisitor)));
        CGPackage cgPackage = null;
        Package asPackage = this.transformation.getOwningPackage();
        while (asPackage != null) {
            CGPackage cgPackage2 = this.createCGPackage(asPackage);
            if (cgTransformation != null) {
                cgPackage2.getClasses().add(cgTransformation);
                cgTransformation = null;
            } else {
                cgPackage2.getPackages().add(cgPackage);
            }
            cgPackage = cgPackage2;
            asPackage = asPackage.getOwningPackage();
        }
        String packagePrefix = this.getOptions().getPackagePrefix();
        if (packagePrefix != null) {
            String[] segments = packagePrefix.split("\\.");
            int i = segments.length;
            while (--i >= 0) {
                String segment = segments[i];
                CGPackage cgPackage2 = CGModelFactory.eINSTANCE.createCGPackage();
                cgPackage2.setName(segment);
                cgPackage2.getPackages().add(cgPackage);
                cgPackage = cgPackage2;
            }
        }
        assert (cgPackage != null);
        return cgPackage;
    }

    protected @NonNull CGPackage createCGPackage(@NonNull Package asPackage) {
        CGPackage cgPackage = CGModelFactory.eINSTANCE.createCGPackage();
        String name = asPackage.getName();
        cgPackage.setName(name != null && name.length() > 0 ? name : "_" + this.transformation.getName());
        Package asParentPackage = asPackage.getOwningPackage();
        if (asParentPackage != null) {
            CGPackage cgParentPackage = this.createCGPackage(asParentPackage);
            cgParentPackage.getPackages().add(cgPackage);
        }
        return cgPackage;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull String createClassFileContent() {
        CGPackage cgPackage2;
        this.cgPackage = cgPackage2 = this.createCGPackage();
        this.optimize(cgPackage2);
        @NonNull List sortedGlobals = this.prepareGlobals();
        QVTiCG2JavaVisitor generator = this.createCG2JavaVisitor(cgPackage2, sortedGlobals);
        generator.safeVisit((CGElement)cgPackage2);
        ImportNameManager importNameManager = generator.getImportNameManager();
        @NonNull @Nullable Map long2ShortImportNames = importNameManager.getLong2ShortImportNames();
        String javaSourceCode2 = ImportUtils.resolveImports((String)generator.toString(), (Map)long2ShortImportNames, (boolean)false);
        return javaSourceCode2;
    }

    public @NonNull CGModelResourceFactory getCGResourceFactory() {
        return QVTiCGModelResourceFactory.INSTANCE;
    }

    public @NonNull DependencyVisitor createDependencyVisitor() {
        return new QVTiDependencyVisitor(this.cgAnalyzer, this.getGlobalContext(), this.getGlobalPlace());
    }

    public @NonNull FieldingAnalyzer createFieldingAnalyzer() {
        return new QVTiFieldingAnalyzer(this.cgAnalyzer);
    }

    public @NonNull ImportNameManager createImportNameManager() {
        return new JavaImportNameManager(){
            {
                this.reserveImportName(AbstractTransformer.class);
                this.reserveImportName(ExecutionVisitable.class);
                this.reserveImportName(Transformer.class);
                this.reserveImportName(AbstractTransformerInternal.Incremental.class);
                this.reserveImportName(AbstractTransformerInternal.Model.class);
            }
        };
    }

    protected @NonNull NameManager createNameManager() {
        return new NameManager(){

            public @Nullable String getNameHint(@NonNull Object anObject) {
                if (anObject instanceof CGValuedElement) {
                    anObject = ((CGValuedElement)anObject).getNamedValue();
                }
                if (anObject instanceof CGMappingLoop) {
                    return "loop";
                }
                return super.getNameHint(anObject);
            }
        };
    }

    protected @NonNull QVTiCodeGenOptions createOptions() {
        return new QVTiCodeGenOptions();
    }

    public @NonNull ReferencesVisitor createReferencesVisitor() {
        return QVTiReferencesVisitor.INSTANCE;
    }

    public @NonNull String generateClassFile() {
        String javaSourceCode2 = this.javaSourceCode;
        if (javaSourceCode2 == null) {
            this.javaSourceCode = javaSourceCode2 = CGUtil.trimLines((String)CGUtil.compressJDTannotations((String)this.createClassFileContent()));
        }
        return javaSourceCode2;
    }

    public @NonNull QVTiAnalyzer getAnalyzer() {
        return this.cgAnalyzer;
    }

    public @NonNull QVTiGlobalContext getGlobalContext() {
        return this.globalContext;
    }

    public @NonNull QVTiCodeGenOptions getOptions() {
        return (QVTiCodeGenOptions)super.getOptions();
    }

    public @NonNull String getQualifiedName() {
        StringBuilder s = new StringBuilder();
        CGPackage cgPackage = this.cgPackage;
        this.appendSegmentName(s, cgPackage);
        while (cgPackage.getPackages().size() > 0) {
            cgPackage = (CGPackage)cgPackage.getPackages().get(0);
            this.appendSegmentName(s, cgPackage);
        }
        s.append(this.transformation.getName());
        return s.toString();
    }

    private void appendSegmentName(@NonNull StringBuilder s, CGPackage sPackage) {
        String pName = sPackage.getName();
        if (pName != null && pName.length() > 0) {
            s.append(pName);
            s.append('.');
        }
    }

    public @NonNull QVTiTransformationAnalysis getTransformationAnalysis(@NonNull ImperativeTransformation transformation) {
        QVTiTransformationAnalysis transformationAnalysis = this.transformation2analysis.get(transformation);
        if (transformationAnalysis == null) {
            transformationAnalysis = new QVTiTransformationAnalysis(this.getEnvironmentFactory(), transformation);
            transformationAnalysis.analyzeTransformation();
            this.transformation2analysis.put((Transformation)transformation, transformationAnalysis);
        }
        return transformationAnalysis;
    }

    public @NonNull File saveSourceFile(@NonNull String savePath) throws IOException {
        File saveFile = new File(savePath);
        this.saveSourceFiles((CGPackage)ClassUtil.nonNullState((Object)this.cgPackage), saveFile);
        return saveFile;
    }

    public void saveSourceFiles(@NonNull CGPackage cgPackage, @NonNull File parentFolder) throws IOException {
        File folder = new File(parentFolder, cgPackage.getName());
        for (CGPackage cgChildPackage : cgPackage.getPackages()) {
            if (cgChildPackage == null) continue;
            this.saveSourceFiles(cgChildPackage, folder);
        }
        for (CGClass cgClass : cgPackage.getClasses()) {
            folder.mkdirs();
            String javaCodeSource = this.generateClassFile();
            FileWriter writer = new FileWriter(new File(folder, String.valueOf(cgClass.getName()) + ".java"));
            ((Writer)writer).append(javaCodeSource);
            ((Writer)writer).close();
        }
    }
}

