/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.compiler.CompilerOptions;

public abstract class AbstractCompilerOptions
implements CompilerOptions {
    private final @NonNull Map<@NonNull String, @Nullable CompilerOptions.StepOptions> options = new HashMap<String, CompilerOptions.StepOptions>();

    @Override
    public <T> @Nullable T basicGetOption(@NonNull String stepKey, @NonNull CompilerOptions.Key<T> optionKey) {
        CompilerOptions.StepOptions defaultOptions;
        CompilerOptions.StepOptions stepOptions = this.options.get(stepKey);
        if (stepOptions == null && !this.options.containsKey(stepKey)) {
            stepOptions = this.options.get("default");
        }
        T optionValue = null;
        if (stepOptions != null && (optionValue = (T)stepOptions.basicGet(optionKey)) == null && !stepOptions.containsKey(optionKey) && (defaultOptions = this.options.get("default")) != null) {
            optionValue = defaultOptions.basicGet(optionKey);
        }
        T castValue = optionValue;
        return castValue;
    }

    @Override
    public @Nullable CompilerOptions.StepOptions basicGetOptions(@NonNull String stepKey) {
        return this.options.get(stepKey);
    }

    @Override
    public <T> @NonNull T getOption(@NonNull String stepKey, @NonNull CompilerOptions.Key<T> optionKey) {
        CompilerOptions.StepOptions stepOptions = (CompilerOptions.StepOptions)ClassUtil.nonNullState((Object)this.options.get(stepKey));
        return stepOptions.get(optionKey);
    }

    @Override
    public <T> void setOption(@NonNull String stepKey, @NonNull CompilerOptions.Key<T> optionsKey, @Nullable T optionValue) {
        CompilerOptions.StepOptions stepOptions = this.options.get(stepKey);
        if (stepOptions == null) {
            stepOptions = new CompilerOptions.StepOptions(stepKey);
            this.options.put(stepKey, stepOptions);
        }
        stepOptions.put(optionsKey, optionValue);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        ArrayList<@NonNull String> keys = new ArrayList<String>(this.options.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            if (s.length() > 0) {
                s.append("\n");
            }
            s.append(String.valueOf(key) + " = " + this.options.get(key));
        }
        return s.toString();
    }
}

