/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.text.atl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.m2m.atl.adt.ui.editor.AtlEditor;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlCompletionDataSource;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlCompletionHelper;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlCompletionProposal;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlCompletionProposalComparator;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlModelAnalyser;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlParameterListValidator;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.ui.IEditorPart;

public class AtlCompletionProcessor
implements IContentAssistProcessor {
    private AtlCompletionHelper fHelper;
    private AtlCompletionProposalComparator fComparator;
    private AtlParameterListValidator fValidator;
    private AtlEditor fEditor;
    private AtlCompletionDataSource fDatasource;
    private char[] fProposalAutoActivationSet = new char[]{' '};
    private static String uriTagRegex = "^\\p{Space}*--\\p{Space}*@nsURI.*";
    private static String pathTagRegex = "^\\p{Space}*--\\p{Space}*@path.*";
    private static String compilerTagRegex = "^\\p{Space}*--\\p{Space}*@atlcompiler.*";

    public AtlCompletionProcessor(IEditorPart editor) {
        this.fEditor = (AtlEditor)editor;
        this.fDatasource = new AtlCompletionDataSource(this.fEditor);
        this.fComparator = new AtlCompletionProposalComparator();
        this.fHelper = new AtlCompletionHelper();
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer refViewer, int documentOffset) {
        try {
            ArrayList listProposals = new ArrayList();
            this.fHelper.setDocument(refViewer.getDocument());
            ITextSelection selection = (ITextSelection)refViewer.getSelectionProvider().getSelection();
            int offset = selection.getOffset() + selection.getLength();
            String prefix = this.fHelper.extractPrefix(offset);
            AtlModelAnalyser analyser = this.fHelper.computeContext(offset, prefix);
            listProposals.addAll(this.getProposalsFromAnalyser(analyser, prefix, offset));
            ICompletionProposal[] proposals = listProposals.toArray(new ICompletionProposal[listProposals.size()]);
            return proposals;
        }
        catch (BadLocationException e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    private Collection getProposalsFromAnalyser(AtlModelAnalyser analyser, String prefix, int offset) throws BadLocationException {
        block35: {
            block38: {
                String line;
                block32: {
                    block36: {
                        block37: {
                            block33: {
                                block34: {
                                    line = this.fHelper.getCurrentLine(offset);
                                    if (analyser.getContext() != 0) break block32;
                                    if (line.matches(compilerTagRegex)) {
                                        ArrayList<String> compilersNames = new ArrayList<String>();
                                        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.m2m.atl.engine.atlcompiler").getExtensions();
                                        int i = 0;
                                        while (i < extensions.length) {
                                            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                                            int j = 0;
                                            while (j < elements.length) {
                                                compilersNames.add(elements[j].getAttribute("name"));
                                                ++j;
                                            }
                                            ++i;
                                        }
                                        return AtlCompletionDataSource.getProposalsFromList(offset, prefix, compilersNames.toArray());
                                    }
                                    if (!line.matches(uriTagRegex)) break block33;
                                    if (prefix.indexOf("=") <= -1) break block34;
                                    if (prefix.split("=").length == 2) {
                                        String uriPrefix = prefix.split("=")[1];
                                        return this.fDatasource.getURIProposals(uriPrefix, offset);
                                    }
                                    if (prefix.endsWith("=")) {
                                        return this.fDatasource.getURIProposals("", offset);
                                    }
                                    break block35;
                                }
                                return this.fDatasource.getMetamodelsProposals(prefix, offset);
                            }
                            if (!line.matches(pathTagRegex)) break block36;
                            if (prefix.indexOf("=") <= -1) break block37;
                            if (prefix.split("=").length == 2) {
                                String uriPrefix = prefix.split("=")[1];
                                return this.fDatasource.getPathProposals(uriPrefix, offset);
                            }
                            if (prefix.endsWith("=")) {
                                return this.fDatasource.getPathProposals("", offset);
                            }
                            break block35;
                        }
                        return this.fDatasource.getMetamodelsProposals(prefix, offset);
                    }
                    String pathTemplate = "-- @path";
                    String uriTemplate = "-- @nsURI";
                    String compilerTemplate = "-- @atlcompiler";
                    return AtlCompletionDataSource.getProposalsFromList(offset, line, new String[]{pathTemplate, uriTemplate, compilerTemplate});
                }
                if (line.indexOf("--") != -1) break block35;
                EObject locatedElement = analyser.getLocatedElement(offset - prefix.length());
                if (locatedElement == null) break block38;
                switch (analyser.getContext()) {
                    case 2: {
                        if (AtlCompletionProcessor.oclIsKindOf(locatedElement, "OclModel") || AtlCompletionProcessor.oclIsKindOf(locatedElement, "OclType")) {
                            return this.fDatasource.getHelperTypesProposals(prefix, offset);
                        }
                        break block35;
                    }
                    case 4: {
                        if ((AtlCompletionProcessor.oclIsKindOf(locatedElement, "OclModel") || AtlCompletionProcessor.oclIsKindOf(locatedElement, "OclModelElement")) && analyser.getLostType("InPattern") != null) {
                            return this.fDatasource.getMetaElementsProposals(prefix, offset, 1);
                        }
                        break block35;
                    }
                    case 5: {
                        if (AtlCompletionProcessor.oclIsKindOf(locatedElement, "OclModel") || AtlCompletionProcessor.oclIsKindOf(locatedElement, "OclModelElement") || AtlCompletionProcessor.oclIsKindOf(locatedElement, "SimpleOutPatternElement")) {
                            return this.fDatasource.getMetaElementsProposals(prefix, offset, 2);
                        }
                        if (AtlCompletionProcessor.oclIsKindOf(locatedElement, "OutPattern")) {
                            if (analyser.getLostType("Binding") != null) {
                                EObject simpleOutPatternElement = analyser.getLostType("SimpleOutPatternElement");
                                EObject oclModelElement = (EObject)AtlCompletionDataSource.eGet(simpleOutPatternElement, "type");
                                ArrayList<String> existingBindings = new ArrayList<String>();
                                Collection bindings = (Collection)AtlCompletionDataSource.eGet(simpleOutPatternElement, "bindings");
                                for (EObject binding : bindings) {
                                    String ref = AtlCompletionDataSource.eGet(binding, "propertyName").toString();
                                    existingBindings.add(ref);
                                }
                                if (oclModelElement != null) {
                                    return this.fDatasource.getMetaFeaturesProposals(existingBindings, oclModelElement, prefix, offset);
                                }
                            }
                        } else if (this.fHelper.getCurrentLine(offset).indexOf("<-") > 0 && (AtlCompletionProcessor.oclIsKindOf(locatedElement, "Binding") || AtlCompletionProcessor.oclIsKindOf(locatedElement, "VariableExp") || AtlCompletionProcessor.oclIsKindOf(locatedElement, "NavigationOrAttributeCallExp"))) {
                            String[] analyzedExp = AtlCompletionProcessor.analyzeVariableExp(prefix);
                            if (analyzedExp[0].equals("")) {
                                return this.fDatasource.getVariablesProposals(analyser.getRootElement(), prefix, offset);
                            }
                            return this.fDatasource.getMetaFeaturesProposals(Collections.EMPTY_LIST, (EObject)AtlCompletionDataSource.getVariables(analyser.getRootElement()).get(analyzedExp[0]), analyzedExp[1], offset);
                        }
                        break block35;
                    }
                }
                break block35;
            }
            ArrayList<AtlCompletionProposal> res = new ArrayList<AtlCompletionProposal>();
            String helperTemplate = "helper context CONTEXT_TYPE def : NAME : TYPE = ";
            String ruleTemplate = "rule RULE_NAME {";
            String fromTemplate = "from VAR_NAME : MM!TYPE ";
            String toTemplate = "to VAR_NAME : MM!TYPE (";
            String doTemplate = "do {";
            String usingTemplate = "using {";
            switch (analyser.getContext()) {
                case 3: {
                    if (!fromTemplate.startsWith(prefix)) break;
                    AtlCompletionProposal fromProposal = new AtlCompletionProposal(fromTemplate, offset - prefix.length(), fromTemplate.length(), AtlCompletionDataSource.getImage("inPattern.gif"), "from", 0, null);
                    fromProposal.setCursorPosition(fromTemplate.length() - 19);
                    res.add(fromProposal);
                    break;
                }
                case 4: {
                    if (usingTemplate.startsWith(prefix)) {
                        res.add(new AtlCompletionProposal(usingTemplate, offset - prefix.length(), usingTemplate.length(), AtlCompletionDataSource.getImage("using.gif"), "using", 0, null));
                    }
                }
                case 7: {
                    if (!toTemplate.startsWith(prefix)) break;
                    AtlCompletionProposal toProposal = new AtlCompletionProposal(toTemplate, offset - prefix.length(), toTemplate.length(), AtlCompletionDataSource.getImage("outPattern.gif"), "to", 0, null);
                    toProposal.setCursorPosition(toTemplate.length() - 20);
                    res.add(toProposal);
                    break;
                }
                case 5: {
                    if (doTemplate.startsWith(prefix)) {
                        res.add(new AtlCompletionProposal(doTemplate, offset - prefix.length(), doTemplate.length(), AtlCompletionDataSource.getImage("imperative.gif"), "do", 0, null));
                    }
                }
                case 1: 
                case 6: {
                    if (ruleTemplate.startsWith(prefix)) {
                        AtlCompletionProposal ruleProposal = new AtlCompletionProposal(ruleTemplate, offset - prefix.length(), ruleTemplate.length(), AtlCompletionDataSource.getImage("matchedRule.gif"), "rule", 0, null);
                        ruleProposal.setCursorPosition(ruleTemplate.length() - 11);
                        res.add(ruleProposal);
                    }
                    if (!helperTemplate.startsWith(prefix)) break;
                    AtlCompletionProposal helperProposal = new AtlCompletionProposal(helperTemplate, offset - prefix.length(), helperTemplate.length(), AtlCompletionDataSource.getImage("helper.gif"), "helper", 0, null);
                    helperProposal.setCursorPosition(helperTemplate.length() - 33);
                    res.add(helperProposal);
                    break;
                }
            }
            return res;
        }
        return new ArrayList();
    }

    private static String[] analyzeVariableExp(String prefix) {
        String currentPrefix = prefix;
        currentPrefix = currentPrefix.replaceFirst("<-", "");
        String varName = "";
        String lastPrefix = "";
        if (currentPrefix.indexOf(".") > 0) {
            String[] splittedPrefix = currentPrefix.split("\\.");
            if (splittedPrefix.length > 0) {
                if (currentPrefix.endsWith(".")) {
                    varName = splittedPrefix[splittedPrefix.length - 1];
                    lastPrefix = "";
                } else {
                    varName = splittedPrefix[splittedPrefix.length - 2];
                    lastPrefix = splittedPrefix[splittedPrefix.length - 1];
                }
            }
        } else {
            lastPrefix = currentPrefix;
        }
        return new String[]{varName, lastPrefix};
    }

    private static boolean oclIsKindOf(EObject element, String testedElementName) {
        if (element.eClass().getName().equals(testedElementName)) {
            return true;
        }
        EList superTypList = element.eClass().getEAllSuperTypes();
        for (EClassifier object : superTypList) {
            if (!object.getName().equals(testedElementName)) continue;
            return true;
        }
        return false;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.fProposalAutoActivationSet;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        if (this.fValidator == null) {
            this.fValidator = new AtlParameterListValidator();
        }
        return this.fValidator;
    }

    public String getErrorMessage() {
        return "AtlEditor.codeassist.noCompletions";
    }

    public void orderProposalsAlphabetically(boolean order) {
        this.fComparator.setOrderAlphabetically(order);
    }

    public void restrictProposalsToMatchingCases(boolean restrict) {
    }

    public void restrictProposalsToVisibility(boolean restrict) {
    }

    public AtlCompletionDataSource getCompletionDatasource() {
        return this.fDatasource;
    }

    public void setCompletionProposalAutoActivationCharacters(char[] activationSet) {
        this.fProposalAutoActivationSet = activationSet;
    }
}

