/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.emfvm;

import org.eclipse.m2m.atl.engine.emfvm.ASMOperation;
import org.eclipse.m2m.atl.engine.emfvm.lib.ASMModule;
import org.eclipse.m2m.atl.engine.emfvm.lib.ExecEnv;
import org.eclipse.m2m.atl.engine.emfvm.lib.Operation;

public class StackFrame
extends org.eclipse.m2m.atl.engine.emfvm.lib.StackFrame {
    public int pc = -1;

    public StackFrame(ExecEnv execEnv, ASMModule asmModule, Operation operation) {
        super(execEnv, asmModule, operation);
    }

    protected StackFrame(StackFrame caller, Operation operation) {
        super(caller, operation);
    }

    public org.eclipse.m2m.atl.engine.emfvm.lib.StackFrame newFrame(Operation operation) {
        return new StackFrame(this, operation);
    }

    protected String getLocation() {
        String ret = ((ASMOperation)this.operation).resolveLineNumber(this.pc);
        if (ret == null) {
            ret = "";
        }
        ret = String.valueOf(ret) + "#" + this.pc;
        return ret;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        if (this.caller != null) {
            ret.append(this.caller.toString());
            ret.append('\n');
        }
        if (this.operation instanceof ASMOperation) {
            ret.append(((ASMOperation)this.operation).getName());
            if (this.operation instanceof ASMOperation) {
                ret.append(": ");
                ASMOperation ao = (ASMOperation)this.operation;
                String location = this.getLocation();
                if (location != null) {
                    ret.append(location);
                    ret.append(' ');
                }
                ret.append("\n\tlocal variables: ");
                boolean first = true;
                int i = 0;
                while (i < ao.maxLocals) {
                    String varName = ao.resolveVariableName(i, this.pc);
                    if (varName != null) {
                        if (!first) {
                            ret.append(", ");
                        }
                        first = false;
                        ret.append(varName);
                        ret.append('=');
                        ret.append(this.localVars[i]);
                    }
                    ++i;
                }
            }
        } else {
            ret.append("<native>");
        }
        return ret.toString();
    }
}

