/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotml.deployment;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.papyrus.robotml.deployment.Activator;
import org.eclipse.papyrus.robotml.deployment.StUtils;
import org.eclipse.papyrus.robotml.deployment.Utils;
import org.eclipse.papyrus.robotml.deployment.listener.CopyListener;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralNull;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.ValueSpecification;

public class Copy
extends EcoreUtil.Copier {
    private static final long serialVersionUID = -1664013545661635289L;
    public Package source;
    public Package target;
    public boolean copyExtReferences;
    private Namespace boundPackage;
    private Map<EObject, EObject> standardMap;
    private Map<EObject, EObject> templateMap;
    private Map<EObject, Map<EObject, EObject>> templateMapInfo;
    private Map<EObject, Boolean> shallowMap;
    private Stack<Namespace> boundPackages;
    public EList<CopyListener> preCopyListeners;
    public EList<CopyListener> postCopyListeners;

    public Copy(Package source_, Package target_, boolean copyExtResources_) {
        this.source = source_;
        this.target = target_;
        this.copyExtReferences = copyExtResources_;
        this.preCopyListeners = new BasicEList();
        this.postCopyListeners = new BasicEList();
        this.templateMapInfo = new HashMap<EObject, Map<EObject, EObject>>();
        this.standardMap = new HashMap<EObject, EObject>();
        this.shallowMap = new HashMap<EObject, Boolean>();
        this.boundPackages = new Stack();
        if (this.copyExtReferences) {
            Package newSourceRoot = this.target.createNestedPackage(this.source.getName());
            this.put((EObject)this.source, (EObject)newSourceRoot);
        } else {
            this.put((EObject)this.source, (EObject)this.target);
        }
    }

    public Map<EObject, EObject> getMap(EObject sourceEObj) {
        boolean withinTemplate = this.withinTemplate(sourceEObj);
        return withinTemplate ? this.templateMap : this.standardMap;
    }

    public EObject get(Object sourceEObj) {
        if (sourceEObj instanceof EObject) {
            Map<EObject, EObject> map = this.getMap((EObject)sourceEObj);
            return map.get(sourceEObj);
        }
        return null;
    }

    public EObject put(EObject sourceEObj, EObject targetEObj) {
        if (sourceEObj instanceof EObject) {
            Map<EObject, EObject> map = this.getMap(sourceEObj);
            return map.put(sourceEObj, targetEObj);
        }
        return null;
    }

    public boolean containsKey(Object sourceEObj) {
        if (sourceEObj instanceof EObject) {
            Map<EObject, EObject> map = this.getMap((EObject)sourceEObj);
            return map.containsKey(sourceEObj);
        }
        return false;
    }

    public EObject remove(Object sourceEObj) {
        if (sourceEObj instanceof EObject) {
            Map<EObject, EObject> map = this.getMap((EObject)sourceEObj);
            return map.remove(sourceEObj);
        }
        return null;
    }

    public void setShallow(EObject targetEObj, boolean isShallow) {
        this.shallowMap.put(targetEObj, isShallow);
    }

    public boolean isShallow(EObject targetEObj) {
        Boolean shallow = this.shallowMap.get(targetEObj);
        if (shallow != null) {
            return shallow;
        }
        return false;
    }

    public void setPackageTemplate(Namespace packageTemplate, Namespace boundPackage) {
        this.boundPackage = boundPackage;
        if (packageTemplate == null) {
            return;
        }
        this.templateMap = this.templateMapInfo.get(boundPackage);
        if (this.templateMap == null) {
            this.templateMap = new HashMap<EObject, EObject>();
            this.templateMapInfo.put((EObject)boundPackage, this.templateMap);
        }
        this.standardMap.put((EObject)packageTemplate, (EObject)boundPackage);
    }

    public void pushPackageTemplate() {
        this.boundPackages.push(this.boundPackage);
    }

    public void popPackageTemplate() {
        this.boundPackage = this.boundPackages.pop();
        this.templateMap = this.templateMapInfo.get(this.boundPackage);
    }

    public void removeForCopy(EObject element) {
        this.templateMap.remove(element);
        EClass eClass = element.eClass();
        int i = 0;
        int size = eClass.getFeatureCount();
        while (i < size) {
            EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(i);
            if (eStructuralFeature.isChangeable() && !eStructuralFeature.isDerived() && !(eStructuralFeature instanceof EAttribute)) {
                EReference eReference = (EReference)eStructuralFeature;
                if (eReference.isContainment()) {
                    for (EObject ref : this.getRefs(eReference, element)) {
                        this.removeForCopy(ref);
                    }
                } else {
                    eReference.isContainer();
                }
            }
            ++i;
        }
    }

    public EList<EObject> getRefs(EReference eReference, EObject eObject) {
        BasicEList refs = new BasicEList();
        if (eObject.eIsSet((EStructuralFeature)eReference)) {
            if (eReference.isMany()) {
                refs.addAll((Collection)((List)eObject.eGet((EStructuralFeature)eReference)));
            } else {
                refs.add((Object)((EObject)eObject.eGet((EStructuralFeature)eReference)));
            }
        }
        return refs;
    }

    public boolean withinTemplate(EObject element) {
        if (this.boundPackage != null) {
            EObject owner = element;
            while (owner != null) {
                if (this.get(owner = owner.eContainer()) != this.boundPackage) continue;
                return true;
            }
        }
        return false;
    }

    public EObject copy(EObject sourceEObj) {
        boolean sameResource;
        boolean shallowCopy;
        boolean withinTemplate = this.withinTemplate(sourceEObj);
        EObject targetEObj = this.get(sourceEObj);
        boolean bl = shallowCopy = targetEObj != null && this.isShallow(targetEObj);
        if (targetEObj != null && !shallowCopy) {
            return targetEObj;
        }
        this.setShallow(targetEObj, false);
        if (sourceEObj == null) {
            return null;
        }
        boolean bl2 = sameResource = sourceEObj.eResource() == this.source.eResource();
        if (!(sameResource || this.copyExtReferences || withinTemplate)) {
            return sourceEObj;
        }
        if (sourceEObj instanceof Stereotype) {
            return sourceEObj;
        }
        for (CopyListener listener : this.preCopyListeners) {
            EObject result = listener.copyEObject(this, sourceEObj);
            if (result == sourceEObj) continue;
            return result;
        }
        if (sourceEObj instanceof NamedElement) {
            String name = ((NamedElement)sourceEObj).getQualifiedName();
            if (name != null && name.startsWith("uml::")) {
                return sourceEObj;
            }
            if (name != null && name.startsWith("ProducerConsumer") && Utils.getTop((Element)((NamedElement)sourceEObj)) != this.source) {
                System.err.println(name);
            }
        }
        if (sourceEObj instanceof Package && !withinTemplate && ((Package)sourceEObj).getOwnedTemplateSignature() != null) {
            Activator.log.warn("warning: copying a package template without instantiating a template");
        }
        if (!shallowCopy) {
            targetEObj = this.createCopy(sourceEObj);
            this.put(sourceEObj, targetEObj);
            this.createShallowContainer(sourceEObj);
        }
        EClass eClass = sourceEObj.eClass();
        int i = 0;
        int size = eClass.getFeatureCount();
        while (i < size) {
            EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(i);
            if (eStructuralFeature.isChangeable() && !eStructuralFeature.isDerived()) {
                if (eStructuralFeature instanceof EAttribute) {
                    this.copyAttribute((EAttribute)eStructuralFeature, sourceEObj, targetEObj);
                } else {
                    EReference eReference = (EReference)eStructuralFeature;
                    if (eReference.isContainment()) {
                        this.copyContainment(eReference, sourceEObj, targetEObj);
                    } else if (!eReference.getName().equals("owner")) {
                        Object feature = sourceEObj.eGet(eStructuralFeature);
                        if (feature instanceof Element) {
                            this.copy((EObject)((Element)feature));
                        } else if (feature instanceof EList) {
                            this.copyAll((Collection)((EList)feature));
                        }
                        this.copyReference(eReference, sourceEObj, targetEObj);
                    }
                }
            }
            ++i;
        }
        this.copyProxyURI(sourceEObj, targetEObj);
        Copy.copyID(sourceEObj, targetEObj);
        if (sourceEObj instanceof Element) {
            StUtils.copyStereotypes(this, (Element)sourceEObj, (Element)targetEObj);
        }
        for (CopyListener listener : this.postCopyListeners) {
            EObject result = listener.copyEObject(this, targetEObj);
            if (result == targetEObj) continue;
            return result;
        }
        return targetEObj;
    }

    protected void copyContainment(EReference eReference, EObject eObject, EObject copyEObject) {
        if (eObject.eIsSet((EStructuralFeature)eReference)) {
            if (eReference.isMany()) {
                List source = (List)eObject.eGet((EStructuralFeature)eReference);
                List target = (List)copyEObject.eGet(this.getTarget((EStructuralFeature)eReference));
                if (!source.isEmpty()) {
                    for (EObject copyEObj : this.copyAll(source)) {
                        if (copyEObj == null) continue;
                        target.add(copyEObj);
                    }
                }
            } else {
                EObject childEObject = (EObject)eObject.eGet((EStructuralFeature)eReference);
                copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), childEObject == null ? null : this.copy(childEObject));
            }
        }
    }

    protected void shallowCopyContainment(EReference eReference, EObject eObject, EObject copyEObject) {
        if (eObject.eIsSet((EStructuralFeature)eReference)) {
            if (eReference.isMany()) {
                List source = (List)eObject.eGet((EStructuralFeature)eReference);
                List target = (List)copyEObject.eGet(this.getTarget((EStructuralFeature)eReference));
                if (source.isEmpty()) {
                    target.clear();
                } else {
                    for (EObject sourceEObj : source) {
                        EObject copyEObj = this.get(sourceEObj);
                        if (copyEObj == null || target.contains(copyEObj)) continue;
                        target.add(copyEObj);
                    }
                }
            } else {
                EObject childEObject = (EObject)eObject.eGet((EStructuralFeature)eReference);
                copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), childEObject == null ? null : this.copy(childEObject));
            }
        }
    }

    public void createShallowContainer(EObject sourceEObj) {
        EObject owner = sourceEObj.eContainer();
        EObject copy = null;
        while (owner != null) {
            if (this.containsKey(owner)) {
                this.shallowCopy(owner);
                return;
            }
            copy = this.shallowCopy(owner);
            if (copy instanceof NamedElement) {
                ((NamedElement)copy).setName(((NamedElement)owner).getName());
            }
            owner = owner.eContainer();
        }
        if (copy instanceof PackageableElement) {
            this.target.getPackagedElements().add((Object)((PackageableElement)copy));
        }
    }

    public EObject shallowCopy(EObject sourceEObj) {
        EObject targetEObj = this.get(sourceEObj);
        if (targetEObj == null) {
            targetEObj = this.createCopy(sourceEObj);
            this.put(sourceEObj, targetEObj);
            this.setShallow(targetEObj, true);
        }
        if (sourceEObj instanceof Element && targetEObj instanceof Element) {
            StUtils.copyStereotypes(this, (Element)sourceEObj, (Element)targetEObj);
        }
        EClass eClass = sourceEObj.eClass();
        int i = 0;
        int size = eClass.getFeatureCount();
        while (i < size) {
            EReference eReference;
            EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(i);
            if (eStructuralFeature.isChangeable() && !eStructuralFeature.isDerived() && !(eStructuralFeature instanceof EAttribute) && (eReference = (EReference)eStructuralFeature).isContainment()) {
                this.shallowCopyContainment(eReference, sourceEObj, targetEObj);
            }
            ++i;
        }
        return targetEObj;
    }

    public <T extends Element> T getCopy(T source) {
        return (T)((Element)this.copy((EObject)source));
    }

    protected void copyReference(EReference eReference, EObject eObject, EObject copyEObject) {
        if (eObject.eIsSet((EStructuralFeature)eReference)) {
            if (eReference.isMany()) {
                InternalEList source = (InternalEList)eObject.eGet((EStructuralFeature)eReference);
                InternalEList target = (InternalEList)copyEObject.eGet(this.getTarget((EStructuralFeature)eReference));
                if (source.isEmpty()) {
                    target.clear();
                } else {
                    boolean isBidirectional = eReference.getEOpposite() != null;
                    int index = 0;
                    Iterator k = this.resolveProxies ? source.iterator() : source.basicIterator();
                    while (k.hasNext()) {
                        EObject referencedEObject = (EObject)k.next();
                        EObject copyReferencedEObject = this.get(referencedEObject);
                        if (copyReferencedEObject == null) {
                            if (!this.useOriginalReferences || isBidirectional) continue;
                            target.addUnique(index, (Object)referencedEObject);
                            ++index;
                            continue;
                        }
                        if (isBidirectional) {
                            int position = target.indexOf((Object)copyReferencedEObject);
                            if (position == -1) {
                                target.addUnique(index, (Object)copyReferencedEObject);
                            } else if (index != position) {
                                target.move(index, (Object)copyReferencedEObject);
                            }
                        } else if (!target.contains((Object)copyReferencedEObject)) {
                            target.addUnique(index, (Object)copyReferencedEObject);
                        }
                        ++index;
                    }
                }
            } else {
                EObject copyReferencedEObject;
                Object referencedEObject = eObject.eGet((EStructuralFeature)eReference, this.resolveProxies);
                if (referencedEObject == null) {
                    copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), null);
                } else if (referencedEObject instanceof EObject && (copyReferencedEObject = this.copy((EObject)referencedEObject)) != null) {
                    copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), (Object)copyReferencedEObject);
                }
            }
        }
    }

    public void copyMethods(Class source) {
        for (Behavior method : source.getOwnedBehaviors()) {
            this.getCopy(method);
        }
    }

    public void copyAttributes(Classifier source) {
        for (Property attribute : source.getAttributes()) {
            this.getCopy(attribute);
        }
    }

    public void copyOperations(Classifier source) {
        for (Operation operation : source.getOperations()) {
            this.getCopy(operation);
        }
    }

    public static void copyFeatureModifiers(Feature source, Feature target) {
        target.setIsStatic(source.isStatic());
        target.setIsLeaf(source.isLeaf());
    }

    public static void copyMultElemModifiers(MultiplicityElement source, MultiplicityElement target) {
        target.setIsOrdered(source.isOrdered());
        target.setIsUnique(source.isUnique());
        target.setLower(source.getLower());
        target.setUpper(source.getUpper());
    }

    public static ValueSpecification copyValue(ValueSpecification value, Slot target) {
        ValueSpecification newValue = target.createValue(value.getName(), value.getType(), value.eClass());
        return Copy.copyValue(value, newValue);
    }

    public static ValueSpecification copyDefaultValue(Property source, Property target) {
        ValueSpecification value = source.getDefaultValue();
        if (value != null) {
            ValueSpecification newValue = target.createDefaultValue(value.getName(), value.getType(), value.eClass());
            return Copy.copyValue(value, newValue);
        }
        return null;
    }

    public static ValueSpecification copyValue(ValueSpecification smValue, ValueSpecification tmValue) {
        if (smValue instanceof OpaqueExpression) {
            OpaqueExpression oeValue = (OpaqueExpression)smValue;
            OpaqueExpression noeValue = (OpaqueExpression)tmValue;
            for (String language : oeValue.getLanguages()) {
                noeValue.getLanguages().add((Object)language);
            }
            for (String body : oeValue.getBodies()) {
                noeValue.getBodies().add((Object)body);
            }
        } else if (smValue instanceof LiteralString) {
            ((LiteralString)tmValue).setValue(((LiteralString)smValue).getValue());
        } else if (smValue instanceof LiteralInteger) {
            ((LiteralInteger)tmValue).setValue(((LiteralInteger)smValue).getValue());
        } else if (smValue instanceof LiteralUnlimitedNatural) {
            ((LiteralUnlimitedNatural)tmValue).setValue(((LiteralUnlimitedNatural)smValue).getValue());
        } else if (smValue instanceof LiteralBoolean) {
            ((LiteralBoolean)tmValue).setValue(((LiteralBoolean)smValue).booleanValue());
        } else {
            boolean cfr_ignored_0 = smValue instanceof LiteralNull;
        }
        return tmValue;
    }

    public static void copyID(EObject source, EObject target) {
        Copy.copyID(source, target, "");
    }

    public static void copyID(EObject source, EObject target, String prefix) {
        Resource resourceSource = source.eResource();
        Resource resourceTarget = target.eResource();
        if (resourceSource instanceof XMLResource && resourceTarget instanceof XMLResource) {
            XMLResource xmlResSource = (XMLResource)resourceSource;
            XMLResource xmlResTarget = (XMLResource)resourceTarget;
            String id = String.valueOf(prefix) + xmlResSource.getID(source);
            int counter = 0;
            String uniqueID = id;
            while (xmlResTarget.getIDToEObjectMap().containsKey(uniqueID)) {
                uniqueID = String.valueOf(id) + counter;
                ++counter;
            }
            xmlResTarget.setID(target, uniqueID);
        }
    }
}

