/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.middleend.xtend;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.xtend.backend.BackendFacade;
import org.eclipse.xtend.backend.common.BackendTypesystem;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.FunctionDefContext;
import org.eclipse.xtend.backend.common.QualifiedName;
import org.eclipse.xtend.expression.ExecutionContextImpl;
import org.eclipse.xtend.middleend.LanguageContributor;
import org.eclipse.xtend.middleend.MiddleEnd;
import org.eclipse.xtend.middleend.MiddleEndFactory;
import org.eclipse.xtend.middleend.xtend.OldHelper;
import org.eclipse.xtend.middleend.xtend.internal.xtend.CheckConverter;
import org.eclipse.xtend.middleend.xtend.plugin.OldCheckRegistryFactory;
import org.eclipse.xtend.middleend.xtend.plugin.OldXtendRegistryFactory;
import org.eclipse.xtend.typesystem.MetaModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckBackendFacade {
    private final String _checkFile;
    private final MiddleEnd _middleEnd;

    public static void checkAll(String xtendFileName, Collection<MetaModel> mms, Issues issues, Collection<?> allObjects) {
        CheckBackendFacade.checkAll(xtendFileName, null, mms, issues, allObjects);
    }

    public static void checkAll(String checkFileName, String fileEncoding, Collection<MetaModel> mms, Issues issues, Collection<?> allObjects) {
        CheckBackendFacade.invokeCheckFunction(checkFileName, fileEncoding, mms, CheckConverter.ALL_CHECKS_FUNCTION_NAME, issues, allObjects);
    }

    public static Object invokeCheckFunction(String checkFileName, String fileEncoding, Collection<MetaModel> mms, QualifiedName functionName, Object ... parameters) {
        return CheckBackendFacade.createForFile(checkFileName, fileEncoding, mms).invokeCheckFunction(functionName, parameters);
    }

    public Object invokeCheckFunction(QualifiedName functionName, Object ... parameters) {
        FunctionDefContext fdc = this._middleEnd.getFunctions(this._checkFile);
        ExecutionContext ctx = BackendFacade.createExecutionContext((FunctionDefContext)fdc, (BackendTypesystem)this._middleEnd.getTypesystem(), (boolean)true);
        return fdc.invoke(ctx, functionName, Arrays.asList(parameters));
    }

    public static CheckBackendFacade createForFile(String checkFileName, String fileEncoding, Collection<MetaModel> mms) {
        return new CheckBackendFacade(checkFileName, fileEncoding, mms);
    }

    private Map<Class<?>, Object> getSpecificParameters(String fileEncoding, Collection<MetaModel> mms) {
        fileEncoding = OldHelper.normalizedFileEncoding(fileEncoding);
        ExecutionContextImpl ctx = new ExecutionContextImpl();
        ctx.getResourceManager().setFileEncoding(fileEncoding);
        for (MetaModel mm : mms) {
            ctx.registerMetaModel(mm);
        }
        HashMap result = new HashMap();
        result.put(OldXtendRegistryFactory.class, ctx);
        result.put(OldCheckRegistryFactory.class, ctx);
        return result;
    }

    private CheckBackendFacade(String checkFileName, String fileEncoding, Collection<MetaModel> mms) {
        if (mms == null) {
            mms = new ArrayList<MetaModel>();
        }
        this._checkFile = OldHelper.normalizeCheckResourceName(checkFileName);
        if (LanguageContributor.INSTANCE.getLanguageContributionByName("Xtend") == null) {
            LanguageContributor.INSTANCE.addLanguageContribution(OldXtendRegistryFactory.class);
        }
        if (LanguageContributor.INSTANCE.getLanguageContributionByName("Check") == null) {
            LanguageContributor.INSTANCE.addLanguageContribution(OldCheckRegistryFactory.class);
        }
        this._middleEnd = MiddleEndFactory.canCreateFromExtentions() ? MiddleEndFactory.createFromExtensions((BackendTypesystem)OldHelper.guessTypesystem(mms), this.getSpecificParameters(fileEncoding, mms)) : MiddleEndFactory.create((BackendTypesystem)OldHelper.guessTypesystem(mms), (List)LanguageContributor.INSTANCE.getFreshMiddleEnds(this.getSpecificParameters(fileEncoding, mms)));
    }

    public FunctionDefContext getFunctionDefContext() {
        return this._middleEnd.getFunctions(this._checkFile);
    }
}

