/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.editor.search.view;

import org.eclipse.core.resources.IFile;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtend.shared.ui.Activator;

public class EditorOpener {
    private IEditorPart fEditor;

    public IEditorPart open(IFile file, boolean activate) throws PartInitException {
        IWorkbenchPage wbPage = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (NewSearchUI.reuseEditor()) {
            return this.showWithReuse(file, wbPage, activate);
        }
        return this.showWithoutReuse(file, wbPage, activate);
    }

    private IEditorPart showWithoutReuse(IFile file, IWorkbenchPage wbPage, boolean activate) throws PartInitException {
        return IDE.openEditor((IWorkbenchPage)wbPage, (IFile)file, (boolean)activate);
    }

    private IEditorPart showWithReuse(IFile file, IWorkbenchPage wbPage, boolean activate) throws PartInitException {
        String editorID = this.getEditorID(file);
        return this.showInEditor(wbPage, file, editorID, activate);
    }

    private String getEditorID(IFile file) throws PartInitException {
        IEditorDescriptor desc = IDE.getEditorDescriptor((IFile)file);
        if (desc == null) {
            return Activator.getDefault().getWorkbench().getEditorRegistry().findEditor("org.eclipse.ui.systemExternalEditor").getId();
        }
        return desc.getId();
    }

    private boolean isPinned(IEditorPart editor) {
        if (editor == null) {
            return false;
        }
        IEditorReference[] editorRefs = editor.getEditorSite().getPage().getEditorReferences();
        int i = 0;
        while (i < editorRefs.length) {
            if (editor.equals(editorRefs[i].getEditor(false))) {
                return editorRefs[i].isPinned();
            }
            ++i;
        }
        return false;
    }

    private IEditorPart showInEditor(IWorkbenchPage page, IFile file, String editorId, boolean activate) throws PartInitException {
        FileEditorInput input = new FileEditorInput(file);
        IEditorPart editor = page.findEditor((IEditorInput)input);
        if (editor != null) {
            page.bringToTop((IWorkbenchPart)editor);
            if (activate) {
                page.activate((IWorkbenchPart)editor);
            }
        } else {
            boolean showsSameInputType;
            boolean isOpen = false;
            if (this.fEditor != null) {
                IEditorReference[] parts = page.getEditorReferences();
                int i = 0;
                while (!isOpen && i < parts.length) {
                    boolean bl = isOpen = this.fEditor == parts[i++].getEditor(false);
                }
            }
            boolean canBeReused = isOpen && !this.fEditor.isDirty() && !this.isPinned(this.fEditor);
            boolean bl = showsSameInputType = this.fEditor != null && this.fEditor.getSite().getId().equals(editorId);
            if (canBeReused && !showsSameInputType) {
                page.closeEditor(this.fEditor, false);
                this.fEditor = null;
            }
            if (canBeReused && showsSameInputType) {
                ((IReusableEditor)this.fEditor).setInput((IEditorInput)input);
                page.bringToTop((IWorkbenchPart)this.fEditor);
                editor = this.fEditor;
                if (activate) {
                    page.activate((IWorkbenchPart)editor);
                }
            } else {
                editor = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)activate);
                this.fEditor = editor instanceof IReusableEditor ? editor : null;
            }
        }
        return editor;
    }
}

