/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.wizards.strategy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

public class Hierarchy {
    private final List myRefs;
    private final EPackage myDomainModel;
    private final Map myResult;
    private Set myAccessibleLeaves;
    private Set myAccessibleClasses = new HashSet();
    private Set myAccessibleLinkClasses = new HashSet();
    private Set myLinkClassContainmentRefs = new HashSet();
    private final EClass myDiagramContainer;

    public Hierarchy(List eRefs, EClass diagramContainer, EPackage domainModel) {
        this.myRefs = eRefs;
        this.myDiagramContainer = diagramContainer;
        this.myDomainModel = domainModel;
        this.myResult = new HashMap();
        Iterator iter = eRefs.iterator();
        while (iter.hasNext()) {
            EReference element = (EReference)iter.next();
            this.myResult.put(element.getEReferenceType(), new HashSet());
        }
    }

    public Hierarchy(EClass diagramContainer) {
        this((List)diagramContainer.getEAllContainments(), diagramContainer, diagramContainer.getEPackage());
    }

    public Hierarchy(EClass diagramContainer, EPackage domainModel) {
        this((List)diagramContainer.getEAllContainments(), diagramContainer, domainModel);
    }

    public EClass getDiagramContainer() {
        return this.myDiagramContainer;
    }

    public EReference nodeBackRef(EClass nodeElement) {
        Iterator it2 = this.myRefs.iterator();
        while (it2.hasNext()) {
            EReference r = (EReference)it2.next();
            if (!r.getEReferenceType().isSuperTypeOf(nodeElement)) continue;
            return r;
        }
        return null;
    }

    public EReference linkBackRef(EClass linkElement) {
        EReference r;
        ArrayList<EReference> compatible = new ArrayList<EReference>();
        Iterator it = this.myLinkClassContainmentRefs.iterator();
        while (it.hasNext()) {
            r = (EReference)it.next();
            if (!r.getEReferenceType().isSuperTypeOf(linkElement)) continue;
            compatible.add(r);
        }
        if (compatible.isEmpty()) {
            return null;
        }
        int i = compatible.size() - 1;
        while (i >= 0) {
            r = (EReference)compatible.get(i);
            if (r.getEReferenceType().equals(linkElement)) {
                return r;
            }
            --i;
        }
        return (EReference)compatible.get(0);
    }

    public boolean isLeaf(EClass element) {
        return this.myAccessibleLeaves.contains(element);
    }

    public EReference getLinkFeature(EClass element) {
        BasicEList l = this.collectAllNonContainment(element);
        if (l.isEmpty()) {
            return null;
        }
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            EReference ref = (EReference)iter.next();
            if (element.isSuperTypeOf(ref.getEReferenceType())) continue;
            Iterator it2 = this.myResult.keySet().iterator();
            while (it2.hasNext()) {
                EClass c = (EClass)it2.next();
                if (!c.isSuperTypeOf(ref.getEReferenceType()) && !ref.getEReferenceType().isSuperTypeOf(c)) continue;
                return ref;
            }
        }
        return null;
    }

    public void collect() {
        this.collect(true);
    }

    void collect(boolean recurse) {
        HashSet nonLeaves = new HashSet();
        HashSet leavesSet = new HashSet();
        Iterator it = this.myDomainModel.getEClassifiers().iterator();
        while (it.hasNext()) {
            Object next = it.next();
            if (!(next instanceof EClass)) continue;
            EClass eClass = (EClass)next;
            Iterator it2 = this.myResult.entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry entry = it2.next();
                EClass element = (EClass)entry.getKey();
                if (!element.isSuperTypeOf(eClass)) continue;
                ((Set)entry.getValue()).add(eClass);
                if (recurse) {
                    Hierarchy h2 = new Hierarchy((List)eClass.getEAllContainments(), null, this.myDomainModel);
                    h2.collect(false);
                    this.myLinkClassContainmentRefs.addAll(eClass.getEAllContainments());
                    this.myAccessibleLinkClasses.addAll(h2.getAccessibleClasses());
                    leavesSet.addAll(h2.myAccessibleLeaves);
                }
                if (!eClass.isAbstract() && !eClass.isInterface()) {
                    this.myAccessibleClasses.add(eClass);
                }
                nonLeaves.addAll(eClass.getESuperTypes());
            }
        }
        leavesSet.addAll(this.myAccessibleClasses);
        leavesSet.removeAll(nonLeaves);
        this.myAccessibleLeaves = Collections.unmodifiableSet(leavesSet);
        this.myAccessibleClasses = Collections.unmodifiableSet(this.myAccessibleClasses);
        this.myAccessibleLinkClasses = Collections.unmodifiableSet(this.myAccessibleLinkClasses);
    }

    public Set getAllClasses() {
        HashSet rv = new HashSet();
        Iterator it = this.myResult.values().iterator();
        while (it.hasNext()) {
            Set next = (Set)it.next();
            rv.addAll(next);
        }
        return rv;
    }

    public Set getAccessibleClasses() {
        return this.myAccessibleClasses;
    }

    public Set getAccessibleLinkClasses() {
        return this.myAccessibleLinkClasses;
    }

    public Set getAccessibleReferences() {
        return this.getAccessibleReferences(this.myAccessibleClasses.iterator());
    }

    public Set getAccessibleReferences(Iterator iter) {
        HashSet rv = new HashSet();
        while (iter.hasNext()) {
            EClass element = (EClass)iter.next();
            rv.addAll(this.collectAllNonContainment(element));
        }
        return rv;
    }

    BasicEList collectAllNonContainment(EClass element) {
        BasicEList l = new BasicEList((Collection)element.getEAllReferences());
        l.removeAll((Collection)element.getEAllContainments());
        return l;
    }
}

