/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.transform;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.gmfgraph.util.FigureQualifiedNameSwitch;
import org.eclipse.gmf.gmfgraph.util.RuntimeFQNSwitch;
import org.eclipse.gmf.gmfgraph.util.RuntimeLiteFQNSwitch;
import org.eclipse.gmf.graphdef.codegen.MapModeCodeGenStrategy;
import org.eclipse.gmf.internal.bridge.VisualIdentifierDispenser;
import org.eclipse.gmf.internal.bridge.genmodel.BasicDiagramRunTimeModelHelper;
import org.eclipse.gmf.internal.bridge.genmodel.DiagramGenModelTransformer;
import org.eclipse.gmf.internal.bridge.genmodel.DiagramRunTimeModelHelper;
import org.eclipse.gmf.internal.bridge.genmodel.GenModelProducer;
import org.eclipse.gmf.internal.bridge.genmodel.InnerClassViewmapProducer;
import org.eclipse.gmf.internal.bridge.genmodel.ViewmapProducer;
import org.eclipse.gmf.internal.bridge.naming.gen.GenModelNamingMediator;
import org.eclipse.gmf.internal.bridge.naming.gen.GenModelNamingMediatorImpl;
import org.eclipse.gmf.internal.bridge.transform.GenModelDetector;
import org.eclipse.gmf.internal.bridge.transform.Messages;
import org.eclipse.gmf.internal.bridge.transform.StaleGenModelDetector;
import org.eclipse.gmf.internal.bridge.transform.TransformOptions;
import org.eclipse.gmf.internal.bridge.transform.ValidationHelper;
import org.eclipse.gmf.internal.bridge.transform.VisualIdentifierDispenserProvider;
import org.eclipse.gmf.internal.bridge.ui.Plugin;
import org.eclipse.gmf.internal.common.migrate.ModelLoadHelper;
import org.eclipse.gmf.internal.common.reconcile.Reconciler;
import org.eclipse.gmf.internal.common.reconcile.ReconcilerConfig;
import org.eclipse.gmf.internal.util.GMFGenConfig;
import org.eclipse.gmf.mappings.Mapping;

public class TransformToGenModelOperation {
    private URI myGMFGenModelURI;
    private TransformOptions myOptions;
    private Mapping myMapping;
    private GenModelDetector myGMDetector;
    private GenModel myGenModel;
    private IStatus myLoadMapmodelStatus = Status.CANCEL_STATUS;
    private IStatus myStaleGenmodelStatus = Status.CANCEL_STATUS;

    public TransformToGenModelOperation() {
        this.myOptions = new TransformOptions();
    }

    public TransformOptions getOptions() {
        return this.myOptions;
    }

    public URI getGenURI() {
        return this.myGMFGenModelURI;
    }

    public void setGenURI(URI gmfGen) {
        this.myGMFGenModelURI = gmfGen;
    }

    public GenModel getGenModel() {
        return this.myGenModel;
    }

    Mapping getMapping() {
        return this.myMapping;
    }

    private void setMapping(Mapping m, IStatus loadStatus) {
        this.myMapping = m;
        this.myLoadMapmodelStatus = loadStatus;
        this.myGMDetector = m != null ? new GenModelDetector(m) : null;
        this.myGenModel = null;
    }

    public GenModelDetector getGenModelDetector() {
        return this.myGMDetector;
    }

    public IStatus getLoadMappingStatus() {
        return this.myLoadMapmodelStatus;
    }

    public IStatus getStaleGenmodelStatus() {
        return this.myStaleGenmodelStatus;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Mapping loadMappingModel(ResourceSet rs, URI uri, IProgressMonitor pm) throws CoreException {
        Mapping mapping;
        block11: {
            Mapping content = null;
            IStatus status = Status.CANCEL_STATUS;
            SubProgressMonitor monitor = null;
            try {
                this.checkResourceSet(rs);
                if (uri == null) {
                    throw new IllegalArgumentException(Messages.TransformToGenModelOperation_e_null_map_uri);
                }
                monitor = pm != null ? new SubProgressMonitor(pm, 1, 4) : new NullProgressMonitor();
                String cancelMessage = Messages.TransformToGenModelOperation_e_map_load_cancelled;
                monitor.beginTask("", 100);
                TransformToGenModelOperation.subTask((IProgressMonitor)monitor, 0, Messages.TransformToGenModelOperation_task_load, cancelMessage);
                ModelLoadHelper loadHelper = new ModelLoadHelper(rs, uri);
                status = loadHelper.getStatus();
                if (!status.isOK()) {
                    throw new CoreException(status);
                }
                TransformToGenModelOperation.subTask((IProgressMonitor)monitor, 20, Messages.TransformToGenModelOperation_task_validate, cancelMessage);
                EObject root = loadHelper.getContentsRoot();
                if (!(root instanceof Mapping)) {
                    String msg = MessageFormat.format(Messages.TransformToGenModelOperation_e_wrong_root_element, root.getClass().getName());
                    status = Plugin.createError(msg, null);
                    throw new CoreException(status);
                }
                content = (Mapping)loadHelper.getContentsRoot();
                Diagnostic mapIsValid = ValidationHelper.validate((EObject)content, true, (IProgressMonitor)monitor);
                monitor.worked(60);
                status = this.getFirst(mapIsValid);
                if (8 == status.getSeverity()) {
                    throw new CoreException(Plugin.createCancel(cancelMessage));
                }
                if (4 == status.getSeverity()) {
                    throw new CoreException(status);
                }
                mapping = content;
                this.setMapping(content, status);
                if (monitor == null) break block11;
            }
            catch (CoreException e) {
                try {
                    throw e;
                    catch (Exception e2) {
                        IStatus error = Plugin.createError(Messages.TransformToGenModelOperation_e_load_mapping_model, e2);
                        throw new CoreException(error);
                    }
                }
                catch (Throwable throwable) {
                    this.setMapping(content, status);
                    if (monitor != null) {
                        monitor.done();
                    }
                    throw throwable;
                }
            }
            monitor.done();
        }
        return mapping;
    }

    public GenModel findGenmodel(ResourceSet rs) throws CoreException {
        try {
            this.checkResourceSet(rs);
            this.checkMapping();
            GenModelDetector gmd = this.getGenModelDetector();
            IStatus detect = gmd.detect();
            if (detect.isOK()) {
                GenModel genModel;
                this.myGenModel = genModel = gmd.get(rs);
                return genModel;
            }
            throw new CoreException(detect);
        }
        catch (Exception e) {
            IStatus error = Plugin.createError(Messages.TransformToGenModelOperation_e_mapping_invalid, e);
            throw new CoreException(error);
        }
    }

    public GenModel loadGenModel(ResourceSet rs, URI uri, IProgressMonitor pm) throws CoreException {
        SubProgressMonitor monitor = null;
        try {
            this.checkResourceSet(rs);
            this.checkMapping();
            monitor = pm != null ? new SubProgressMonitor(pm, 1, 4) : new NullProgressMonitor();
            String cancelMessage = Messages.TransformToGenModelOperation_e_genmodel_load_cancelled;
            monitor.beginTask("", 100);
            monitor.subTask(Messages.TransformToGenModelOperation_task_detect);
            GenModelDetector gmd = this.getGenModelDetector();
            IStatus status = Status.OK_STATUS;
            status = uri == null ? gmd.detect() : gmd.advise(uri);
            if (!status.isOK()) {
                throw new CoreException(status);
            }
            TransformToGenModelOperation.subTask((IProgressMonitor)monitor, 30, Messages.TransformToGenModelOperation_task_load, cancelMessage);
            GenModel genModel = gmd.get(rs);
            if (genModel == null) {
                if (uri == null) {
                    this.myStaleGenmodelStatus = Status.CANCEL_STATUS;
                    this.myGenModel = null;
                    return null;
                }
                IStatus notFound = Plugin.createError(Messages.GenModelDetector_e_not_found, null);
                throw new CoreException(notFound);
            }
            TransformToGenModelOperation.subTask((IProgressMonitor)monitor, 40, Messages.TransformToGenModelOperation_task_validate, cancelMessage);
            StaleGenModelDetector staleDetector = new StaleGenModelDetector(genModel);
            IStatus stale = staleDetector.detect();
            this.myGenModel = genModel;
            this.myStaleGenmodelStatus = stale;
            GenModel genModel2 = genModel;
            return genModel2;
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            IStatus error = Plugin.createError(Messages.TransformToGenModelOperation_e_genmodel_load, e);
            throw new CoreException(error);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public IStatus executeTransformation(ResourceSet rs, IProgressMonitor pm) {
        SubProgressMonitor monitor = null;
        try {
            this.checkResourceSet(rs);
            if (this.getGenURI() == null) {
                throw new IllegalStateException(Messages.TransformToGenModelOperation_e_null_gmfgen_uri);
            }
            this.checkMapping();
            monitor = pm != null ? new SubProgressMonitor(pm, 1, 4) : new NullProgressMonitor();
            monitor.beginTask("", 100);
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            DiagramRunTimeModelHelper drtModelHelper = this.detectRunTimeModel();
            ViewmapProducer viewmapProducer = this.detectTransformationOptions();
            VisualIdentifierDispenserProvider idDispenser = this.getVisualIdDispenser();
            idDispenser.acquire();
            GenModelProducer t = this.createGenModelProducer(this.getGenModel(), drtModelHelper, viewmapProducer, idDispenser.get());
            monitor.subTask(Messages.TransformToGenModelOperation_task_generate);
            GenEditorGenerator genEditor = t.process(this.getMapping(), (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 20));
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            monitor.subTask(Messages.TransformToGenModelOperation_task_reconcile);
            if (Plugin.needsReconcile()) {
                this.reconcile(rs, genEditor);
            }
            monitor.worked(20);
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            monitor.subTask(Messages.TransformToGenModelOperation_task_save);
            this.save(rs, genEditor);
            monitor.worked(20);
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            monitor.subTask(Messages.TransformToGenModelOperation_task_validate);
            IStatus validate = this.validate(genEditor, (IProgressMonitor)monitor);
            if (8 != validate.getSeverity()) {
                idDispenser.release();
            }
            IStatus iStatus = validate;
            return iStatus;
        }
        catch (Exception ex) {
            IStatus iStatus = Plugin.createError(ex.getMessage(), ex);
            return iStatus;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void checkResourceSet(ResourceSet rs) {
        if (rs == null) {
            throw new IllegalArgumentException(Messages.TransformToGenModelOperation_e_null_resource_set);
        }
    }

    private void checkMapping() {
        if (this.getMapping() == null) {
            throw new IllegalStateException(Messages.TransformToGenModelOperation_e_null_mapping);
        }
    }

    private IStatus getFirst(Diagnostic d) {
        if (d == null) {
            return Status.OK_STATUS;
        }
        List children = d.getChildren();
        if (children.isEmpty()) {
            return BasicDiagnostic.toIStatus((Diagnostic)d);
        }
        return BasicDiagnostic.toIStatus((Diagnostic)((Diagnostic)children.get(0)));
    }

    private DiagramRunTimeModelHelper detectRunTimeModel() {
        return new BasicDiagramRunTimeModelHelper();
    }

    private ViewmapProducer detectTransformationOptions() {
        RuntimeFQNSwitch fSwitch = this.getOptions().getUseRuntimeFigures() ? new RuntimeFQNSwitch() : new RuntimeLiteFQNSwitch();
        MapModeCodeGenStrategy mmStrategy = this.getOptions().getUseMapMode() ? MapModeCodeGenStrategy.DYNAMIC : MapModeCodeGenStrategy.STATIC;
        return new InnerClassViewmapProducer((FigureQualifiedNameSwitch)fSwitch, mmStrategy);
    }

    private VisualIdentifierDispenserProvider getVisualIdDispenser() {
        return new VisualIdentifierDispenserProvider(this.getGenURI());
    }

    private GenModelProducer createGenModelProducer(GenModel domainGenModel, DiagramRunTimeModelHelper drtModelHelper, ViewmapProducer viewmapProducer, VisualIdentifierDispenser idDespenser) {
        final DiagramGenModelTransformer t = new DiagramGenModelTransformer(drtModelHelper, (GenModelNamingMediator)new GenModelNamingMediatorImpl(), viewmapProducer, idDespenser, this.getOptions().getGenerateRCP());
        if (domainGenModel != null) {
            t.setEMFGenModel(domainGenModel);
        }
        return new GenModelProducer(){

            public GenEditorGenerator process(Mapping mapping, IProgressMonitor progress) {
                progress.beginTask(null, 1);
                try {
                    t.transform(mapping);
                    GenEditorGenerator genEditorGenerator = t.getResult();
                    return genEditorGenerator;
                }
                finally {
                    progress.done();
                }
            }
        };
    }

    private void reconcile(ResourceSet rs, GenEditorGenerator genBurdern) {
        GenEditorGenerator old = null;
        Resource resource = null;
        try {
            try {
                resource = rs.getResource(this.getGenURI(), true);
                EList contents = resource.getContents();
                if (!contents.isEmpty() && contents.get(0) instanceof GenEditorGenerator) {
                    old = (GenEditorGenerator)contents.get(0);
                }
                if (old != null) {
                    new Reconciler((ReconcilerConfig)new GMFGenConfig()).reconcileTree((EObject)genBurdern, (EObject)old);
                }
            }
            catch (RuntimeException runtimeException) {
                old = null;
                if (resource != null) {
                    resource.unload();
                }
            }
        }
        finally {
            if (resource != null) {
                resource.unload();
            }
        }
    }

    private void save(ResourceSet rs, GenEditorGenerator genBurdern) throws IOException {
        Resource dgmmRes = rs.createResource(this.getGenURI());
        dgmmRes.getContents().add((Object)genBurdern);
        dgmmRes.save(this.getSaveOptions());
    }

    private Map getSaveOptions() {
        HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("ENCODING", "UTF-8");
        return saveOptions;
    }

    private IStatus validate(GenEditorGenerator genBurdern, IProgressMonitor monitor) {
        Diagnostic d = ValidationHelper.validate((EObject)genBurdern, true, monitor);
        return this.getFirst(d);
    }

    private static void subTask(IProgressMonitor monitor, int ticks, String name, String cancelMessage) throws CoreException {
        if (monitor == null) {
            return;
        }
        if (monitor.isCanceled()) {
            IStatus cancel = Plugin.createCancel(cancelMessage);
            throw new CoreException(cancel);
        }
        if (ticks > 0) {
            monitor.worked(ticks);
        }
        if (name != null) {
            monitor.subTask(name);
        }
    }
}

