/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.transform;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gmf.internal.bridge.transform.ModelConfigurationPage;
import org.eclipse.gmf.internal.bridge.transform.TransformToGenModelOperation;
import org.eclipse.gmf.internal.bridge.transform.TransformToGenModelWizard;
import org.eclipse.gmf.internal.common.ui.ResourceLocationProvider;
import org.eclipse.gmf.mappings.Mapping;

class MapModelConfigurationPage
extends ModelConfigurationPage {
    private static final String FILE_EXT_GMFMAP = "gmfmap";

    MapModelConfigurationPage(String pageId, ResourceLocationProvider rlp, ResourceSet resourceSet) {
        super(pageId, rlp, resourceSet);
    }

    protected String getModelFileExtension() {
        return FILE_EXT_GMFMAP;
    }

    protected void initControls() {
        super.initControls();
        TransformToGenModelWizard wizard = (TransformToGenModelWizard)this.getWizard();
        IFile target = wizard.getTargetFile();
        this.getOperation().setGenURI(URI.createPlatformResourceURI((String)target.getFullPath().toString(), (boolean)true));
    }

    protected Resource doLoadResource(IProgressMonitor monitor) throws CoreException {
        TransformToGenModelOperation o = this.getOperation();
        Mapping mapping = o.loadMappingModel(this.getResourceSet(), this.getURI(), monitor);
        return mapping.eResource();
    }

    TransformToGenModelOperation getOperation() {
        TransformToGenModelWizard wizard = (TransformToGenModelWizard)this.getWizard();
        return wizard.getTransformOperation();
    }

    protected void resourceChanged() {
        super.resourceChanged();
        IStatus load = this.getOperation().getLoadMappingStatus();
        if (load != null && (load.getSeverity() == 2 || load.getSeverity() == 1)) {
            this.setStatusMessage(load);
        }
    }
}

