/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.geoshapes.internal.editparts;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.OpenDiagramEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ViewComponentEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.geoshapes.internal.providers.GeoshapeConstants;
import org.eclipse.gmf.runtime.diagram.ui.internal.editpolicies.DiagramLinkDragDropEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.editpolicies.NonSemanticEditPolicy;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.RGB;

public abstract class GeoShapeEditPart
extends ShapeNodeEditPart {
    public GeoShapeEditPart(View view) {
        super(view);
    }

    protected abstract NodeFigure createNodeFigure();

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.removeEditPolicy("SemanticPolicy");
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new NonSemanticEditPolicy());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new DiagramLinkDragDropEditPolicy());
        this.installEditPolicy("OpenPolicy", (EditPolicy)new OpenDiagramEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ViewComponentEditPolicy());
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.accessibleEP == null) {
            this.accessibleEP = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart((AbstractGraphicalEditPart)this){

                public void getName(AccessibleEvent e) {
                    View view = (View)GeoShapeEditPart.this.getModel();
                    e.result = GeoshapeConstants.getShapeLocalizedType(view.getType());
                }
            };
        }
        return this.accessibleEP;
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint("Description");
    }

    public Object getPreferredValue(EStructuralFeature feature) {
        Object preferenceStore = this.getDiagramPreferencesHint().getPreferenceStore();
        if (preferenceStore instanceof IPreferenceStore) {
            if (feature == NotationPackage.eINSTANCE.getLineStyle_LineColor()) {
                return FigureUtilities.RGBToInteger((RGB)PreferenceConverter.getColor((IPreferenceStore)((IPreferenceStore)preferenceStore), (String)"Appearance.noteLineColor"));
            }
            if (feature == NotationPackage.eINSTANCE.getFillStyle_FillColor()) {
                return FigureUtilities.RGBToInteger((RGB)PreferenceConverter.getColor((IPreferenceStore)((IPreferenceStore)preferenceStore), (String)"Appearance.noteFillColor"));
            }
        }
        return super.getPreferredValue(feature);
    }

    protected void setLineWidth(int width) {
        if (width < 0) {
            width = 1;
        }
        ((NodeFigure)this.getFigure()).setLineWidth(this.getMapMode().DPtoLP(width));
    }

    protected void handleNotificationEvent(Notification notification) {
        Object feature = notification.getFeature();
        if (NotationPackage.eINSTANCE.getLineStyle_LineWidth().equals(feature)) {
            this.refreshLineWidth();
        } else if (NotationPackage.eINSTANCE.getLineTypeStyle_LineType().equals(feature)) {
            this.refreshLineType();
        } else {
            super.handleNotificationEvent(notification);
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshLineWidth();
        this.refreshLineType();
        this.refreshTransparency();
    }

    protected void setLineType(int lineType) {
        ((NodeFigure)this.getFigure()).setLineStyle(lineType);
    }

    public boolean supportsGradient() {
        return true;
    }
}

