/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.dialogs.sortfilter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ListCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.SortFilterContentEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.properties.Properties;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.ChangePropertyValueRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Filtering;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class FilterDialog
extends Dialog {
    private final String title = DiagramUIMessages.SortFilterDialog_title;
    private static final String FILTER_ITEMS_CONTAINING = DiagramUIMessages.SortFilter_filterItemsListLabel;
    private static final String FILTER_ITEMS_LIST = DiagramUIMessages.SortFilter_fitlerListLabel;
    private static final String ADD_TO = DiagramUIMessages.SortFilter_addTo;
    private final String ADD_TO_LABEL = "<";
    private static final String REMOVE_FROM = DiagramUIMessages.SortFilter_removeFrom;
    private final String REMOVE_FROM_LABEL = ">";
    private static final String ADD_ALL = DiagramUIMessages.SortFilter_addAll;
    private final String ADD_ALL_LABEL = "<<";
    private static final String REMOVE_ALL = DiagramUIMessages.SortFilter_removeAll;
    private final String REMOVE_ALL_LABEL = ">>";
    private static final String APPLY = DiagramUIMessages.SortFilter_apply;
    private org.eclipse.swt.widgets.List filterList = null;
    private org.eclipse.swt.widgets.List filters = null;
    private Button addTo = null;
    private Button removeFrom = null;
    private Button addAllTo = null;
    private Button removeAllFrom = null;
    private final int ADD_TO_ID = 1000;
    private final int REMOVE_FROM_ID = 1001;
    private final int ADD_ALL_TO_ID = 1002;
    private final int REMOVE_ALL_FROM_ID = 1003;
    private final int APPLY_ID = 5000;
    private int LIST_HEIGHT = 8;
    private Map filterMap = null;
    private String[] filterStrings = null;
    private Filtering _filtering = Filtering.NONE_LITERAL;
    private List _filteringKeys = Collections.EMPTY_LIST;
    private List selection;
    private boolean changeToApply = true;
    private ButtonSelectionAdapter buttonSelectionAdapter = new ButtonSelectionAdapter();

    protected FilterDialog(Shell parentShell, List selection, Map filterMap) {
        super(parentShell);
        this.selection = selection;
        this.filterMap = filterMap;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.title);
        this.createFilterLists(parent);
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.createButton(parent, 5000, APPLY, true);
    }

    private void createFilterLists(Composite ancestor) {
        if (this.filterMap == null || this.filterMap.isEmpty()) {
            return;
        }
        Object[] filterArray = this.filterMap.keySet().toArray();
        this.filterStrings = new String[filterArray.length];
        int i = 0;
        while (i < filterArray.length) {
            this.filterStrings[i] = (String)filterArray[i];
            ++i;
        }
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.numColumns = 3;
        parent.setLayout((Layout)layout);
        Label filterItemsLabel = new Label(parent, 16384);
        filterItemsLabel.setText(FILTER_ITEMS_CONTAINING);
        GridData gd = new GridData();
        gd.horizontalAlignment = 32;
        filterItemsLabel.setLayoutData((Object)gd);
        new Label(parent, 16384);
        Label filterItemLabel = new Label(parent, 16384);
        filterItemLabel.setText(FILTER_ITEMS_LIST);
        GridData gd2 = new GridData();
        gd2.horizontalAlignment = 1;
        filterItemLabel.setLayoutData((Object)gd2);
        this.filters = new org.eclipse.swt.widgets.List(parent, 2562);
        GridData gridData = new GridData(16);
        gridData.verticalSpan = 1;
        gridData.widthHint = 80;
        int listHeight = this.filters.getItemHeight() * this.LIST_HEIGHT;
        Rectangle trim = this.filters.computeTrim(0, 0, 0, listHeight);
        gridData.heightHint = trim.height;
        this.filters.setLayoutData((Object)gridData);
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        buttonLayout.numColumns = 1;
        buttonComposite.setLayout((Layout)buttonLayout);
        GridData buttGD = new GridData(1042);
        buttGD.horizontalSpan = 1;
        buttGD.widthHint = 30;
        buttonComposite.setLayoutData((Object)buttGD);
        this.removeFrom = new Button(buttonComposite, 8);
        this.removeFrom.setText(">");
        this.removeFrom.setToolTipText(REMOVE_FROM);
        this.removeFrom.setLayoutData((Object)this.makeArrowButtonGridData((Control)this.removeFrom));
        this.removeFrom.setData((Object)new Integer(1001));
        this.removeFrom.addSelectionListener((SelectionListener)this.buttonSelectionAdapter);
        this.removeFrom.setEnabled(false);
        this.addTo = new Button(buttonComposite, 8);
        this.addTo.setText("<");
        this.addTo.setToolTipText(ADD_TO);
        this.addTo.setLayoutData((Object)this.makeArrowButtonGridData((Control)this.addTo));
        this.addTo.setData((Object)new Integer(1000));
        this.addTo.addSelectionListener((SelectionListener)this.buttonSelectionAdapter);
        this.addTo.setEnabled(false);
        this.removeAllFrom = new Button(buttonComposite, 8);
        this.removeAllFrom.setText(">>");
        this.removeAllFrom.setToolTipText(REMOVE_ALL);
        this.removeAllFrom.setLayoutData((Object)this.makeArrowButtonGridData((Control)this.removeAllFrom));
        this.removeAllFrom.setData((Object)new Integer(1003));
        this.removeAllFrom.addSelectionListener((SelectionListener)this.buttonSelectionAdapter);
        this.addAllTo = new Button(buttonComposite, 8);
        this.addAllTo.setText("<<");
        this.addAllTo.setToolTipText(ADD_ALL);
        this.addAllTo.setLayoutData((Object)this.makeArrowButtonGridData((Control)this.addAllTo));
        this.addAllTo.setData((Object)new Integer(1002));
        this.addAllTo.addSelectionListener((SelectionListener)this.buttonSelectionAdapter);
        this.filterList = new org.eclipse.swt.widgets.List(parent, 2562);
        GridData gridData2 = new GridData(16);
        gridData2.verticalSpan = 1;
        gridData2.widthHint = 80;
        int listHeight2 = this.filterList.getItemHeight() * this.LIST_HEIGHT;
        Rectangle trim2 = this.filterList.computeTrim(0, 0, 0, listHeight2);
        gridData.heightHint = trim2.height;
        this.filterList.setLayoutData((Object)gridData2);
        this.filters.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                FilterDialog.this.removeFrom.setEnabled(FilterDialog.this.filters.getSelectionCount() > 0);
            }
        });
        this.filterList.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                FilterDialog.this.addTo.setEnabled(FilterDialog.this.filterList.getSelectionCount() > 0);
            }
        });
        this.initFilterLists();
    }

    /*
     * Unable to fully structure code
     */
    private void initFilterLists() {
        block3: {
            if (this.filterMap == null || this.filterMap.isEmpty()) break block3;
            keySet = this.filterMap.keySet();
            i = keySet.iterator();
            if (this._filtering != Filtering.AUTOMATIC_LITERAL) ** GOTO lbl15
            while (i.hasNext()) {
                filterString = (String)i.next();
                if (this._filteringKeys.contains(filterString)) {
                    this.filters.add(filterString);
                    continue;
                }
                this.filterList.add(filterString);
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                filterString = (String)i.next();
                this.filterList.add(filterString);
lbl15:
                // 2 sources

                ** while (i.hasNext())
            }
        }
    }

    protected GridData makeArrowButtonGridData(Control control) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        GridData gridData = new GridData(768);
        gridData.heightHint = 24;
        gc.dispose();
        return gridData;
    }

    public void setFilter(Map filterMap, String property) {
        if (filterMap != null) {
            this.filterMap = filterMap;
            Object[] filterArray = filterMap.keySet().toArray();
            this.filterStrings = new String[filterArray.length];
            int i = 0;
            while (i < filterArray.length) {
                this.filterStrings[i] = (String)filterArray[i];
                ++i;
            }
        }
    }

    protected void buttonPressed(int buttonId) {
        String[] items = new String[]{};
        switch (buttonId) {
            case 1000: {
                items = this.filterList.getSelection();
                int i = 0;
                while (i < items.length) {
                    this.filters.add(items[i]);
                    this.filterList.remove(items[i]);
                    ++i;
                }
                this.addTo.setEnabled(false);
                this.changeToApply = true;
                break;
            }
            case 1001: {
                items = this.filters.getSelection();
                int i = 0;
                while (i < items.length) {
                    this.filterList.add(items[i]);
                    this.filters.remove(items[i]);
                    ++i;
                }
                this.removeFrom.setEnabled(false);
                this.changeToApply = true;
                break;
            }
            case 1002: {
                items = this.filterList.getItems();
                int i = 0;
                while (i < items.length) {
                    this.filters.add(items[i]);
                    this.filterList.remove(items[i]);
                    ++i;
                }
                this.changeToApply = true;
                break;
            }
            case 1003: {
                items = this.filters.getItems();
                int i = 0;
                while (i < items.length) {
                    this.filters.remove(items[i]);
                    this.filterList.add(items[i]);
                    ++i;
                }
                this.changeToApply = true;
                break;
            }
            case 0: {
                this.okPressed();
                break;
            }
            case 5000: {
                this.applyPressed();
                break;
            }
            default: {
                super.buttonPressed(buttonId);
            }
        }
    }

    protected void okPressed() {
        if (this.changeToApply) {
            this.applyPressed();
        }
        super.okPressed();
    }

    protected void applyPressed() {
        if (!this.changeToApply) {
            return;
        }
        if (this.filters.getItemCount() > 0) {
            this._filteringKeys = new ArrayList();
            this._filtering = Filtering.AUTOMATIC_LITERAL;
            int i = 0;
            while (i < this.filters.getItemCount()) {
                this._filteringKeys.add(this.filters.getItems()[i]);
                ++i;
            }
        } else {
            this._filtering = Filtering.NONE_LITERAL;
            this._filteringKeys = Collections.EMPTY_LIST;
        }
        ChangePropertyValueRequest filterTypeRequest = new ChangePropertyValueRequest(Properties.ID_FILTERING, Properties.ID_FILTERING, this._filtering);
        ChangePropertyValueRequest filterKeysRequest = new ChangePropertyValueRequest(Properties.ID_FILTERING_KEYS, Properties.ID_FILTERING_KEYS, this._filteringKeys);
        TransactionalEditingDomain editingDomain = null;
        ArrayList<CommandProxy> childCommands = new ArrayList<CommandProxy>();
        for (GraphicalEditPart ep : this.selection) {
            if (editingDomain == null) {
                editingDomain = ep.getEditingDomain();
            }
            List children = ep.getChildren();
            int i = 0;
            while (i < children.size()) {
                if (children.get(i) instanceof ListCompartmentEditPart) {
                    ListCompartmentEditPart editPart = (ListCompartmentEditPart)children.get(i);
                    if (this.filterMap != null && this.filterMap.equals(this.getFilterMapFromEditPart(editPart))) {
                        Command command = editPart.getCommand(filterTypeRequest);
                        if (command != null) {
                            childCommands.add(new CommandProxy(command));
                        }
                        if ((command = editPart.getCommand(filterKeysRequest)) != null) {
                            childCommands.add(new CommandProxy(command));
                        }
                    }
                }
                ++i;
            }
        }
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(editingDomain, DiagramUIMessages.Command_SortFilterCommand, childCommands);
        ((IGraphicalEditPart)this.selection.get(0)).getRoot().getViewer().getEditDomain().getCommandStack().execute((Command)new ICommandProxy((ICommand)cc));
        this.changeToApply = false;
    }

    private Map getFilterMapFromEditPart(ListCompartmentEditPart editPart) {
        EditPolicy ep = editPart.getEditPolicy("Sortfilter_contentPolicy");
        if (ep instanceof SortFilterContentEditPolicy) {
            return ((SortFilterContentEditPolicy)ep).getFilter();
        }
        return Collections.EMPTY_MAP;
    }

    class ButtonSelectionAdapter
    extends SelectionAdapter {
        ButtonSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent event) {
            FilterDialog.this.buttonPressed((Integer)event.widget.getData());
        }
    }
}

