/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.providers.internal;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.draw2d.graph.Subgraph;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionAnchorsCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderedShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ListCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ListItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.layout.LayoutNodesOperation;
import org.eclipse.gmf.runtime.diagram.ui.providers.internal.DiagramProvidersDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.providers.internal.DiagramProvidersPlugin;
import org.eclipse.gmf.runtime.diagram.ui.requests.SetAllBendpointRequest;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.AbstractLayoutEditPartProvider;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PrecisionPointList;
import org.eclipse.gmf.runtime.draw2d.ui.graph.BorderNode;
import org.eclipse.gmf.runtime.draw2d.ui.graph.ConstantSizeNode;
import org.eclipse.gmf.runtime.draw2d.ui.graph.ConstrainedEdge;
import org.eclipse.gmf.runtime.draw2d.ui.graph.GMFDirectedGraphLayout;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.OrthogonalRouter;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.View;

public abstract class DefaultProvider
extends AbstractLayoutEditPartProvider {
    protected int minX = -1;
    protected int minY = -1;
    protected int layoutDefaultMargin = 0;
    protected IMapMode mm;
    protected static final int NODE_PADDING = 30;
    protected static final int MIN_EDGE_PADDING = 15;
    protected static final int MAX_EDGE_PADDING = 90;
    protected static final int MIN_EDGE_END_POINTS_PADDING = 5;

    protected IMapMode getMapMode() {
        return this.mm;
    }

    public boolean provides(IOperation operation) {
        Assert.isNotNull((Object)operation);
        View cview = this.getContainer(operation);
        if (cview == null) {
            return false;
        }
        IAdaptable layoutHint = ((LayoutNodesOperation)operation).getLayoutHint();
        String layoutType = (String)layoutHint.getAdapter(String.class);
        return "DEFAULT".equals(layoutType);
    }

    public Command layoutEditParts(GraphicalEditPart containerEditPart, IAdaptable layoutHint) {
        if (containerEditPart == null) {
            InvalidParameterException ipe = new InvalidParameterException();
            Trace.throwing((Plugin)DiagramProvidersPlugin.getInstance(), (String)DiagramProvidersDebugOptions.EXCEPTIONS_THROWING, ((Object)((Object)this)).getClass(), (String)"layout()", (Throwable)ipe);
            throw ipe;
        }
        this.mm = MapModeUtil.getMapMode((IFigure)containerEditPart.getFigure());
        DirectedGraph g = this.createGraph();
        this.buildGraph(g, containerEditPart.getChildren());
        this.createGraphLayout().visit(g);
        Command cmd = this.update_diagram(containerEditPart, g, false);
        this.mm = null;
        return cmd;
    }

    public Command layoutEditParts(List selectedObjects, IAdaptable layoutHint) {
        if (selectedObjects.size() == 0) {
            return null;
        }
        GraphicalEditPart editPart = (GraphicalEditPart)selectedObjects.get(0);
        GraphicalEditPart containerEditPart = (GraphicalEditPart)editPart.getParent();
        this.mm = MapModeUtil.getMapMode((IFigure)containerEditPart.getFigure());
        DirectedGraph g = this.createGraph();
        this.buildGraph(g, selectedObjects);
        this.createGraphLayout().visit(g);
        Command cmd = this.update_diagram(containerEditPart, g, true);
        this.mm = null;
        return cmd;
    }

    protected boolean layoutTopDown(ConnectionEditPart poly) {
        return false;
    }

    protected NodeList build_nodes(List selectedObjects, Map editPartToNodeDict, Subgraph root) {
        return this.buildNodes(selectedObjects, editPartToNodeDict, root);
    }

    protected NodeList buildNodes(List selectedObjects, Map editPartToNodeDict, Subgraph root) {
        ListIterator li = selectedObjects.listIterator();
        NodeList nodes = new NodeList();
        while (li.hasNext()) {
            IGraphicalEditPart gep = (IGraphicalEditPart)li.next();
            if (!(gep instanceof ShapeEditPart)) continue;
            ShapeEditPart shapeEP = (ShapeEditPart)gep;
            Point position = shapeEP.getLocation();
            if (this.minX == -1) {
                this.minX = position.x;
                this.minY = position.y;
            } else {
                this.minX = Math.min(this.minX, position.x);
                this.minY = Math.min(this.minY, position.y);
            }
            ConstantSizeNode n = new ConstantSizeNode((Object)shapeEP);
            n.setPadding(new Insets(this.getMapMode().DPtoLP(30)));
            n.setMinIncomingPadding(this.getMapMode().DPtoLP(5));
            n.setMinOutgoingPadding(this.getMapMode().DPtoLP(5));
            Dimension size = shapeEP.getSize();
            this.setNodeMetrics((Node)n, new Rectangle(position.x, position.y, size.width, size.height));
            editPartToNodeDict.put(shapeEP, n);
            nodes.add((Object)n);
            this.buildBorderNodes((GraphicalEditPart)shapeEP, n, editPartToNodeDict);
        }
        return nodes;
    }

    protected void build_borderNodes(GraphicalEditPart parentEP, ConstantSizeNode parentNode, Map editPartToNodeDict) {
        this.buildBorderNodes(parentEP, parentNode, editPartToNodeDict);
    }

    protected void buildBorderNodes(GraphicalEditPart parentEP, ConstantSizeNode parentNode, Map editPartToNodeDict) {
        if (!this.supportsBorderNodes()) {
            return;
        }
        boolean borderNodesAdded = false;
        Rectangle parentRect = new Rectangle(parentNode.x, parentNode.y, parentNode.width, parentNode.height);
        Rectangle extendedRect = parentRect.getCopy();
        for (EditPart ep : parentEP.getChildren()) {
            if (!(ep instanceof IBorderItemEditPart) || !this.canCreateBorderNode((IBorderItemEditPart)ep)) continue;
            IBorderItemEditPart bep = (IBorderItemEditPart)ep;
            BorderNode bn = new BorderNode((Object)bep, parentNode);
            this.setNodeMetrics((Node)bn, bep.getFigure().getBounds());
            bn.setOutsideRatio(1.0f - (float)bep.getFigure().getBounds().getCopy().intersect(parentEP.getFigure().getBounds()).getSize().getArea() / (float)bep.getFigure().getSize().getArea());
            editPartToNodeDict.put(bep, bn);
            borderNodesAdded = true;
            extendedRect.union(new Rectangle(bn.x, bn.y, bn.width, bn.height));
            bn.setMinIncomingPadding(this.getMapMode().DPtoLP(5));
            bn.setMinOutgoingPadding(this.getMapMode().DPtoLP(5));
        }
        if (borderNodesAdded) {
            parentNode.getPadding().add(new Insets(Math.max(extendedRect.width - parentRect.width, extendedRect.height - parentRect.height)));
        }
    }

    protected boolean canCreateBorderNode(IBorderItemEditPart ep) {
        return ep.getEditPolicy((Object)"PrimaryDrag Policy") instanceof NonResizableEditPolicy;
    }

    protected boolean supportsBorderNodes() {
        return false;
    }

    protected final void setNodeMetrics(Node n, Rectangle r) {
        Rectangle rectGraph = this.translateToGraph(r);
        n.x = rectGraph.x;
        n.y = rectGraph.y;
        n.width = rectGraph.width;
        n.height = rectGraph.height;
    }

    protected Rectangle getNodeMetrics(Node n) {
        Rectangle rect = new Rectangle(n.x, n.y, n.width, n.height);
        PrecisionRectangle preciseRect = new PrecisionRectangle(rect);
        return this.translateFromGraph((Rectangle)preciseRect);
    }

    protected abstract Rectangle translateToGraph(Rectangle var1);

    protected abstract Rectangle translateFromGraph(Rectangle var1);

    protected EdgeList build_edges(List selectedObjects, Map editPartToNodeDict) {
        return this.buildEdges(selectedObjects, editPartToNodeDict);
    }

    protected EdgeList buildEdges(List selectedObjects, Map editPartToNodeDict) {
        EdgeList edges = new EdgeList();
        ArrayList objects = new ArrayList();
        objects.addAll(selectedObjects);
        ListIterator li = objects.listIterator();
        ArrayList<ConnectionEditPart> notTopDownEdges = new ArrayList<ConnectionEditPart>();
        boolean shouldHandleListItems = this.shouldHandleConnectableListItems();
        while (li.hasNext()) {
            EditPart gep = (EditPart)li.next();
            if (!(gep instanceof ConnectionEditPart)) continue;
            ConnectionEditPart poly = (ConnectionEditPart)gep;
            if (this.layoutTopDown(poly)) {
                EditPart from = poly.getSource();
                EditPart to = poly.getTarget();
                if (from instanceof IBorderItemEditPart && !editPartToNodeDict.containsKey(from)) {
                    from = from.getParent();
                } else if (shouldHandleListItems && from instanceof ListItemEditPart) {
                    from = this.getFirstAnscestorinNodesMap(from, editPartToNodeDict);
                }
                if (to instanceof IBorderItemEditPart && !editPartToNodeDict.containsKey(to)) {
                    to = to.getParent();
                } else if (shouldHandleListItems && to instanceof ListItemEditPart) {
                    to = this.getFirstAnscestorinNodesMap(to, editPartToNodeDict);
                }
                Node fromNode = (Node)editPartToNodeDict.get(from);
                Node toNode = (Node)editPartToNodeDict.get(to);
                if (fromNode == null || toNode == null || this.checkSelfEdge(from, to, editPartToNodeDict)) continue;
                this.addEdge(edges, poly, toNode, fromNode);
                continue;
            }
            notTopDownEdges.add(poly);
        }
        li = notTopDownEdges.listIterator();
        while (li.hasNext()) {
            ConnectionEditPart poly = (ConnectionEditPart)li.next();
            EditPart from = poly.getSource();
            EditPart to = poly.getTarget();
            if (from instanceof IBorderItemEditPart && !editPartToNodeDict.containsKey(from)) {
                from = from.getParent();
            } else if (shouldHandleListItems && from instanceof ListItemEditPart) {
                from = this.getFirstAnscestorinNodesMap(from, editPartToNodeDict);
            }
            if (to instanceof IBorderItemEditPart && !editPartToNodeDict.containsKey(to)) {
                to = to.getParent();
            } else if (shouldHandleListItems && to instanceof ListItemEditPart) {
                to = this.getFirstAnscestorinNodesMap(to, editPartToNodeDict);
            }
            Node fromNode = (Node)editPartToNodeDict.get(from);
            Node toNode = (Node)editPartToNodeDict.get(to);
            if (fromNode == null || toNode == null || this.checkSelfEdge(from, to, editPartToNodeDict)) continue;
            this.addEdge(edges, poly, fromNode, toNode);
        }
        return edges;
    }

    private boolean checkSelfEdge(EditPart from, EditPart to, Map dictionary) {
        Node graphTarget;
        Node graphSource = from instanceof IBorderItemEditPart ? (Node)dictionary.get(from.getParent()) : (Node)dictionary.get(from);
        Node node = graphTarget = to instanceof IBorderItemEditPart ? (Node)dictionary.get(to.getParent()) : (Node)dictionary.get(to);
        return graphSource != null && graphTarget != null && graphSource.equals(graphTarget);
    }

    private void addEdge(EdgeList edges, ConnectionEditPart connectionEP, Node fromNode, Node toNode) {
        ConstrainedEdge edge = new ConstrainedEdge((Object)connectionEP, fromNode, toNode);
        this.initializeEdge(connectionEP, (Edge)edge);
        edges.add((Object)edge);
    }

    protected void initializeEdge(ConnectionEditPart connectionEP, Edge edge) {
        List affectingChildren = this.getAffectingChildren(connectionEP);
        edge.setPadding(Math.max(edge.getPadding(), this.calculateEdgePadding(connectionEP, affectingChildren)));
        edge.setDelta(Math.max(edge.getDelta(), affectingChildren.size() / 2));
        if (edge instanceof ConstrainedEdge && ((Connection)connectionEP.getFigure()).getConnectionRouter() instanceof OrthogonalRouter) {
            ((ConstrainedEdge)edge).setStyle(ConstrainedEdge.ORTHOGONAL_ROUTING_STYLE);
        }
    }

    private int calculateEdgePadding(ConnectionEditPart connectionEP, List affectingChildren) {
        ListIterator li = affectingChildren.listIterator();
        int padding = 0;
        while (li.hasNext()) {
            GraphicalEditPart gep = (GraphicalEditPart)li.next();
            padding = Math.max(padding, Math.max(gep.getFigure().getBounds().width, gep.getFigure().getBounds().height));
        }
        Rectangle.SINGLETON.x = 0;
        Rectangle.SINGLETON.y = 0;
        Rectangle.SINGLETON.width = padding;
        Rectangle.SINGLETON.height = padding;
        return Math.min(Math.max(Math.round((float)this.translateToGraph((Rectangle)Rectangle.SINGLETON).width * 1.5f), this.getMapMode().DPtoLP(15)), this.getMapMode().DPtoLP(90));
    }

    private List getAffectingChildren(ConnectionEditPart conn) {
        List children = conn.getChildren();
        ListIterator lli = children.listIterator();
        ArrayList<GraphicalEditPart> affectingChildrenList = new ArrayList<GraphicalEditPart>();
        while (lli.hasNext()) {
            Object obj = lli.next();
            if (!(obj instanceof GraphicalEditPart)) continue;
            GraphicalEditPart lep = (GraphicalEditPart)obj;
            Rectangle lepBox = lep.getFigure().getBounds().getCopy();
            if (!lep.getFigure().isVisible() || lepBox.width == 0 || lepBox.height == 0) continue;
            affectingChildrenList.add(lep);
        }
        return affectingChildrenList;
    }

    protected List getRelevantConnections(Hashtable editPartToNodeDict) {
        Enumeration enumeration = editPartToNodeDict.keys();
        ArrayList<ConnectionEditPart> connectionsToMove = new ArrayList<ConnectionEditPart>();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            GraphicalEditPart shapeEP = (GraphicalEditPart)e;
            HashSet sourceConnections = new HashSet(shapeEP.getSourceConnections());
            if (shapeEP instanceof IBorderedShapeEditPart) {
                List borderItems = this.getBorderItemEditParts((EditPart)shapeEP, editPartToNodeDict);
                for (GraphicalEditPart element : borderItems) {
                    sourceConnections.addAll(element.getSourceConnections());
                }
            }
            for (ConnectionEditPart connectionEP : sourceConnections) {
                Object o;
                EditPart target = connectionEP.getTarget();
                if (target instanceof IBorderItemEditPart) {
                    target = target.getParent();
                }
                if (target == null || (o = editPartToNodeDict.get(target)) == null) continue;
                connectionsToMove.add(connectionEP);
            }
            if (!this.shouldHandleConnectableListItems()) continue;
            this.handleConnectableListItems(shapeEP, editPartToNodeDict, connectionsToMove);
        }
        return connectionsToMove;
    }

    private void handleConnectableListItems(GraphicalEditPart shapeEP, Map editPartToNodeDict, ArrayList connectionsToMove) {
        List children = shapeEP.getChildren();
        for (EditPart ep : children) {
            if (!(ep instanceof ListCompartmentEditPart)) continue;
            List listItems = ep.getChildren();
            for (GraphicalEditPart listItem : listItems) {
                List connections = listItem.getSourceConnections();
                for (ConnectionEditPart connectionEP : connections) {
                    EditPart ancestor = this.getFirstAnscestorinNodesMap(connectionEP.getTarget(), editPartToNodeDict);
                    if (ancestor == null) continue;
                    connectionsToMove.add(connectionEP);
                }
            }
        }
    }

    private EditPart getFirstAnscestorinNodesMap(EditPart editPart, Map editPartToNodeDict) {
        EditPart ancestor = editPart;
        while (ancestor != null) {
            if (editPartToNodeDict.get(ancestor) != null) {
                return ancestor;
            }
            ancestor = ancestor.getParent();
        }
        return null;
    }

    private List getBorderItemEditParts(EditPart parent, Hashtable editPartToNodeDict) {
        Iterator iter = parent.getChildren().iterator();
        ArrayList<EditPart> list = new ArrayList<EditPart>();
        while (iter.hasNext()) {
            EditPart child = (EditPart)iter.next();
            if (editPartToNodeDict.containsKey(child) || !(child instanceof IBorderItemEditPart)) continue;
            list.add(child);
        }
        return list;
    }

    protected void build_graph(DirectedGraph g, List selectedObjects) {
        this.buildGraph(g, selectedObjects);
    }

    protected void buildGraph(DirectedGraph g, List selectedObjects) {
        Hashtable editPartToNodeDict = new Hashtable(500);
        this.minX = -1;
        this.minY = -1;
        NodeList nodes = this.buildNodes(selectedObjects, editPartToNodeDict, null);
        ArrayList objects = new ArrayList();
        objects.addAll(selectedObjects);
        objects.addAll(this.getRelevantConnections(editPartToNodeDict));
        EdgeList edges = this.buildEdges(objects, editPartToNodeDict);
        g.nodes = nodes;
        g.edges = edges;
        this.postProcessGraph(g, editPartToNodeDict);
    }

    protected void postProcessGraph(DirectedGraph g, Hashtable editPartToNodeDict) {
    }

    private void reverse(PointList c, PointList rc) {
        rc.removeAllPoints();
        int i = c.size() - 1;
        while (i >= 0) {
            rc.addPoint(c.getPoint(i));
            --i;
        }
    }

    protected Command routeThrough(Edge edge, ConnectionEditPart connectEP, Node source, Node target, PointList points, Point diff) {
        if (connectEP == null) {
            return null;
        }
        PointList routePoints = points;
        if (source.data == connectEP.getTarget()) {
            routePoints = new PointList(points.size());
            this.reverse(points, routePoints);
            Node tmpNode = source;
            source = target;
            target = tmpNode;
        }
        double totalEdgeDiffX = diff.preciseX();
        double totalEdgeDiffY = diff.preciseY();
        PrecisionPointList allPoints = new PrecisionPointList(routePoints.size());
        int i = 0;
        while (i < routePoints.size()) {
            allPoints.addPrecisionPoint(routePoints.getPoint(i).preciseX() + totalEdgeDiffX, routePoints.getPoint(i).preciseY() + totalEdgeDiffY);
            ++i;
        }
        CompoundCommand cc = new CompoundCommand("");
        LineSeg anchorReferencePoints = this.addAnchorsCommands(cc, allPoints.getFirstPoint(), allPoints.getLastPoint(), source, target, connectEP, diff);
        SetAllBendpointRequest request = new SetAllBendpointRequest("set_all_connection_bendpoint", (PointList)allPoints, anchorReferencePoints.getOrigin(), anchorReferencePoints.getTerminus());
        Command cmd = connectEP.getCommand((Request)request);
        if (cmd != null) {
            cc.add(cmd);
        }
        List affectingChildren = this.getAffectingChildren(connectEP);
        Request snapBackRequest = new Request((Object)"snap_back");
        ListIterator li = affectingChildren.listIterator();
        while (li.hasNext()) {
            EditPart ep = (EditPart)li.next();
            cmd = ep.getCommand(snapBackRequest);
            if (cmd == null) continue;
            cc.add(cmd);
        }
        if (cc.isEmpty()) {
            return null;
        }
        return cc;
    }

    protected LineSeg addAnchorsCommands(CompoundCommand cc, Point sourceAnchorLocation, Point targetAnchorLocation, Node source, Node target, ConnectionEditPart cep, Point diff) {
        ReconnectRequest reconnectRequest;
        Rectangle sourceExt = this.getNodeMetrics(source);
        Rectangle targetExt = this.getNodeMetrics(target);
        sourceExt.translate(diff);
        targetExt.translate(diff);
        Point resultantSourceAnchorReference = sourceExt.getCenter();
        Point resultantTargetAnchorReference = targetExt.getCenter();
        PrecisionPoint sourceRatio = new PrecisionPoint((sourceAnchorLocation.preciseX() - sourceExt.preciseX()) / sourceExt.preciseWidth(), (sourceAnchorLocation.preciseY() - sourceExt.preciseY()) / sourceExt.preciseHeight());
        PrecisionPoint targetRatio = new PrecisionPoint((targetAnchorLocation.preciseX() - targetExt.preciseX()) / targetExt.preciseWidth(), (targetAnchorLocation.preciseY() - targetExt.preciseY()) / targetExt.preciseHeight());
        if (cep.getSource().equals(source.data)) {
            reconnectRequest = new ReconnectRequest((Object)"Reconnection source");
            reconnectRequest.setConnectionEditPart(cep);
            reconnectRequest.setTargetEditPart(cep.getSource());
            IFigure sourceFig = ((GraphicalEditPart)cep.getSource()).getFigure();
            PrecisionPoint sourceAnchorReference = new PrecisionPoint(sourceFig.getBounds().preciseX() + sourceRatio.preciseX() * sourceFig.getBounds().preciseWidth(), sourceFig.getBounds().preciseY() + sourceRatio.preciseY() * sourceFig.getBounds().preciseHeight());
            sourceFig.translateToAbsolute((Translatable)sourceAnchorReference);
            reconnectRequest.setLocation((Point)sourceAnchorReference);
            Command sourceAnchorCommand = cep.getSource().getCommand((Request)reconnectRequest);
            if (sourceAnchorCommand != null && sourceAnchorCommand.canExecute()) {
                cc.add(sourceAnchorCommand);
                if (((Connection)cep.getFigure()).getSourceAnchor() instanceof BaseSlidableAnchor) {
                    if (sourceAnchorCommand instanceof ICommandProxy) {
                        this.updateNewSlidingAnchorReferenceRatio((ICommandProxy)sourceAnchorCommand, true, sourceRatio);
                    }
                    resultantSourceAnchorReference = new PrecisionPoint(sourceExt.preciseWidth() * sourceRatio.preciseX() + sourceExt.preciseX(), sourceExt.preciseHeight() * sourceRatio.preciseY() + sourceExt.preciseY());
                }
            }
        } else {
            resultantSourceAnchorReference = this.getNewAnchorReferencePoint(source, sourceExt, ((Connection)cep.getFigure()).getSourceAnchor().getReferencePoint());
        }
        if (cep.getTarget().equals(target.data)) {
            reconnectRequest = new ReconnectRequest((Object)"Reconnection target");
            reconnectRequest.setConnectionEditPart(cep);
            reconnectRequest.setTargetEditPart(cep.getTarget());
            IFigure targetFig = ((GraphicalEditPart)cep.getTarget()).getFigure();
            PrecisionPoint targetAnchorReference = new PrecisionPoint(targetFig.getBounds().preciseX() + targetRatio.preciseX() * targetFig.getBounds().preciseWidth(), targetFig.getBounds().preciseY() + targetRatio.preciseY() * targetFig.getBounds().preciseHeight());
            targetFig.translateToAbsolute((Translatable)targetAnchorReference);
            reconnectRequest.setLocation((Point)targetAnchorReference);
            Command targetAnchorCommand = cep.getTarget().getCommand((Request)reconnectRequest);
            if (targetAnchorCommand != null && targetAnchorCommand.canExecute()) {
                cc.add(targetAnchorCommand);
                if (((Connection)cep.getFigure()).getTargetAnchor() instanceof BaseSlidableAnchor) {
                    if (targetAnchorCommand instanceof ICommandProxy) {
                        this.updateNewSlidingAnchorReferenceRatio((ICommandProxy)targetAnchorCommand, false, targetRatio);
                    }
                    resultantTargetAnchorReference = new PrecisionPoint(targetExt.preciseWidth() * targetRatio.preciseX() + targetExt.preciseX(), targetExt.preciseHeight() * targetRatio.preciseY() + targetExt.preciseY());
                }
            }
        } else {
            resultantTargetAnchorReference = this.getNewAnchorReferencePoint(target, targetExt, ((Connection)cep.getFigure()).getTargetAnchor().getReferencePoint());
        }
        return new LineSeg(resultantSourceAnchorReference, resultantTargetAnchorReference);
    }

    private void updateNewSlidingAnchorReferenceRatio(ICommandProxy setAnchorCommand, boolean source, PrecisionPoint ratio) {
        SetConnectionAnchorsCommand cmd = this.findSetConnectionAnchorsCommand(setAnchorCommand.getICommand());
        if (cmd != null) {
            PrecisionPoint newRatio = null;
            if (source) {
                newRatio = cmd.getNewSourceTerminal() == null ? new PrecisionPoint(0.5, 0.5) : BaseSlidableAnchor.parseTerminalString((String)cmd.getNewSourceTerminal());
            } else {
                PrecisionPoint precisionPoint = newRatio = cmd.getNewTargetTerminal() == null ? new PrecisionPoint(0.5, 0.5) : BaseSlidableAnchor.parseTerminalString((String)cmd.getNewTargetTerminal());
            }
            if (newRatio != null) {
                ratio.preciseX = newRatio.preciseX;
                ratio.preciseY = newRatio.preciseY;
                ratio.updateInts();
            }
        }
    }

    private SetConnectionAnchorsCommand findSetConnectionAnchorsCommand(ICommand cmd) {
        if (cmd instanceof SetConnectionAnchorsCommand) {
            return (SetConnectionAnchorsCommand)cmd;
        }
        if (cmd instanceof CompositeCommand) {
            ListIterator itr = ((CompositeCommand)cmd).listIterator();
            while (itr.hasNext()) {
                ICommand childCmd = (ICommand)itr.next();
                SetConnectionAnchorsCommand setAnchorsCmd = this.findSetConnectionAnchorsCommand(childCmd);
                if (setAnchorsCmd == null) continue;
                return setAnchorsCmd;
            }
        }
        return null;
    }

    private Point getNewAnchorReferencePoint(Node node, Rectangle nodeBoundsOnDiagram, Point oldAbsReference) {
        GraphicalEditPart gep = (GraphicalEditPart)node.data;
        PrecisionPoint parentLocation = new PrecisionPoint(gep.getFigure().getBounds().getLocation());
        gep.getFigure().translateToAbsolute((Translatable)parentLocation);
        PrecisionDimension diff = new PrecisionDimension(oldAbsReference.preciseX() - parentLocation.preciseX(), oldAbsReference.preciseY() - parentLocation.preciseY());
        this.getMapMode().DPtoLP((Translatable)diff);
        return nodeBoundsOnDiagram.getLocation().translate((Dimension)diff);
    }

    protected Command update_diagram(GraphicalEditPart diagramEP, DirectedGraph g, boolean isLayoutForSelected) {
        CompoundCommand cc = new CompoundCommand("");
        Point diff = this.getLayoutPositionDelta(g, isLayoutForSelected);
        Command cmd = this.createNodeChangeBoundCommands(g, diff);
        if (cmd != null) {
            cc.add(cmd);
        }
        if ((cmd = this.createEdgesChangeBoundsCommands(g, diff)) != null) {
            cc.add(cmd);
        }
        return cc;
    }

    protected Command createEdgesChangeBoundsCommands(DirectedGraph g, Point diff) {
        CompoundCommand cc = new CompoundCommand("");
        PrecisionPointList points = new PrecisionPointList(10);
        ListIterator vi = g.edges.listIterator();
        while (vi.hasNext()) {
            Edge edge = (Edge)vi.next();
            if (edge.data == null || edge.getPoints() == null) continue;
            points.removeAllPoints();
            ConnectionEditPart cep = null;
            Node source = null;
            Node target = null;
            this.collectPoints((PointList)points, edge);
            cep = (ConnectionEditPart)edge.data;
            source = edge.source;
            target = edge.target;
            if (cep == null) continue;
            PointListUtilities.normalizeSegments((PointList)points, (int)MapModeUtil.getMapMode((IFigure)cep.getFigure()).DPtoLP(3));
            Command cmd = this.routeThrough(edge, cep, source, target, (PointList)points, diff);
            if (cmd == null) continue;
            cc.add(cmd);
        }
        if (cc.isEmpty()) {
            return null;
        }
        return cc;
    }

    private void collectPoints(PointList points, Edge edge) {
        PointList pointList = edge.getPoints();
        int i = 0;
        while (i < pointList.size()) {
            Rectangle pt = this.translateFromGraph(new Rectangle(pointList.getPoint(i), new Dimension()));
            points.addPoint(pt.getLocation());
            ++i;
        }
    }

    protected Command createNodeChangeBoundCommands(DirectedGraph g, Point diff) {
        ListIterator vi = g.nodes.listIterator();
        CompoundCommand cc = new CompoundCommand("");
        this.createSubCommands(diff, vi, cc);
        if (cc.isEmpty()) {
            return null;
        }
        return cc;
    }

    protected void createSubCommands(Point diff, ListIterator vi, CompoundCommand cc) {
        while (vi.hasNext()) {
            Node node = (Node)vi.next();
            if (node.data instanceof ShapeEditPart) {
                IGraphicalEditPart gep = (IGraphicalEditPart)node.data;
                ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"move");
                Rectangle nodeExt = this.getNodeMetrics(node);
                PrecisionPoint ptLocation = new PrecisionPoint(nodeExt.preciseX() + diff.preciseX(), nodeExt.preciseY() + diff.preciseY());
                PrecisionPoint ptOldLocation = new PrecisionPoint(gep.getFigure().getBounds().getLocation());
                gep.getFigure().translateToAbsolute((Translatable)ptOldLocation);
                gep.getFigure().translateToAbsolute((Translatable)ptLocation);
                PrecisionPoint delta = new PrecisionPoint(ptLocation.preciseX() - ptOldLocation.preciseX(), ptLocation.preciseY() - ptOldLocation.preciseY());
                request.setEditParts((EditPart)gep);
                request.setMoveDelta((Point)delta);
                request.setLocation((Point)ptLocation);
                Command cmd = gep.getCommand((Request)request);
                if (cmd != null && cmd.canExecute()) {
                    cc.add(cmd);
                }
            }
            if (!(node instanceof ConstantSizeNode)) continue;
            ConstantSizeNode cn = (ConstantSizeNode)node;
            Iterator itr = cn.borderNodes.iterator();
            while (itr.hasNext()) {
                this.createBorderItemChangeBoundsCommand((BorderNode)itr.next(), cn, cc);
            }
        }
    }

    private void createBorderItemChangeBoundsCommand(BorderNode bn, ConstantSizeNode parentNode, CompoundCommand cc) {
        ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"move");
        Rectangle parentRect = this.getNodeMetrics((Node)parentNode);
        Rectangle borderItemRect = this.getNodeMetrics((Node)bn);
        Dimension offset = borderItemRect.getLocation().getDifference(parentRect.getLocation());
        IFigure parentFigure = ((GraphicalEditPart)parentNode.data).getFigure();
        IFigure borderItemFigure = ((GraphicalEditPart)bn.data).getFigure();
        PrecisionPoint oldParentLocation = new PrecisionPoint(parentFigure.getBounds().getLocation());
        PrecisionPoint oldBorderItemLocation = new PrecisionPoint(borderItemFigure.getBounds().getLocation());
        PrecisionPoint newBorderItemLocation = new PrecisionPoint(oldParentLocation.preciseX() + offset.preciseWidth(), oldParentLocation.preciseY() + offset.preciseHeight());
        parentFigure.translateToAbsolute((Translatable)oldParentLocation);
        parentFigure.translateToAbsolute((Translatable)newBorderItemLocation);
        borderItemFigure.translateToAbsolute((Translatable)oldBorderItemLocation);
        PrecisionPoint delta = new PrecisionPoint(newBorderItemLocation.preciseX() - oldBorderItemLocation.preciseX(), newBorderItemLocation.preciseY() - oldBorderItemLocation.preciseY());
        GraphicalEditPart gep = (GraphicalEditPart)bn.data;
        request.setEditParts((EditPart)gep);
        request.setMoveDelta((Point)delta);
        request.setLocation((Point)newBorderItemLocation);
        Command cmd = gep.getCommand((Request)request);
        if (cmd != null && cmd.canExecute()) {
            cc.add(cmd);
        }
    }

    private Point getLayoutPositionDelta(DirectedGraph g, boolean isLayoutForSelected) {
        if (isLayoutForSelected) {
            ListIterator vi = g.nodes.listIterator();
            Point ptLayoutMin = new Point(-1, -1);
            while (vi.hasNext()) {
                Node node = (Node)vi.next();
                if (node.data == null) continue;
                Rectangle nodeExt = this.getNodeMetrics(node);
                if (ptLayoutMin.x == -1) {
                    ptLayoutMin.x = nodeExt.x;
                    ptLayoutMin.y = nodeExt.y;
                    continue;
                }
                ptLayoutMin.x = Math.min(ptLayoutMin.x, nodeExt.x);
                ptLayoutMin.y = Math.min(ptLayoutMin.y, nodeExt.y);
            }
            return new Point(this.minX - ptLayoutMin.x, this.minY - ptLayoutMin.y);
        }
        return new Point(this.layoutDefaultMargin, this.layoutDefaultMargin);
    }

    protected DirectedGraph createGraph() {
        return new DirectedGraph();
    }

    protected DirectedGraphLayout createGraphLayout() {
        return new GMFDirectedGraphLayout();
    }

    public boolean canLayoutNodes(List layoutNodes, boolean shouldOffsetFromBoundingBox, IAdaptable layoutHint) {
        if (super.canLayoutNodes(layoutNodes, shouldOffsetFromBoundingBox, layoutHint)) {
            return !shouldOffsetFromBoundingBox || shouldOffsetFromBoundingBox && layoutNodes.size() > 1;
        }
        return false;
    }

    protected boolean shouldHandleConnectableListItems() {
        return false;
    }
}

