/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.service.impl.tests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ordersystem.Customer;
import ordersystem.LineItem;
import ordersystem.Order;
import ordersystem.OrderSystem;
import ordersystem.OrderSystemFactory;
import ordersystem.special.LimitedEditionProduct;
import ordersystem.special.SpecialFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.internal.service.IProviderOperationExecutor;
import org.eclipse.emf.validation.internal.service.LiveValidator;
import org.eclipse.emf.validation.internal.service.impl.tests.BatchValidatorTest;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.service.ILiveValidator;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.emf.validation.tests.TestBase;
import org.eclipse.emf.validation.tests.TestNotification;
import org.eclipse.emf.validation.util.FilteredCollection;

public class LiveValidatorTest
extends TestBase {
    private LiveValidator validator;

    public LiveValidatorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.validator = new LiveValidator((IProviderOperationExecutor)new BatchValidatorTest.TestExecutor());
    }

    private LiveValidator getValidator() {
        return this.validator;
    }

    public void test_getEvaluationMode() {
        LiveValidatorTest.assertSame((String)"Wrong evaluation mode", (Object)EvaluationMode.LIVE, (Object)this.validator.getEvaluationMode());
    }

    public void test_isReportSuccesses() {
        this.getValidator().setReportSuccesses(true);
        LiveValidatorTest.assertTrue((String)"Not reporting successes", (boolean)this.getValidator().isReportSuccesses());
        this.getValidator().setReportSuccesses(false);
        LiveValidatorTest.assertFalse((String)"Should not report successes", (boolean)this.getValidator().isReportSuccesses());
    }

    public void test_validate_object() {
        TestNotification target = new TestNotification(OrderSystemFactory.eINSTANCE.createProduct(), 1, 1, "123", null);
        try {
            this.getValidator().validate((Object)target);
        }
        catch (Exception e) {
            LiveValidatorTest.fail((String)"Should not throw.");
        }
    }

    public void test_validate_notification() {
        TestNotification target = new TestNotification(OrderSystemFactory.eINSTANCE.createProduct(), 1, 1, "123", null);
        try {
            this.getValidator().validate((Object)target);
        }
        catch (Exception e) {
            LiveValidatorTest.fail((String)"Should not throw.");
        }
    }

    public void test_validateCollection() {
        TestNotification target = new TestNotification(OrderSystemFactory.eINSTANCE.createProduct(), 1, 1, "123", null);
        try {
            this.getValidator().validate(Collections.singleton(target));
            this.getValidator().validate(Collections.emptySet());
        }
        catch (Exception e) {
            LiveValidatorTest.fail((String)"Should not throw.");
        }
    }

    private OrderSystem createOrderSystem() {
        OrderSystem result = OrderSystemFactory.eINSTANCE.createOrderSystem();
        new XMLResourceImpl().getContents().add((Object)result);
        return result;
    }

    public void test_mergeNotifications_add_one() {
        OrderSystem os = this.createOrderSystem();
        NotificationGatherer ng = new NotificationGatherer();
        os.eAdapters().add((Object)ng);
        if (NotificationMergingTestConstraint.instance != null) {
            NotificationMergingTestConstraint.instance.clear();
        }
        Customer c = OrderSystemFactory.eINSTANCE.createCustomer();
        os.getCustomer().add((Object)c);
        ILiveValidator realValidator = (ILiveValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.LIVE);
        realValidator.validate(ng.getNotifications());
        LiveValidatorTest.assertNotNull((Object)((Object)NotificationMergingTestConstraint.instance));
        LiveValidatorTest.assertEquals((int)1, (int)NotificationMergingTestConstraint.instance.getInvocationCount());
        LiveValidatorTest.assertSame((Object)EMFEventType.ADD, (Object)NotificationMergingTestConstraint.instance.getEventType());
        LiveValidatorTest.assertSame((Object)c, (Object)NotificationMergingTestConstraint.instance.getFeatureNewValue());
    }

    public void test_mergeNotifications_add_many() {
        OrderSystem os = this.createOrderSystem();
        NotificationGatherer ng = new NotificationGatherer();
        os.eAdapters().add((Object)ng);
        if (NotificationMergingTestConstraint.instance != null) {
            NotificationMergingTestConstraint.instance.clear();
        }
        ArrayList<Customer> customers = new ArrayList<Customer>();
        Customer c = OrderSystemFactory.eINSTANCE.createCustomer();
        os.getCustomer().add((Object)c);
        customers.add(c);
        c = OrderSystemFactory.eINSTANCE.createCustomer();
        os.getCustomer().add((Object)c);
        customers.add(c);
        c = OrderSystemFactory.eINSTANCE.createCustomer();
        os.getCustomer().add((Object)c);
        customers.add(c);
        ILiveValidator realValidator = (ILiveValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.LIVE);
        realValidator.validate(ng.getNotifications());
        LiveValidatorTest.assertNotNull((Object)((Object)NotificationMergingTestConstraint.instance));
        LiveValidatorTest.assertEquals((int)1, (int)NotificationMergingTestConstraint.instance.getInvocationCount());
        LiveValidatorTest.assertSame((Object)EMFEventType.ADD_MANY, (Object)NotificationMergingTestConstraint.instance.getEventType());
        LiveValidatorTest.assertEquals(customers, (Object)NotificationMergingTestConstraint.instance.getFeatureNewValue());
    }

    public void test_mergeNotifications_remove_one() {
        OrderSystem os = this.createOrderSystem();
        ArrayList<Customer> customers = new ArrayList<Customer>();
        customers.add(OrderSystemFactory.eINSTANCE.createCustomer());
        customers.add(OrderSystemFactory.eINSTANCE.createCustomer());
        customers.add(OrderSystemFactory.eINSTANCE.createCustomer());
        os.getCustomer().addAll(customers);
        NotificationGatherer ng = new NotificationGatherer();
        os.eAdapters().add((Object)ng);
        if (NotificationMergingTestConstraint.instance != null) {
            NotificationMergingTestConstraint.instance.clear();
        }
        Customer c = (Customer)customers.get(0);
        os.getCustomer().remove((Object)c);
        ILiveValidator realValidator = (ILiveValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.LIVE);
        realValidator.validate(ng.getNotifications());
        LiveValidatorTest.assertNotNull((Object)((Object)NotificationMergingTestConstraint.instance));
        LiveValidatorTest.assertEquals((int)1, (int)NotificationMergingTestConstraint.instance.getInvocationCount());
        LiveValidatorTest.assertSame((Object)EMFEventType.REMOVE, (Object)NotificationMergingTestConstraint.instance.getEventType());
        LiveValidatorTest.assertSame((Object)c, (Object)NotificationMergingTestConstraint.instance.getFeatureNewValue());
    }

    public void test_mergeNotifications_remove_many() {
        OrderSystem os = this.createOrderSystem();
        ArrayList<Customer> customers = new ArrayList<Customer>();
        customers.add(OrderSystemFactory.eINSTANCE.createCustomer());
        customers.add(OrderSystemFactory.eINSTANCE.createCustomer());
        customers.add(OrderSystemFactory.eINSTANCE.createCustomer());
        os.getCustomer().addAll(customers);
        NotificationGatherer ng = new NotificationGatherer();
        os.eAdapters().add((Object)ng);
        if (NotificationMergingTestConstraint.instance != null) {
            NotificationMergingTestConstraint.instance.clear();
        }
        os.getCustomer().remove(customers.get(0));
        os.getCustomer().remove(customers.get(1));
        os.getCustomer().remove(customers.get(2));
        ILiveValidator realValidator = (ILiveValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.LIVE);
        realValidator.validate(ng.getNotifications());
        LiveValidatorTest.assertNotNull((Object)((Object)NotificationMergingTestConstraint.instance));
        LiveValidatorTest.assertEquals((int)1, (int)NotificationMergingTestConstraint.instance.getInvocationCount());
        LiveValidatorTest.assertSame((Object)EMFEventType.REMOVE_MANY, (Object)NotificationMergingTestConstraint.instance.getEventType());
        LiveValidatorTest.assertEquals(customers, (Object)NotificationMergingTestConstraint.instance.getFeatureNewValue());
    }

    public void test_mergeNotifications_move_one() {
        OrderSystem os = this.createOrderSystem();
        ArrayList<Customer> customers = new ArrayList<Customer>();
        customers.add(OrderSystemFactory.eINSTANCE.createCustomer());
        customers.add(OrderSystemFactory.eINSTANCE.createCustomer());
        customers.add(OrderSystemFactory.eINSTANCE.createCustomer());
        os.getCustomer().addAll(customers);
        NotificationGatherer ng = new NotificationGatherer();
        os.eAdapters().add((Object)ng);
        if (NotificationMergingTestConstraint.instance != null) {
            NotificationMergingTestConstraint.instance.clear();
        }
        os.getCustomer().move(0, 2);
        ILiveValidator realValidator = (ILiveValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.LIVE);
        realValidator.validate(ng.getNotifications());
        LiveValidatorTest.assertNotNull((Object)((Object)NotificationMergingTestConstraint.instance));
        LiveValidatorTest.assertEquals((int)1, (int)NotificationMergingTestConstraint.instance.getInvocationCount());
        LiveValidatorTest.assertSame((Object)EMFEventType.MOVE, (Object)NotificationMergingTestConstraint.instance.getEventType());
        LiveValidatorTest.assertEquals(os.getCustomer(), (Object)NotificationMergingTestConstraint.instance.getFeatureNewValue());
    }

    public void test_mergeNotifications_move_many() {
        OrderSystem os = this.createOrderSystem();
        ArrayList<Customer> customers = new ArrayList<Customer>();
        customers.add(OrderSystemFactory.eINSTANCE.createCustomer());
        customers.add(OrderSystemFactory.eINSTANCE.createCustomer());
        customers.add(OrderSystemFactory.eINSTANCE.createCustomer());
        os.getCustomer().addAll(customers);
        NotificationGatherer ng = new NotificationGatherer();
        os.eAdapters().add((Object)ng);
        if (NotificationMergingTestConstraint.instance != null) {
            NotificationMergingTestConstraint.instance.clear();
        }
        os.getCustomer().move(0, 2);
        os.getCustomer().move(1, 2);
        os.getCustomer().move(0, 1);
        ILiveValidator realValidator = (ILiveValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.LIVE);
        realValidator.validate(ng.getNotifications());
        LiveValidatorTest.assertNotNull((Object)((Object)NotificationMergingTestConstraint.instance));
        LiveValidatorTest.assertEquals((int)1, (int)NotificationMergingTestConstraint.instance.getInvocationCount());
        LiveValidatorTest.assertSame((Object)EMFEventType.MOVE, (Object)NotificationMergingTestConstraint.instance.getEventType());
        LiveValidatorTest.assertEquals(os.getCustomer(), (Object)NotificationMergingTestConstraint.instance.getFeatureNewValue());
    }

    public void test_mergeNotifications_removingAdapter_one() {
        OrderSystem os = this.createOrderSystem();
        NotificationGatherer ng = new NotificationGatherer();
        os.eAdapters().add((Object)ng);
        if (NotificationMergingTestConstraint.instance != null) {
            NotificationMergingTestConstraint.instance.clear();
        }
        os.eAdapters().remove((Object)ng);
        ILiveValidator realValidator = (ILiveValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.LIVE);
        realValidator.validate(ng.getNotifications());
        LiveValidatorTest.assertNotNull((Object)((Object)NotificationMergingTestConstraint.instance));
        LiveValidatorTest.assertEquals((int)1, (int)NotificationMergingTestConstraint.instance.getInvocationCount());
        LiveValidatorTest.assertSame((Object)EMFEventType.REMOVING_ADAPTER, (Object)NotificationMergingTestConstraint.instance.getEventType());
        LiveValidatorTest.assertSame((Object)((Object)ng), (Object)NotificationMergingTestConstraint.instance.getFeatureNewValue());
    }

    public void test_mergeNotifications_removingAdapter_many() {
        OrderSystem os = this.createOrderSystem();
        NotificationGatherer ng = new NotificationGatherer();
        os.eAdapters().add((Object)ng);
        if (NotificationMergingTestConstraint.instance != null) {
            NotificationMergingTestConstraint.instance.clear();
        }
        os.eAdapters().remove((Object)ng);
        os.eAdapters().add((Object)ng);
        os.eAdapters().remove((Object)ng);
        os.eAdapters().add((Object)ng);
        os.eAdapters().remove((Object)ng);
        ILiveValidator realValidator = (ILiveValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.LIVE);
        realValidator.validate(ng.getNotifications());
        LiveValidatorTest.assertNotNull((Object)((Object)NotificationMergingTestConstraint.instance));
        LiveValidatorTest.assertEquals((int)1, (int)NotificationMergingTestConstraint.instance.getInvocationCount());
        LiveValidatorTest.assertSame((Object)EMFEventType.REMOVING_ADAPTER, (Object)NotificationMergingTestConstraint.instance.getEventType());
        LiveValidatorTest.assertEquals(Collections.nCopies(3, ng), (Object)NotificationMergingTestConstraint.instance.getFeatureNewValue());
    }

    public void test_mergeNotifications_set_one() {
        OrderSystem os = this.createOrderSystem();
        NotificationGatherer ng = new NotificationGatherer();
        os.eAdapters().add((Object)ng);
        if (NotificationMergingTestConstraint.instance != null) {
            NotificationMergingTestConstraint.instance.clear();
        }
        os.setVersion(3);
        ILiveValidator realValidator = (ILiveValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.LIVE);
        realValidator.validate(ng.getNotifications());
        LiveValidatorTest.assertNotNull((Object)((Object)NotificationMergingTestConstraint.instance));
        LiveValidatorTest.assertEquals((int)1, (int)NotificationMergingTestConstraint.instance.getInvocationCount());
        LiveValidatorTest.assertSame((Object)EMFEventType.SET, (Object)NotificationMergingTestConstraint.instance.getEventType());
        LiveValidatorTest.assertEquals((Object)new Integer(3), (Object)NotificationMergingTestConstraint.instance.getFeatureNewValue());
    }

    public void test_mergeNotifications_set_many() {
        OrderSystem os = this.createOrderSystem();
        NotificationGatherer ng = new NotificationGatherer();
        os.eAdapters().add((Object)ng);
        if (NotificationMergingTestConstraint.instance != null) {
            NotificationMergingTestConstraint.instance.clear();
        }
        os.setVersion(1);
        os.setVersion(2);
        os.setVersion(3);
        ILiveValidator realValidator = (ILiveValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.LIVE);
        realValidator.validate(ng.getNotifications());
        LiveValidatorTest.assertNotNull((Object)((Object)NotificationMergingTestConstraint.instance));
        LiveValidatorTest.assertEquals((int)1, (int)NotificationMergingTestConstraint.instance.getInvocationCount());
        LiveValidatorTest.assertSame((Object)EMFEventType.SET, (Object)NotificationMergingTestConstraint.instance.getEventType());
        LiveValidatorTest.assertEquals((Object)new Integer(3), (Object)NotificationMergingTestConstraint.instance.getFeatureNewValue());
    }

    public void test_notificationFilterDefault_177653() {
        Order object = OrderSystemFactory.eINSTANCE.createOrder();
        TestNotification event = new TestNotification(object, 1);
        ILiveValidator localValidator = (ILiveValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.LIVE);
        localValidator.setReportSuccesses(true);
        IStatus[] status = this.getStatuses(localValidator.validate((Notification)event));
        this.assertAllConstraintsNotPresent("live", status, "org.eclipse.emf.validation.tests.order.hasName", "org.eclipse.emf.validation.tests.order.hasOwner");
    }

    public void test_notficationFilterCustom_177653() {
        Order object = OrderSystemFactory.eINSTANCE.createOrder();
        TestNotification event = new TestNotification(object, 1);
        ILiveValidator localValidator = (ILiveValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.LIVE);
        localValidator.setReportSuccesses(true);
        localValidator.setNotificationFilter((FilteredCollection.Filter)new FilteredCollection.Filter<Notification>(){

            public boolean accept(Notification element) {
                return element.getNotifier() instanceof EObject;
            }
        });
        IStatus[] status = this.getStatuses(localValidator.validate((Notification)event));
        this.assertAllConstraintsPresent("live", status, "org.eclipse.emf.validation.tests.order.hasName", "org.eclipse.emf.validation.tests.order.hasOwner");
    }

    public void test_notificationGenerator_177647() {
        Order order = OrderSystemFactory.eINSTANCE.createOrder();
        LineItem item = OrderSystemFactory.eINSTANCE.createLineItem();
        LimitedEditionProduct product = SpecialFactory.eINSTANCE.createLimitedEditionProduct();
        XMIResourceImpl res = new XMIResourceImpl();
        res.getContents().add((Object)order);
        res.getContents().add((Object)item);
        res.getContents().add((Object)product);
        item.setProduct(product);
        order.getItem().add((Object)item);
        TestNotification event = new TestNotification(order, 1);
        ILiveValidator localValidator = (ILiveValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.LIVE);
        localValidator.setReportSuccesses(true);
        IStatus[] status = this.getStatuses(localValidator.validate((Notification)event));
        this.assertAllConstraintsPresent("live", status, "org.eclipse.emf.validation.tests.limitedEdition.canIncludeInSpecial");
        this.assertAllConstraintsNotPresent("live", status, "org.eclipse.emf.validation.tests.limitedEdition.hasDates");
    }

    private static class NotificationGatherer
    extends AdapterImpl {
        private final List<Notification> notifications = new ArrayList<Notification>();

        private NotificationGatherer() {
        }

        public void notifyChanged(Notification msg) {
            this.notifications.add(msg);
        }

        List<Notification> getNotifications() {
            return this.notifications;
        }
    }

    public static class NotificationMergingTestConstraint
    extends AbstractModelConstraint {
        static NotificationMergingTestConstraint instance = null;
        private EMFEventType eventType;
        private Object featureNewValue;
        private int invocationCount = 0;

        public IStatus validate(IValidationContext ctx) {
            instance = this;
            ++this.invocationCount;
            this.eventType = ctx.getEventType();
            this.featureNewValue = ctx.getFeatureNewValue();
            return ctx.createSuccessStatus();
        }

        int getInvocationCount() {
            return this.invocationCount;
        }

        EMFEventType getEventType() {
            return this.eventType;
        }

        Object getFeatureNewValue() {
            return this.featureNewValue;
        }

        void clear() {
            instance = null;
            this.invocationCount = 0;
        }
    }
}

