/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.transaction;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.net4j.util.transaction.ITransaction;
import org.eclipse.net4j.util.transaction.ITransactionalOperation;
import org.eclipse.net4j.util.transaction.TransactionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transaction<CONTEXT>
implements ITransaction<CONTEXT> {
    private List<ITransactionalOperation<CONTEXT>> operations = new ArrayList<ITransactionalOperation<CONTEXT>>();
    private CONTEXT context;
    private boolean undoPhase1OnRollback;

    public Transaction(CONTEXT context, boolean undoPhase1OnRollback) {
        this.context = context;
        this.undoPhase1OnRollback = undoPhase1OnRollback;
    }

    public Transaction(CONTEXT context) {
        this(context, true);
    }

    public boolean isUndoPhase1OnRollback() {
        return this.undoPhase1OnRollback;
    }

    @Override
    public boolean isActive() {
        return this.operations != null;
    }

    @Override
    public CONTEXT getContext() {
        return this.context;
    }

    @Override
    public void execute(ITransactionalOperation<CONTEXT> operation) throws TransactionException {
        if (!this.isActive()) {
            throw new TransactionException("Transaction inactive");
        }
        try {
            operation.phase1(this.context);
            this.operations.add(operation);
        }
        catch (RuntimeException ex) {
            this.rollback();
            throw ex;
        }
        catch (Exception ex) {
            this.rollback();
            throw new TransactionException(ex);
        }
    }

    @Override
    public void commit() {
        for (ITransactionalOperation<CONTEXT> operation : this.end()) {
            operation.phase2(this.context);
        }
    }

    @Override
    public void rollback() {
        if (this.undoPhase1OnRollback) {
            for (ITransactionalOperation<CONTEXT> operation : this.end()) {
                operation.undoPhase1(this.context);
            }
        }
    }

    private List<ITransactionalOperation<CONTEXT>> end() {
        List<ITransactionalOperation<CONTEXT>> tmp = this.operations;
        this.operations = null;
        return tmp;
    }
}

