/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.container.delegate;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.net4j.util.container.ContainerEvent;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.container.delegate.AbstractDelegator;
import org.eclipse.net4j.util.container.delegate.IContainerCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerCollection<E>
extends AbstractDelegator<E>
implements IContainerCollection<E> {
    private Collection<E> delegate;

    public ContainerCollection(Collection<E> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Collection<E> getDelegate() {
        return this.delegate;
    }

    @Override
    public E[] getElements() {
        return this.toArray();
    }

    @Override
    public boolean add(E o) {
        boolean modified = this.getDelegate().add(o);
        if (modified) {
            this.fireAddedEvent(o);
        }
        return modified;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        ContainerEvent<E> event = new ContainerEvent<E>(this);
        for (E e : c) {
            boolean modified = this.getDelegate().add(e);
            if (!modified) continue;
            event.addDelta(e, IContainerDelta.Kind.ADDED);
        }
        return this.dispatchEvent(event);
    }

    @Override
    public void clear() {
        if (!this.isEmpty()) {
            ContainerEvent<E> event = this.createEvent(this.getDelegate(), IContainerDelta.Kind.REMOVED);
            this.getDelegate().clear();
            this.fireEvent(event);
        }
    }

    @Override
    public boolean remove(Object o) {
        boolean modified = this.getDelegate().remove(o);
        if (modified) {
            this.fireRemovedEvent(o);
        }
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        ContainerEvent event = new ContainerEvent(this);
        for (Object o : c) {
            boolean modified = this.getDelegate().remove(o);
            if (!modified) continue;
            event.addDelta(o, IContainerDelta.Kind.REMOVED);
        }
        return this.dispatchEvent(event);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        ContainerEvent<E> event = new ContainerEvent<E>(this);
        for (E o : this.getDelegate()) {
            if (c.contains(o)) continue;
            this.getDelegate().remove(o);
            event.addDelta(o, IContainerDelta.Kind.REMOVED);
        }
        return this.dispatchEvent(event);
    }

    @Override
    public boolean contains(Object o) {
        return this.getDelegate().contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.getDelegate().containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return this.getDelegate().equals(o);
    }

    @Override
    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.getDelegate().isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return new AbstractDelegator.DelegatingIterator(this.getDelegate().iterator());
    }

    @Override
    public int size() {
        return this.getDelegate().size();
    }

    @Override
    public Object[] toArray() {
        return this.getDelegate().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.getDelegate().toArray(a);
    }
}

