/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.concurrent;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.net4j.util.concurrent.ISynchronizer;
import org.eclipse.net4j.util.om.monitor.MonitorUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResultSynchronizer<RESULT>
implements ISynchronizer<RESULT> {
    private RESULT result;
    private Object consumerLock = new Object();
    private CountDownLatch producerLatch = new CountDownLatch(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RESULT get(long timeout) {
        try {
            long stop = System.currentTimeMillis() + timeout;
            Object object = this.consumerLock;
            synchronized (object) {
                while (this.result == null) {
                    try {
                        long remaining = stop - System.currentTimeMillis();
                        if (remaining <= 0L) {
                            return null;
                        }
                        if (MonitorUtil.isCanceled()) {
                            return null;
                        }
                        this.consumerLock.wait(Math.min(remaining, 100L));
                    }
                    catch (InterruptedException interruptedException) {
                        return null;
                    }
                }
                RESULT RESULT = this.result;
                return RESULT;
            }
        }
        finally {
            this.producerLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(RESULT result) {
        Object object = this.consumerLock;
        synchronized (object) {
            this.result = result;
            this.consumerLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(RESULT result, long timeout) {
        Object object = this.consumerLock;
        synchronized (object) {
            this.result = result;
            this.consumerLock.notifyAll();
        }
        try {
            return this.producerLatch.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }
}

