/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util;

public final class StringUtil {
    public static final String EMPTY = "";
    public static final String NL = System.getProperty("line.separator");

    private StringUtil() {
    }

    public static String replace(String text, String[] find, String[] replace) {
        int i = 0;
        while (i < find.length) {
            int start;
            int end = 0;
            while ((start = text.indexOf(find[i], end)) != -1) {
                end = start + find[i].length();
                text = String.valueOf(text.substring(0, start)) + replace[i] + text.substring(end);
            }
            ++i;
        }
        return text;
    }

    public static String safe(String str) {
        if (str == null) {
            return EMPTY;
        }
        return str;
    }

    public static int compare(String s1, String s2) {
        if (s1 == null) {
            return s2 == null ? 0 : -1;
        }
        if (s2 == null) {
            return 1;
        }
        return s1.compareTo(s2);
    }

    public static String cap(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        char first = str.charAt(0);
        if (Character.isUpperCase(first)) {
            return str;
        }
        if (str.length() == 1) {
            return str.toUpperCase();
        }
        StringBuilder builder = new StringBuilder(str);
        builder.setCharAt(0, Character.toUpperCase(first));
        return builder.toString();
    }

    public static String uncap(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        char first = str.charAt(0);
        if (Character.isLowerCase(first)) {
            return str;
        }
        if (str.length() == 1) {
            return str.toLowerCase();
        }
        StringBuilder builder = new StringBuilder(str);
        builder.setCharAt(0, Character.toLowerCase(first));
        return builder.toString();
    }

    public static int occurrences(String str, char c) {
        int count = 0;
        int i = 0;
        while ((i = str.indexOf(c, i)) != -1) {
            ++count;
            ++i;
        }
        return count;
    }

    public static int occurrences(String str, String c) {
        int count = 0;
        int i = 0;
        while ((i = str.indexOf(c, i)) != -1) {
            ++count;
            i += c.length();
        }
        return count;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }
}

