/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.annotations.parser;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.teneo.annotations.StoreAnnotationsException;
import org.eclipse.emf.teneo.annotations.parser.AnnotationParserException;

class AnnotationTokenizer {
    private static final Log log = LogFactory.getLog(AnnotationTokenizer.class);
    static final int T_EOF = 4096;
    private static final int T_EOL = 8192;
    private static final int T_UNKNOWN = 16384;
    static final int T_TYPENAME = 2;
    static final int T_IDENTIFIER = 4;
    static final int T_ARRAYSTART = 8;
    static final int T_ARRAYEND = 16;
    static final int T_VALUE = 32;
    static final int T_IS = 64;
    static final int T_CONTENTSTART = 128;
    static final int T_CONTENTEND = 256;
    static final int T_COMMA = 512;
    private char[] data;
    private int length;
    private int tokBeg;
    private int tokEnd;
    private int currentToken = 4095;
    private HashMap<Integer, String> constantToName = new HashMap();

    AnnotationTokenizer(ENamedElement eNamedElement, String source) {
        this.setSource(source.toCharArray());
        this.constantToName.put(2, "Annotation");
        this.constantToName.put(4, "Attribute Name");
        this.constantToName.put(8, "Array Start ({)");
        this.constantToName.put(16, "Array End (})");
        this.constantToName.put(32, "Value (e.g. String, int)");
        this.constantToName.put(64, "= character");
        this.constantToName.put(128, "Annotation content start ('(')");
        this.constantToName.put(256, "Annotation content end (')')");
        this.constantToName.put(512, "Comma (,)");
        this.constantToName.put(1024, "Carriage Return");
        this.constantToName.put(2048, "Line Feed");
        this.constantToName.put(4096, "EOF");
        this.constantToName.put(8192, "EOL");
        this.constantToName.put(16384, "Unknown");
    }

    public String getCurrentTokenName() {
        String name = this.constantToName.get(this.currentToken);
        if (name == null) {
            throw new StoreAnnotationsException("Illegal token " + this.currentToken);
        }
        return name;
    }

    public String getTokenNames(long tokens) {
        StringBuffer sb = new StringBuffer();
        for (Integer key : this.constantToName.keySet()) {
            if ((tokens & (long)key.intValue()) <= 0L) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(this.constantToName.get(key));
        }
        return sb.toString();
    }

    private void setSource(char[] iSource) {
        this.length = iSource.length;
        this.data = new char[this.length + 3];
        System.arraycopy(iSource, 0, this.data, 0, this.length);
        this.data[this.length] = '\u0000';
        this.data[this.length + 1] = '\u0000';
        this.data[this.length + 2] = '\u0000';
        this.tokBeg = 0;
        this.tokEnd = 0;
        log.debug((Object)this.dump());
    }

    final int nextToken() {
        this.currentToken = this.getNextToken();
        return this.currentToken;
    }

    final int getCurrentToken() {
        return this.currentToken;
    }

    final int getNextToken() {
        char lChar;
        int lCur = this.tokEnd;
        block12: while (true) {
            lChar = this.data[lCur];
            switch (lChar) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    ++lCur;
                    continue block12;
                }
                case '\u0000': {
                    if (lCur == this.length) {
                        return 4096;
                    }
                    throw new AnnotationParserException("Char is 0 but end not reached " + lCur + " " + this.length);
                }
                case '@': {
                    this.tokBeg = ++lCur;
                    while ((lChar = this.data[++lCur]) == '-' || lChar == '_' || lChar == '/' || lChar == '@' || '0' <= lChar && lChar <= '9' || lChar == ':' || 'a' <= lChar && lChar <= 'z' || 'A' <= lChar && lChar <= 'Z') {
                    }
                    this.tokEnd = lCur;
                    return 2;
                }
                case '\"': {
                    this.tokBeg = lCur;
                    while ((lChar = this.data[++lCur]) == ',' || lChar == '-' || lChar == '.' || lChar == ' ' || lChar == '_' || lChar == '/' || lChar == '@' || lChar == ':' || lChar == '=' || lChar == '(' || lChar == ')' || lChar == '{' || lChar == '}' || lChar == '\'' || lChar == '#' || lChar == '&' || lChar == '<' || lChar == '>' || lChar == '$' || lChar == ';' || lChar == '%' || lChar == '*' || lChar == '\'' || '0' <= lChar && lChar <= '9' || 'a' <= lChar && lChar <= 'z' || lChar == '?' || 'A' <= lChar && lChar <= 'Z') {
                    }
                    if (lChar != '\"') {
                        AnnotationParserException e = new AnnotationParserException("Value not closed with double quote, see the _ for the location " + this.getErrorText());
                        this.tokEnd = lCur + 1;
                        throw e;
                    }
                    this.tokEnd = lCur + 1;
                    return 32;
                }
                case '(': {
                    this.tokBeg = lCur;
                    this.tokEnd = lCur + 1;
                    return 128;
                }
                case ')': {
                    this.tokBeg = lCur;
                    this.tokEnd = lCur + 1;
                    return 256;
                }
                case '{': {
                    this.tokBeg = lCur;
                    this.tokEnd = lCur + 1;
                    return 8;
                }
                case '}': {
                    this.tokBeg = lCur;
                    this.tokEnd = lCur + 1;
                    return 16;
                }
                case ',': {
                    this.tokBeg = lCur;
                    this.tokEnd = lCur + 1;
                    return 512;
                }
                case '=': {
                    this.tokBeg = lCur;
                    this.tokEnd = lCur + 1;
                    return 64;
                }
            }
            break;
        }
        this.tokBeg = lCur;
        while ((lChar = this.data[++lCur]) == '.' || lChar == '-' || lChar == '_' || lChar == '/' || lChar == '@' || '0' <= lChar && lChar <= '9' || 'a' <= lChar && lChar <= 'z' || 'A' <= lChar && lChar <= 'Z') {
        }
        this.tokEnd = lCur;
        return 4;
    }

    final String getLexeme() {
        return new String(this.data, this.tokBeg, this.tokEnd - this.tokBeg);
    }

    final String getErrorText() {
        return String.valueOf(new String(this.data, 0, this.tokEnd)) + "_" + new String(this.data, this.tokEnd, this.data.length - this.tokEnd - 2) + "\nCurrent lexeme: " + this.getLexeme();
    }

    final String dump() {
        StringBuffer result = new StringBuffer();
        int oldTokBeg = this.tokBeg;
        int oldTokEnd = this.tokEnd;
        int oldCurrentToken = this.currentToken;
        this.tokBeg = 0;
        this.tokEnd = 0;
        boolean lFinished = false;
        int lTok = 0;
        while (!lFinished) {
            try {
                lTok = this.nextToken();
                if (lTok != 8192) {
                    result.append("Tok: " + lTok + ": '" + this.getLexeme() + "'\n");
                }
            }
            catch (AnnotationParserException annotationParserException) {
                result.append("Tok: 16384: " + this.getLexeme() + "'");
            }
            boolean bl = lFinished = lTok == 4096;
        }
        this.tokBeg = oldTokBeg;
        this.tokEnd = oldTokEnd;
        this.currentToken = oldCurrentToken;
        return result.toString();
    }
}

