/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.util;

import org.eclipse.emf.cdo.common.id.CDOIDMetaRange;
import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.model.CDOClassProxy;
import org.eclipse.emf.cdo.common.model.CDOClassRef;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackage;
import org.eclipse.emf.cdo.common.model.CDOPackageManager;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.model.core.CDOCorePackage;
import org.eclipse.emf.cdo.common.model.resource.CDOResourceClass;
import org.eclipse.emf.cdo.common.model.resource.CDOResourcePackage;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.spi.common.InternalCDOClass;
import org.eclipse.emf.cdo.spi.common.InternalCDOFeature;
import org.eclipse.emf.cdo.spi.common.InternalCDOPackage;
import org.eclipse.emf.cdo.util.CDOPackageRegistry;
import org.eclipse.emf.cdo.util.EMFUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.emf.internal.cdo.CDOFactoryImpl;
import org.eclipse.emf.internal.cdo.CDOSessionImpl;
import org.eclipse.emf.internal.cdo.CDOSessionPackageManagerImpl;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public final class ModelUtil {
    private static final ContextTracer MODEL = new ContextTracer(OM.DEBUG_MODEL, ModelUtil.class);

    private ModelUtil() {
    }

    public static String getParentURI(EPackage ePackage) {
        EPackage superPackage = ePackage.getESuperPackage();
        String parentURI = superPackage == null ? null : superPackage.getNsURI();
        return parentURI;
    }

    public static EPackage getTopLevelPackage(EPackage ePackage) {
        EPackage superPackage = ePackage.getESuperPackage();
        return superPackage == null ? ePackage : ModelUtil.getTopLevelPackage(superPackage);
    }

    public static CDOType getCDOType(EStructuralFeature eFeature) {
        if (eFeature instanceof EReference) {
            throw new ImplementationError("Should only be called for attributes");
        }
        EClassifier classifier = eFeature.getEType();
        if (classifier.getEPackage() == EcorePackage.eINSTANCE) {
            int classifierID = classifier.getClassifierID();
            switch (classifierID) {
                case 22: 
                case 23: 
                case 24: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 31: 
                case 32: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 43: 
                case 44: 
                case 48: 
                case 49: {
                    CDOType type = CDOModelUtil.getType((int)classifierID);
                    if (type == CDOType.OBJECT) {
                        throw new ImplementationError("Attributes can not be of type OBJECT");
                    }
                    return type;
                }
                case 50: {
                    return CDOType.STRING;
                }
            }
        }
        if (classifier instanceof EDataType) {
            return CDOType.CUSTOM;
        }
        throw new IllegalArgumentException("Invalid attribute type: " + classifier);
    }

    public static void initializeCDOPackage(EPackage ePackage, CDOPackage cdoPackage) {
        ((InternalCDOPackage)cdoPackage).setClientInfo((Object)ePackage);
        for (EClass eClass : EMFUtil.getPersistentClasses(ePackage)) {
            CDOClass cdoClass = ModelUtil.createCDOClass(eClass, cdoPackage);
            ((InternalCDOPackage)cdoPackage).addClass(cdoClass);
        }
    }

    public static CDOPackage getCDOPackage(EPackage ePackage, CDOSessionPackageManagerImpl packageManager) {
        String packageURI = ePackage.getNsURI();
        CDOPackage cdoPackage = packageManager.lookupPackage(packageURI);
        if (cdoPackage == null) {
            EPackage topLevelPackage = ModelUtil.getTopLevelPackage(ePackage);
            if (topLevelPackage != ePackage) {
                ModelUtil.getCDOPackage(topLevelPackage, packageManager);
                cdoPackage = packageManager.lookupPackage(packageURI);
            } else {
                cdoPackage = ModelUtil.addCDOPackage(topLevelPackage, packageManager);
            }
        }
        return cdoPackage;
    }

    public static CDOClass getCDOClass(EClass eClass, CDOSessionPackageManagerImpl packageManager) {
        CDOPackage cdoPackage = ModelUtil.getCDOPackage(eClass.getEPackage(), packageManager);
        return cdoPackage.lookupClass(eClass.getClassifierID());
    }

    public static CDOFeature getCDOFeature(EStructuralFeature eFeature, CDOSessionPackageManagerImpl packageManager) {
        CDOClass cdoClass = ModelUtil.getCDOClass(eFeature.getEContainingClass(), packageManager);
        return cdoClass.lookupFeature(eFeature.getFeatureID());
    }

    private static CDOPackage addCDOPackage(EPackage ePackage, CDOSessionPackageManagerImpl packageManager) {
        CDOPackage cdoPackage = ModelUtil.createCDOPackage(ePackage, packageManager);
        packageManager.addPackage(cdoPackage);
        for (EPackage subPackage : ePackage.getESubpackages()) {
            ModelUtil.addCDOPackage(subPackage, packageManager);
        }
        return cdoPackage;
    }

    private static CDOPackage createCDOPackage(EPackage ePackage, CDOSessionPackageManagerImpl packageManager) {
        CDOSessionImpl session = packageManager.getSession();
        String uri = ePackage.getNsURI();
        String parentURI = ModelUtil.getParentURI(ePackage);
        String name = ePackage.getName();
        boolean dynamic = EMFUtil.isDynamicEPackage(ePackage);
        String ecore = null;
        CDOIDMetaRange idRange = null;
        if (parentURI == null) {
            if (!EcorePackage.eINSTANCE.getNsURI().equals(uri)) {
                ecore = EMFUtil.ePackageToString(ePackage, session.getPackageRegistry());
            }
            idRange = session.registerEPackage(ePackage);
        }
        CDOPackage cdoPackage = CDOModelUtil.createPackage((CDOPackageManager)packageManager, (String)uri, (String)name, ecore, (boolean)dynamic, idRange, (String)parentURI);
        ModelUtil.initializeCDOPackage(ePackage, cdoPackage);
        return cdoPackage;
    }

    private static CDOClass createCDOClass(EClass eClass, CDOPackage containingPackage) {
        InternalCDOClass cdoClass = (InternalCDOClass)CDOModelUtil.createClass((CDOPackage)containingPackage, (int)eClass.getClassifierID(), (String)eClass.getName(), (boolean)eClass.isAbstract());
        cdoClass.setClientInfo((Object)eClass);
        for (EClass superType : eClass.getESuperTypes()) {
            CDOClassRef classRef = ModelUtil.createClassRef((EClassifier)superType);
            cdoClass.addSuperType(classRef);
        }
        for (EStructuralFeature eFeature : EMFUtil.getPersistentFeatures((EList<EStructuralFeature>)eClass.getEStructuralFeatures())) {
            CDOFeature cdoFeature = ModelUtil.createCDOFeature(eFeature, (CDOClass)cdoClass);
            cdoClass.addFeature(cdoFeature);
        }
        return cdoClass;
    }

    private static CDOFeature createCDOFeature(EStructuralFeature eFeature, CDOClass containingClass) {
        InternalCDOFeature cdoFeature = (InternalCDOFeature)(EMFUtil.isReference(eFeature) ? ModelUtil.createCDOReference((EReference)eFeature, containingClass) : ModelUtil.createCDOAttribute((EAttribute)eFeature, containingClass));
        cdoFeature.setClientInfo((Object)eFeature);
        return cdoFeature;
    }

    private static CDOFeature createCDOReference(EReference eFeature, CDOClass containingClass) {
        CDOPackageManager packageManager = containingClass.getPackageManager();
        int featureID = eFeature.getFeatureID();
        String name = eFeature.getName();
        CDOClassRef classRef = ModelUtil.createClassRef(eFeature.getEType());
        boolean many = eFeature.isMany();
        boolean containment = EMFUtil.isContainment((EStructuralFeature)eFeature);
        CDOFeature cdoFeature = CDOModelUtil.createReference((CDOClass)containingClass, (int)featureID, (String)name, (CDOClassProxy)new CDOClassProxy(classRef, packageManager), (boolean)many, (boolean)containment);
        EReference opposite = eFeature.getEOpposite();
        if (MODEL.isEnabled() && opposite != null) {
            MODEL.format("Opposite info: package={0}, class={1}, feature={2}", new Object[]{opposite.getEContainingClass().getEPackage().getNsURI(), opposite.getEContainingClass().getName(), opposite.getName()});
        }
        return cdoFeature;
    }

    private static CDOFeature createCDOAttribute(EAttribute eFeature, CDOClass containingClass) {
        int featureID = eFeature.getFeatureID();
        String name = eFeature.getName();
        CDOType type = ModelUtil.getCDOType((EStructuralFeature)eFeature);
        boolean many = EMFUtil.isMany((EStructuralFeature)eFeature);
        return CDOModelUtil.createAttribute((CDOClass)containingClass, (int)featureID, (String)name, (CDOType)type, (boolean)many);
    }

    public static EPackage getEPackage(CDOPackage cdoPackage, CDOPackageRegistry packageRegistry) {
        EPackage ePackage = (EPackage)cdoPackage.getClientInfo();
        if (ePackage == null) {
            String uri = cdoPackage.getPackageURI();
            ePackage = packageRegistry.getEPackage(uri);
            if (ePackage == null) {
                ePackage = ModelUtil.createEPackage(cdoPackage);
                packageRegistry.put(uri, ePackage);
            }
            ((InternalCDOPackage)cdoPackage).setClientInfo((Object)ePackage);
        }
        return ePackage;
    }

    public static EClass getEClass(CDOClass cdoClass, CDOPackageRegistry packageRegistry) {
        EClass eClass = (EClass)cdoClass.getClientInfo();
        if (eClass == null) {
            EPackage ePackage = ModelUtil.getEPackage(cdoClass.getContainingPackage(), packageRegistry);
            eClass = (EClass)ePackage.getEClassifier(cdoClass.getName());
            ((InternalCDOClass)cdoClass).setClientInfo((Object)eClass);
        }
        return eClass;
    }

    public static EStructuralFeature getEFeature(CDOFeature cdoFeature, CDOPackageRegistry packageRegistry) {
        EStructuralFeature eFeature = (EStructuralFeature)cdoFeature.getClientInfo();
        if (eFeature == null) {
            EClass eClass = ModelUtil.getEClass(cdoFeature.getContainingClass(), packageRegistry);
            eFeature = eClass.getEStructuralFeature(cdoFeature.getFeatureID());
            ((InternalCDOFeature)cdoFeature).setClientInfo((Object)eFeature);
        }
        return eFeature;
    }

    public static EPackage createEPackage(CDOPackage cdoPackage) {
        EPackage ePackage;
        if (!cdoPackage.isDynamic() && (ePackage = ModelUtil.createGeneratedEPackage(cdoPackage.getPackageURI())) != null) {
            return ePackage;
        }
        return ModelUtil.createDynamicEPackage(cdoPackage);
    }

    public static EPackage createGeneratedEPackage(String packageURI) {
        if (packageURI.equals(EcorePackage.eINSTANCE.getNsURI())) {
            return EcorePackage.eINSTANCE;
        }
        return EPackage.Registry.INSTANCE.getEPackage(packageURI);
    }

    public static EPackageImpl createDynamicEPackage(CDOPackage cdoPackage) {
        String ecore = cdoPackage.getEcore();
        EPackageImpl ePackage = (EPackageImpl)EMFUtil.ePackageFromString(ecore);
        ModelUtil.prepareEPackage(ePackage);
        return ePackage;
    }

    public static void prepareEPackage(EPackageImpl ePackage) {
        ePackage.setEFactoryInstance((EFactory)new CDOFactoryImpl((EPackage)ePackage));
        EMFUtil.fixEClassifiers(ePackage);
    }

    public static CDOClassRef createClassRef(EClassifier classifier) {
        if (classifier instanceof EClass) {
            String packageURI = classifier.getEPackage().getNsURI();
            int classifierID = classifier.getClassifierID();
            return CDOModelUtil.createClassRef((String)packageURI, (int)classifierID);
        }
        return null;
    }

    public static void addModelInfos(CDOSessionPackageManagerImpl packageManager) {
        CDOCorePackage corePackage = packageManager.getCDOCorePackage();
        ((InternalCDOPackage)corePackage).setClientInfo((Object)EcorePackage.eINSTANCE);
        ((InternalCDOClass)corePackage.getCDOObjectClass()).setClientInfo((Object)EcorePackage.eINSTANCE.getEObject());
        CDOResourcePackage resourcePackage = packageManager.getCDOResourcePackage();
        ((InternalCDOPackage)resourcePackage).setClientInfo((Object)EresourcePackage.eINSTANCE);
        CDOResourceClass resourceClass = resourcePackage.getCDOResourceClass();
        ((InternalCDOClass)resourceClass).setClientInfo((Object)EresourcePackage.eINSTANCE.getCDOResource());
        ((InternalCDOFeature)resourceClass.getCDOContentsFeature()).setClientInfo((Object)EresourcePackage.eINSTANCE.getCDOResource_Contents());
        ((InternalCDOFeature)resourceClass.getCDOPathFeature()).setClientInfo((Object)EresourcePackage.eINSTANCE.getCDOResource_Path());
    }
}

