/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.CDOQueryInfo;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.io.CDODataOutput;
import org.eclipse.emf.cdo.internal.common.CDOQueryInfoImpl;
import org.eclipse.emf.cdo.internal.server.QueryManager;
import org.eclipse.emf.cdo.internal.server.QueryResult;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.internal.server.protocol.CDOReadIndication;
import org.eclipse.emf.cdo.internal.server.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class QueryIndication
extends CDOReadIndication {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, QueryIndication.class);
    private QueryResult queryResult;

    public QueryIndication(CDOServerProtocol protocol) {
        super(protocol, (short)18);
    }

    protected void indicating(CDODataInput in) throws IOException {
        int viewID = in.readInt();
        CDOQueryInfoImpl cdoQuery = new CDOQueryInfoImpl(in);
        IView view = this.getSession().getView(viewID);
        QueryManager queryManager = this.getRepository().getQueryManager();
        this.queryResult = queryManager.execute(view, (CDOQueryInfo)cdoQuery);
    }

    protected void responding(CDODataOutput out) throws IOException {
        int numberOfResults = 0;
        out.writeInt(this.queryResult.getQueryID());
        this.flush();
        while (this.queryResult.hasNext()) {
            Object object = this.queryResult.next();
            ++numberOfResults;
            out.writeBoolean(true);
            out.writeCDORevisionOrPrimitive(object);
            if (this.queryResult.peek() != null) continue;
            this.flush();
        }
        if (TRACER.isEnabled()) {
            TRACER.trace("Query returned " + numberOfResults + " results");
        }
        out.writeBoolean(false);
    }
}

