/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.util.Collection;
import org.eclipse.emf.cdo.common.id.CDOIDMetaRange;
import org.eclipse.emf.cdo.common.id.CDOIDObjectFactory;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackage;
import org.eclipse.emf.cdo.common.model.CDOPackageInfo;
import org.eclipse.emf.cdo.common.model.CDOPackageManager;
import org.eclipse.emf.cdo.internal.common.model.CDOPackageManagerImpl;
import org.eclipse.emf.cdo.internal.server.Repository;
import org.eclipse.emf.cdo.server.IPackageManager;
import org.eclipse.emf.cdo.server.IStoreReader;
import org.eclipse.emf.cdo.server.StoreUtil;

public class PackageManager
extends CDOPackageManagerImpl
implements IPackageManager {
    private Repository repository;

    public PackageManager(Repository repository) {
        this.repository = repository;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public CDOIDObjectFactory getCDOIDObjectFactory() {
        return this.repository.getStore().getCDOIDObjectFactory();
    }

    protected void resolve(CDOPackage cdoPackage) {
        if (!cdoPackage.isSystem()) {
            IStoreReader storeReader = StoreUtil.getReader();
            storeReader.readPackage(cdoPackage);
        }
    }

    protected String provideEcore(CDOPackage cdoPackage) {
        return null;
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        IStoreReader storeReader = null;
        try {
            storeReader = this.repository.getStore().getReader(null);
            Collection<CDOPackageInfo> packageInfos = storeReader.readPackageInfos();
            for (CDOPackageInfo info : packageInfos) {
                this.addPackage(CDOModelUtil.createProxyPackage((CDOPackageManager)this, (String)info.getPackageURI(), (boolean)info.isDynamic(), (CDOIDMetaRange)info.getMetaIDRange(), (String)info.getParentURI()));
            }
        }
        finally {
            if (storeReader != null) {
                storeReader.release();
            }
        }
    }
}

