/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision.cache.lru;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.cache.CDORevisionCache;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.internal.common.revision.cache.EvictionEventImpl;
import org.eclipse.emf.cdo.internal.common.revision.cache.lru.DLRevisionHolder;
import org.eclipse.emf.cdo.internal.common.revision.cache.lru.LRURevisionHolder;
import org.eclipse.emf.cdo.internal.common.revision.cache.lru.LRURevisionList;
import org.eclipse.emf.cdo.internal.common.revision.cache.lru.RevisionHolder;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRURevisionCache
extends Lifecycle
implements CDORevisionCache {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_REVISION, LRURevisionCache.class);
    private Map<CDOID, RevisionHolder> revisions = new HashMap<CDOID, RevisionHolder>();
    private int capacityCurrent;
    private int capacityRevised;
    private LRU currentLRU;
    private LRU revisedLRU;

    public int getCapacityCurrent() {
        return this.capacityCurrent;
    }

    public void setCapacityCurrent(int capacity) {
        this.capacityCurrent = capacity;
        if (this.currentLRU != null) {
            this.currentLRU.capacity(capacity);
        }
    }

    public int getCapacityRevised() {
        return this.capacityRevised;
    }

    public void setCapacityRevised(int capacity) {
        this.capacityRevised = capacity;
        if (this.revisedLRU != null) {
            this.revisedLRU.capacity(capacity);
        }
    }

    @Override
    public synchronized List<CDORevision> getRevisions() {
        ArrayList<CDORevision> currentRevisions = new ArrayList<CDORevision>();
        for (RevisionHolder holder : this.revisions.values()) {
            InternalCDORevision revision = holder.getRevision();
            if (revision == null || !revision.isCurrent()) continue;
            currentRevisions.add(revision);
        }
        return currentRevisions;
    }

    @Override
    public synchronized EClass getObjectType(CDOID id) {
        RevisionHolder holder = this.getHolder(id);
        if (holder == null) {
            return null;
        }
        InternalCDORevision revision = holder.getRevision();
        return revision.getEClass();
    }

    @Override
    public synchronized InternalCDORevision getRevision(CDOID id) {
        InternalCDORevision revision;
        RevisionHolder holder = this.getHolder(id);
        InternalCDORevision internalCDORevision = revision = holder == null ? null : holder.getRevision();
        if (revision == null || !revision.isCurrent()) {
            return null;
        }
        return revision;
    }

    @Override
    public synchronized InternalCDORevision getRevisionByTime(CDOID id, long timeStamp) {
        RevisionHolder holder = this.getHolder(id);
        return this.getRevisionByTime(holder, timeStamp);
    }

    @Override
    public synchronized InternalCDORevision getRevisionByVersion(CDOID id, int version) {
        for (RevisionHolder holder = this.getHolder(id); holder != null; holder = holder.getNext()) {
            int holderVersion = holder.getVersion();
            if (holderVersion > version) {
                continue;
            }
            if (holderVersion != version) break;
            return holder.getRevision();
        }
        return null;
    }

    @Override
    public synchronized boolean addRevision(InternalCDORevision revision) {
        RevisionHolder holder;
        if (TRACER.isEnabled()) {
            TRACER.format("Adding revision: {0}, created={1,date} {1,time}, revised={2,date} {2,time}, current={3}", new Object[]{revision, revision.getCreated(), revision.getRevised(), revision.isCurrent()});
        }
        RevisionHolder newHolder = this.createHolder(revision);
        LRU list = revision.isCurrent() ? this.currentLRU : this.revisedLRU;
        list.add((DLRevisionHolder)newHolder);
        int version = revision.getVersion();
        RevisionHolder lastHolder = null;
        for (holder = this.getHolder(revision.getID()); holder != null; holder = holder.getNext()) {
            int holderVersion = holder.getVersion();
            if (holderVersion > version) {
                lastHolder = holder;
                continue;
            }
            if (holderVersion != version) break;
            return false;
        }
        this.adjustHolder(revision, newHolder, lastHolder, holder);
        return true;
    }

    @Override
    public synchronized InternalCDORevision removeRevision(CDOID id, int version) {
        InternalCDORevision revision = null;
        RevisionHolder holder = this.getHolder(id);
        while (holder != null) {
            int holderVersion = holder.getVersion();
            if (holderVersion > version) {
                holder = holder.getNext();
                continue;
            }
            if (holderVersion == version) {
                revision = holder.getRevision();
                this.removeHolder(holder);
            }
            holder = null;
        }
        return revision;
    }

    public synchronized boolean removeRevisions(CDOID id) {
        RevisionHolder lookupHolder;
        RevisionHolder holder = lookupHolder = this.getHolder(id);
        while (holder != null) {
            RevisionHolder nextHolder = holder.getNext();
            this.removeHolder(holder);
            holder = nextHolder;
        }
        return lookupHolder != null;
    }

    @Override
    public synchronized CDOID getResourceID(CDOID folderID, String name, long timeStamp) {
        CDOID[] ids;
        CDOID[] cDOIDArray = ids = this.getRevisionIDs();
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature feature;
            String revisionName;
            CDOID revisionFolderID;
            InternalCDORevision revision;
            CDOID id = cDOIDArray[n2];
            RevisionHolder holder = this.getHolder(id);
            if (holder != null && (revision = holder.getRevision()).isResourceNode() && (revision = this.getRevisionByTime(holder, timeStamp)) != null && CDOIDUtil.equals(revisionFolderID = (CDOID)revision.getContainerID(), folderID) && ObjectUtil.equals((Object)(revisionName = (String)revision.getValue(feature = revision.getEClass().getEStructuralFeature("name"))), (Object)name)) {
                return revision.getID();
            }
            ++n2;
        }
        return null;
    }

    @Override
    public synchronized void clear() {
        this.revisions.clear();
        this.currentLRU = new LRU(this.capacityCurrent);
        this.revisedLRU = new LRU(this.capacityRevised);
    }

    private synchronized CDOID[] getRevisionIDs() {
        return this.revisions.keySet().toArray(new CDOID[this.revisions.size()]);
    }

    private InternalCDORevision getRevisionByTime(RevisionHolder holder, long timeStamp) {
        while (holder != null) {
            int indicator = holder.compareTo(timeStamp);
            if (indicator == 1) {
                holder = holder.getNext();
                continue;
            }
            if (indicator != 0) break;
            return holder.getRevision();
        }
        return null;
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.currentLRU = new LRU(this.capacityCurrent);
        this.revisedLRU = new LRU(this.capacityRevised);
    }

    protected void doDeactivate() throws Exception {
        this.currentLRU = null;
        this.revisedLRU = null;
        super.doDeactivate();
    }

    public final synchronized RevisionHolder getHolder(CDOID id) {
        return this.revisions.get(id);
    }

    protected RevisionHolder createHolder(InternalCDORevision revision) {
        return new LRURevisionHolder(revision);
    }

    private void adjustHolder(InternalCDORevision revision, RevisionHolder holder, RevisionHolder prevHolder, RevisionHolder nextHolder) {
        if (prevHolder != null) {
            if (nextHolder == null) {
                nextHolder = prevHolder.getNext();
            }
            holder.setPrev(prevHolder);
            holder.setNext(nextHolder);
            prevHolder.setNext(holder);
        } else {
            holder.setNext(nextHolder);
            this.revisions.put(revision.getID(), holder);
        }
        this.reviseHolder(holder, nextHolder);
    }

    private void reviseHolder(RevisionHolder holder, RevisionHolder nextHolder) {
        if (nextHolder != null) {
            nextHolder.setPrev(holder);
            if (holder.isCurrent() && nextHolder.isCurrent()) {
                this.currentLRU.remove((DLRevisionHolder)nextHolder);
                this.revisedLRU.add((DLRevisionHolder)nextHolder);
                InternalCDORevision oldRevision = nextHolder.getRevision();
                if (oldRevision != null && oldRevision.getRevised() == 0L && holder.getCreated() > 0L && oldRevision.getVersion() == holder.getVersion() - 1) {
                    oldRevision.setRevised(holder.getCreated() - 1L);
                }
            }
        }
    }

    private synchronized void removeHolder(RevisionHolder holder) {
        CDOID id = holder.getID();
        RevisionHolder prev = holder.getPrev();
        RevisionHolder next = holder.getNext();
        if (next != null) {
            next.setPrev(prev);
        }
        if (prev != null) {
            prev.setNext(next);
        } else if (next != null) {
            this.revisions.put(id, next);
        } else {
            this.revisions.remove(id);
        }
        holder.setPrev(null);
        holder.setNext(null);
    }

    private final class LRU
    extends LRURevisionList {
        public LRU(int capacity) {
            super(capacity);
        }

        public String toString() {
            return MessageFormat.format("LRU[size={0}, capacity={1}]", this.size(), this.capacity());
        }

        protected void evict(LRURevisionHolder holder) {
            if (TRACER.isEnabled()) {
                TRACER.format("Evicting revision {0}v{1}", new Object[]{holder.getID(), holder.getVersion()});
            }
            InternalCDORevision revision = holder.getRevision();
            boolean revised = !holder.isCurrent();
            super.evict(holder);
            LRURevisionCache.this.removeHolder(holder);
            if (revision != null) {
                if (this == LRURevisionCache.this.currentLRU && revised) {
                    LRURevisionCache.this.addRevision(revision);
                } else {
                    LRURevisionCache.this.fireEvent(new EvictionEventImpl(LRURevisionCache.this, revision));
                }
            }
        }
    }
}

