/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.model;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.model.CDOClassProxy;
import org.eclipse.emf.cdo.common.model.CDOClassRef;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackage;
import org.eclipse.emf.cdo.common.model.CDOPackageManager;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.internal.common.model.CDOModelElementImpl;
import org.eclipse.emf.cdo.spi.common.InternalCDOClass;
import org.eclipse.emf.cdo.spi.common.InternalCDOFeature;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class CDOFeatureImpl
extends CDOModelElementImpl
implements InternalCDOFeature {
    private static final int UNKNOWN_FEATURE_INDEX = Integer.MIN_VALUE;
    private static final ContextTracer MODEL = new ContextTracer(OM.DEBUG_MODEL, CDOFeatureImpl.class);
    private static final ContextTracer PROTOCOL = new ContextTracer(OM.DEBUG_PROTOCOL, CDOFeatureImpl.class);
    private CDOClass containingClass;
    private int featureID;
    private int featureIndex = Integer.MIN_VALUE;
    private CDOType type;
    private boolean many;
    private boolean containment;
    private CDOClassProxy referenceTypeProxy;

    public CDOFeatureImpl() {
    }

    public CDOFeatureImpl(CDOClass containingClass, int featureID, String name, CDOType type, boolean many) {
        super(name);
        if (type == CDOType.OBJECT) {
            throw new IllegalArgumentException("type == OBJECT");
        }
        this.containingClass = containingClass;
        this.featureID = featureID;
        this.type = type;
        this.many = many;
        if (MODEL.isEnabled()) {
            MODEL.format("Created {0}", new Object[]{this});
        }
    }

    public CDOFeatureImpl(CDOClass containingClass, int featureID, String name, CDOClassProxy referenceTypeProxy, boolean many, boolean containment) {
        super(name);
        if (referenceTypeProxy == null) {
            throw new IllegalArgumentException("referenceTypeProxy == null");
        }
        this.containingClass = containingClass;
        this.featureID = featureID;
        this.type = CDOType.OBJECT;
        this.many = many;
        this.containment = containment;
        this.referenceTypeProxy = referenceTypeProxy;
        if (MODEL.isEnabled()) {
            MODEL.format("Created {0}", new Object[]{this});
        }
    }

    public CDOFeatureImpl(CDOClass containingClass, ExtendedDataInput in) throws IOException {
        this.containingClass = containingClass;
        this.read(in);
    }

    public void read(ExtendedDataInput in) throws IOException {
        super.read(in);
        this.featureID = in.readInt();
        this.type = CDOModelUtil.readType(in);
        this.many = in.readBoolean();
        this.containment = in.readBoolean();
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Read feature: ID={0}, name={1}, type={2}, many={3}, containment={4}", new Object[]{this.featureID, this.getName(), this.type, this.many, this.containment});
        }
        if (this.isReference()) {
            String defaultURI = this.containingClass.getContainingPackage().getPackageURI();
            CDOClassRef classRef = CDOModelUtil.readClassRef(in, defaultURI);
            if (PROTOCOL.isEnabled()) {
                PROTOCOL.format("Read reference type: classRef={0}", new Object[]{classRef});
            }
            this.referenceTypeProxy = new CDOClassProxy(classRef, this.containingClass.getContainingPackage().getPackageManager());
        }
    }

    public void write(ExtendedDataOutput out) throws IOException {
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Writing feature: ID={0}, name={1}, type={2}, many={3}, containment={4}", new Object[]{this.featureID, this.getName(), this.type, this.many, this.containment});
        }
        super.write(out);
        out.writeInt(this.featureID);
        CDOModelUtil.writeType(out, this.type);
        out.writeBoolean(this.many);
        out.writeBoolean(this.containment);
        if (this.isReference()) {
            CDOClassRef classRef = this.referenceTypeProxy.getClassRef();
            if (PROTOCOL.isEnabled()) {
                PROTOCOL.format("Writing reference type: classRef={0}", new Object[]{classRef});
            }
            CDOModelUtil.writeClassRef(out, classRef, this.getContainingPackage().getPackageURI());
        }
    }

    public CDOPackageManager getPackageManager() {
        return this.getContainingPackage().getPackageManager();
    }

    public CDOPackage getContainingPackage() {
        return this.containingClass.getContainingPackage();
    }

    public CDOClass getContainingClass() {
        return this.containingClass;
    }

    public void setContainingClass(CDOClass containingClass) {
        this.containingClass = containingClass;
    }

    public int getFeatureID() {
        return this.featureID;
    }

    public void setFeatureID(int featureID) {
        this.featureID = featureID;
    }

    public int getFeatureIndex() {
        if (this.featureIndex == Integer.MIN_VALUE) {
            this.featureIndex = ((InternalCDOClass)this.containingClass).getFeatureIndex(this.featureID);
        }
        return this.featureIndex;
    }

    public void setFeatureIndex(int featureIndex) {
        this.featureIndex = featureIndex;
    }

    public CDOType getType() {
        return this.type;
    }

    public void setType(CDOType type) {
        this.type = type;
    }

    public boolean isMany() {
        return this.many;
    }

    public void setMany(boolean many) {
        this.many = many;
    }

    public boolean isReference() {
        return this.type == CDOType.OBJECT;
    }

    public boolean isContainment() {
        return this.containment;
    }

    public void setContainment(boolean containment) {
        this.containment = containment;
    }

    public CDOClass getReferenceType() {
        if (this.referenceTypeProxy == null) {
            return null;
        }
        return this.referenceTypeProxy.getCdoClass();
    }

    public void setReferenceType(CDOClassRef cdoClassRef) {
        this.referenceTypeProxy = new CDOClassProxy(cdoClassRef, this.getPackageManager());
    }

    public void setReferenceType(CDOClass cdoClass) {
        this.referenceTypeProxy = new CDOClassProxy(cdoClass);
    }

    public CDOClassProxy getReferenceTypeProxy() {
        return this.referenceTypeProxy;
    }

    public String toString() {
        if (this.type == CDOType.OBJECT) {
            return MessageFormat.format("CDOFeature(ID={0}, name={1}, type={2})", this.featureID, this.getName(), this.referenceTypeProxy);
        }
        return MessageFormat.format("CDOFeature(ID={0}, name={1}, type={2})", this.featureID, this.getName(), this.type);
    }

    protected void onInitialize() {
    }
}

