/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.logical.synchronizationmodel;

import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.logical.IModelResolver;
import org.eclipse.emf.compare.ide.ui.logical.SynchronizationModel;
import org.eclipse.emf.compare.ide.ui.tests.CompareTestCase;
import org.eclipse.emf.compare.ide.ui.tests.workspace.TestProject;
import org.eclipse.emf.compare.ide.utils.StorageTraversal;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class SynchronizationModelDiagnosticTest
extends CompareTestCase {
    private static final String BUNDLE = "org.eclipse.emf.compare.ide.ui.tests";
    private static final String DATA_PATH = "src/org/eclipse/emf/compare/ide/ui/tests/logical/synchronizationmodel/diagnostic/data/";
    private static final String LEFT = "left";
    private static final String RIGHT = "right";
    private static final String ORIGIN = "origin";
    private static final String ROOT_CHILD_DIAGNOSTIC_MESSAGE_KEY = "root";
    private static final String DIAGNOSTIC_MESSAGE_KEY = "diagnosticMesg";

    @Test
    public void testRealExampleSyncModelDiagnosticWithXMIExceptionOutsideLogicalModel() throws IOException, URISyntaxException, CoreException, InterruptedException {
        TestProject testProject = new TestProject("TEST_PROJECT");
        IFile left = this.addModelFile(testProject, "model1.ecore");
        IFile m2 = this.addModelFile(testProject, "model2.ecore");
        IFile right = this.addModelFile(testProject, "model3.ecore");
        this.addModelFile(testProject, "invalidXMI.ecore");
        IModelResolver resolver = EMFCompareIDEUIPlugin.getDefault().getModelResolverRegistry().getBestResolverFor((IStorage)left);
        SynchronizationModel synchronizationModel = resolver.resolveLocalModels((IResource)left, (IResource)right, null, (IProgressMonitor)new NullProgressMonitor());
        Set leftStorages = synchronizationModel.getLeftTraversal().getStorages();
        Assert.assertEquals((long)2L, (long)leftStorages.size());
        Assert.assertTrue((boolean)leftStorages.contains(left));
        Assert.assertTrue((boolean)leftStorages.contains(m2));
        Set rightStorages = synchronizationModel.getRightTraversal().getStorages();
        Assert.assertEquals((long)1L, (long)rightStorages.size());
        Assert.assertTrue((boolean)rightStorages.contains(right));
        Diagnostic diagnostic = synchronizationModel.getDiagnostic();
        Assert.assertEquals((long)0L, (long)synchronizationModel.getDiagnostic().getSeverity());
        Assert.assertEquals((Object)this.getDiagnosticMessage(DIAGNOSTIC_MESSAGE_KEY), (Object)diagnostic.getMessage());
        Assert.assertEquals((long)4L, (long)diagnostic.getChildren().size());
        Diagnostic syncRootDiagnostic = (Diagnostic)diagnostic.getChildren().get(0);
        Assert.assertEquals((long)0L, (long)syncRootDiagnostic.getSeverity());
        this.verifyTraversalDiagnostics(diagnostic);
    }

    @Test
    public void testRealExampleSyncModelDiagnosticWithXMIExceptionInLogicalModel() throws IOException, URISyntaxException, CoreException, InterruptedException {
        TestProject testProject = new TestProject("TEST_PROJECT");
        IFile left = this.addModelFile(testProject, "model1.ecore");
        IFile m2 = this.addModelFile(testProject, "model2.ecore");
        IFile right = this.addModelFile(testProject, "invalidXMI.ecore");
        IModelResolver resolver = EMFCompareIDEUIPlugin.getDefault().getModelResolverRegistry().getBestResolverFor((IStorage)left);
        SynchronizationModel synchronizationModel = resolver.resolveLocalModels((IResource)left, (IResource)right, null, (IProgressMonitor)new NullProgressMonitor());
        Set leftStorages = synchronizationModel.getLeftTraversal().getStorages();
        Assert.assertEquals((long)2L, (long)leftStorages.size());
        Assert.assertTrue((boolean)leftStorages.contains(left));
        Assert.assertTrue((boolean)leftStorages.contains(m2));
        Set rightStorages = synchronizationModel.getRightTraversal().getStorages();
        Assert.assertEquals((long)1L, (long)rightStorages.size());
        Assert.assertTrue((boolean)rightStorages.contains(right));
        Diagnostic diagnostic = synchronizationModel.getDiagnostic();
        Assert.assertEquals((long)4L, (long)synchronizationModel.getDiagnostic().getSeverity());
        Assert.assertEquals((Object)this.getDiagnosticMessage(DIAGNOSTIC_MESSAGE_KEY), (Object)diagnostic.getMessage());
        Assert.assertEquals((long)4L, (long)diagnostic.getChildren().size());
        Diagnostic syncRootDiagnostic = (Diagnostic)diagnostic.getChildren().get(0);
        Assert.assertEquals((long)4L, (long)syncRootDiagnostic.getSeverity());
        this.verifyTraversalDiagnostics(diagnostic);
    }

    @Test
    public void testRealExampleSyncModelDiagnosticWithDanglingReferenceInLogicalModel() throws IOException, URISyntaxException, CoreException, InterruptedException {
        TestProject testProject = new TestProject("TEST_PROJECT");
        IFile m1 = this.addModelFile(testProject, "model1.ecore");
        IFile m3 = this.addModelFile(testProject, "model3.ecore");
        IModelResolver resolver = EMFCompareIDEUIPlugin.getDefault().getModelResolverRegistry().getBestResolverFor((IStorage)m1);
        SynchronizationModel synchronizationModel = resolver.resolveLocalModels((IResource)m1, (IResource)m3, null, (IProgressMonitor)new NullProgressMonitor());
        Set leftStorages = synchronizationModel.getLeftTraversal().getStorages();
        Assert.assertEquals((long)2L, (long)leftStorages.size());
        IStorage[] storages = (IStorage[])Iterators.toArray(leftStorages.iterator(), IStorage.class);
        if (storages[0].equals(m1)) {
            Assert.assertTrue((boolean)storages[1].getFullPath().toString().contains("model2.ecore"));
        } else {
            Assert.assertTrue((boolean)storages[1].equals(m1));
            Assert.assertTrue((boolean)storages[0].getFullPath().toString().contains("model2.ecore"));
        }
        Set rightStorages = synchronizationModel.getRightTraversal().getStorages();
        Assert.assertEquals((long)1L, (long)rightStorages.size());
        Assert.assertTrue((boolean)rightStorages.contains(m3));
        Diagnostic diagnostic = synchronizationModel.getDiagnostic();
        Assert.assertEquals((long)4L, (long)diagnostic.getSeverity());
        Assert.assertEquals((long)1L, (long)diagnostic.getData().size());
        Assert.assertEquals((Object)synchronizationModel, diagnostic.getData().get(0));
        Diagnostic syncRootDiagnostic = (Diagnostic)diagnostic.getChildren().get(0);
        Assert.assertEquals((long)4L, (long)syncRootDiagnostic.getSeverity());
        this.verifyTraversalDiagnostics(diagnostic);
    }

    @Test
    public void testSyncModelDiagnosticWithDanglingReferenceOutsideLogicalModel() throws IOException, URISyntaxException, CoreException, InterruptedException {
        TestProject testProject = new TestProject("TEST_PROJECT");
        IFile m1 = this.addModelFile(testProject, "model1.ecore");
        IFile m2 = this.addModelFile(testProject, "model2.ecore");
        IFile m3 = this.addModelFile(testProject, "model3.ecore");
        this.addModelFile(testProject, "dangling_ref.ecore");
        IModelResolver resolver = EMFCompareIDEUIPlugin.getDefault().getModelResolverRegistry().getBestResolverFor((IStorage)m1);
        SynchronizationModel synchronizationModel = resolver.resolveLocalModels((IResource)m1, (IResource)m3, null, (IProgressMonitor)new NullProgressMonitor());
        SynchronizationModelDiagnosticTest.assertContainsExclusively(synchronizationModel.getLeftTraversal(), m1, m2);
        SynchronizationModelDiagnosticTest.assertContainsExclusively(synchronizationModel.getRightTraversal(), m3);
        Diagnostic diagnostic = synchronizationModel.getDiagnostic();
        Assert.assertEquals((long)0L, (long)diagnostic.getSeverity());
        Diagnostic syncRootDiagnostic = (Diagnostic)diagnostic.getChildren().get(0);
        Assert.assertEquals((long)0L, (long)syncRootDiagnostic.getSeverity());
        this.verifyTraversalDiagnostics(diagnostic);
    }

    @Test
    public void testSynchronizationModelDiagnosticsWithBasicDiagnosticOutsideTraversal() throws IOException, CoreException, URISyntaxException {
        TestProject testProject = new TestProject("TEST_PROJECT");
        IFile m1 = this.addModelFile(testProject, "model1.ecore");
        IFile m2 = this.addModelFile(testProject, "model2.ecore");
        IFile m3 = this.addModelFile(testProject, "model3.ecore");
        StorageTraversal leftTraversal = this.getStorageTraversal(new IStorage[]{m1, m2});
        StorageTraversal rightTraversal = this.getStorageTraversal(new IStorage[]{m1});
        BasicDiagnostic diagnostic = new BasicDiagnostic();
        diagnostic.add((Diagnostic)new BasicDiagnostic(4, BUNDLE, 0, "", new Object[]{m3}));
        SynchronizationModel synchronizationModel = new SynchronizationModel(leftTraversal, rightTraversal, null, (Diagnostic)diagnostic);
        Assert.assertEquals((long)0L, (long)synchronizationModel.getDiagnostic().getSeverity());
        this.verifyTraversalDiagnostics(synchronizationModel.getDiagnostic());
    }

    @Test
    public void testSynchronizationModelDiagnosticsWithResourceStatusOutsideTraversal() throws IOException, CoreException, URISyntaxException {
        TestProject testProject = new TestProject("TEST_PROJECT");
        IFile m1 = this.addModelFile(testProject, "model1.ecore");
        IFile m2 = this.addModelFile(testProject, "model2.ecore");
        StorageTraversal leftTraversal = this.getStorageTraversal(new IStorage[]{m1, m2});
        StorageTraversal rightTraversal = this.getStorageTraversal(new IStorage[]{m1});
        BasicDiagnostic diagnostic = new BasicDiagnostic();
        diagnostic.add((Diagnostic)new BasicDiagnostic(2, BUNDLE, 0, "", new Object[]{new ResourceStatus(0, (IPath)new Path("virtualPath1"), "")}));
        diagnostic.add((Diagnostic)new BasicDiagnostic(2, BUNDLE, 0, "", new Object[]{new ResourceStatus(0, m1.getFullPath().append("virtualPathSegment"), "")}));
        SynchronizationModel synchronizationModel = new SynchronizationModel(leftTraversal, rightTraversal, null, (Diagnostic)diagnostic);
        Assert.assertEquals((long)0L, (long)synchronizationModel.getDiagnostic().getSeverity());
        this.verifyTraversalDiagnostics(synchronizationModel.getDiagnostic());
    }

    @Test
    public void testSynchronizationModelDiagnosticsWithResourceDiagnosticOutsideTraversal() throws IOException, CoreException, URISyntaxException {
        TestProject testProject = new TestProject("TEST_PROJECT");
        IFile m1 = this.addModelFile(testProject, "model1.ecore");
        IFile m2 = this.addModelFile(testProject, "model2.ecore");
        StorageTraversal leftTraversal = this.getStorageTraversal(new IStorage[]{m1, m2});
        StorageTraversal rightTraversal = this.getStorageTraversal(new IStorage[]{m1});
        BasicDiagnostic diagnostic = new BasicDiagnostic();
        diagnostic.add((Diagnostic)new BasicDiagnostic(2, BUNDLE, 0, "", new Object[]{new XMIException("", "virtualLocation", 0, 0)}));
        SynchronizationModel synchronizationModel = new SynchronizationModel(leftTraversal, rightTraversal, null, (Diagnostic)diagnostic);
        Assert.assertEquals((long)0L, (long)synchronizationModel.getDiagnostic().getSeverity());
        this.verifyTraversalDiagnostics(synchronizationModel.getDiagnostic());
    }

    @Test
    public void testSynchronizationModelDiagnosticsWithBasicDiagnosticInTraversal() throws IOException, CoreException, URISyntaxException {
        TestProject testProject = new TestProject("TEST_PROJECT");
        IFile m1 = this.addModelFile(testProject, "model1.ecore");
        IFile m2 = this.addModelFile(testProject, "model2.ecore");
        IFile m3 = this.addModelFile(testProject, "model3.ecore");
        StorageTraversal leftTraversal = this.getStorageTraversal(new IStorage[]{m1, m2});
        StorageTraversal rightTraversal = this.getStorageTraversal(new IStorage[]{m1, m3});
        BasicDiagnostic diagnostic = new BasicDiagnostic();
        diagnostic.add((Diagnostic)new BasicDiagnostic(2, BUNDLE, 0, "", new Object[]{m3}));
        SynchronizationModel synchronizationModel = new SynchronizationModel(leftTraversal, rightTraversal, null, (Diagnostic)diagnostic);
        Assert.assertEquals((long)2L, (long)synchronizationModel.getDiagnostic().getSeverity());
        this.verifyTraversalDiagnostics(synchronizationModel.getDiagnostic());
    }

    @Test
    public void testSynchronizationModelDiagnosticsWithResourceStatusInTraversal() throws IOException, CoreException, URISyntaxException {
        TestProject testProject = new TestProject("TEST_PROJECT");
        IFile m1 = this.addModelFile(testProject, "model1.ecore");
        IFile m2 = this.addModelFile(testProject, "model2.ecore");
        IFile m3 = this.addModelFile(testProject, "model3.ecore");
        StorageTraversal leftTraversal = this.getStorageTraversal(new IStorage[]{m1, m2});
        StorageTraversal rightTraversal = this.getStorageTraversal(new IStorage[]{m1, m3});
        BasicDiagnostic diagnostic = new BasicDiagnostic();
        diagnostic.add((Diagnostic)new BasicDiagnostic(2, BUNDLE, 0, "", new Object[]{new ResourceStatus(0, m3.getFullPath(), "")}));
        SynchronizationModel synchronizationModel = new SynchronizationModel(leftTraversal, rightTraversal, null, (Diagnostic)diagnostic);
        Assert.assertEquals((long)2L, (long)synchronizationModel.getDiagnostic().getSeverity());
        this.verifyTraversalDiagnostics(synchronizationModel.getDiagnostic());
    }

    @Test
    public void testSynchronizationModelDiagnosticsWithResourceDiagnosticInTraversal() throws IOException, CoreException, URISyntaxException {
        TestProject testProject = new TestProject("TEST_PROJECT");
        IFile m1 = this.addModelFile(testProject, "model1.ecore");
        IFile m2 = this.addModelFile(testProject, "model2.ecore");
        IFile m3 = this.addModelFile(testProject, "model3.ecore");
        StorageTraversal leftTraversal = this.getStorageTraversal(new IStorage[]{m1, m2});
        StorageTraversal rightTraversal = this.getStorageTraversal(new IStorage[]{m1, m3});
        BasicDiagnostic diagnostic = new BasicDiagnostic();
        diagnostic.add((Diagnostic)new BasicDiagnostic(4, BUNDLE, 0, "", new Object[]{new XMIException("", m3.getFullPath().toString(), 0, 0)}));
        SynchronizationModel synchronizationModel = new SynchronizationModel(leftTraversal, rightTraversal, null, (Diagnostic)diagnostic);
        Assert.assertEquals((long)4L, (long)synchronizationModel.getDiagnostic().getSeverity());
        this.verifyTraversalDiagnostics(synchronizationModel.getDiagnostic());
    }

    private void verifyTraversalDiagnostics(Diagnostic diagnostic) {
        Diagnostic rootDiagnostic = (Diagnostic)diagnostic.getChildren().get(0);
        Assert.assertEquals((Object)this.getDiagnosticMessage(ROOT_CHILD_DIAGNOSTIC_MESSAGE_KEY), (Object)rootDiagnostic.getMessage());
        Diagnostic leftTraversalDiagnostic = (Diagnostic)diagnostic.getChildren().get(1);
        Assert.assertEquals((Object)this.getDiagnosticMessage(LEFT), (Object)leftTraversalDiagnostic.getMessage());
        Assert.assertEquals((long)0L, (long)leftTraversalDiagnostic.getSeverity());
        Diagnostic originTraversalDiagnostic = (Diagnostic)diagnostic.getChildren().get(2);
        Assert.assertEquals((Object)this.getDiagnosticMessage(ORIGIN), (Object)originTraversalDiagnostic.getMessage());
        Assert.assertEquals((long)0L, (long)originTraversalDiagnostic.getSeverity());
        Diagnostic rightTraversalDiagnostic = (Diagnostic)diagnostic.getChildren().get(3);
        Assert.assertEquals((Object)this.getDiagnosticMessage(RIGHT), (Object)rightTraversalDiagnostic.getMessage());
        Assert.assertEquals((long)0L, (long)rightTraversalDiagnostic.getSeverity());
    }

    private String getDiagnosticMessage(String key) {
        return EMFCompareIDEUIMessages.getString((String)("SynchronizationModel." + key));
    }

    private StorageTraversal getStorageTraversal(IStorage ... storages) {
        HashSet set = Sets.newHashSet();
        Collections.addAll(set, storages);
        return new StorageTraversal((Set)set);
    }

    private IFile addModelFile(TestProject testProject, String filePath) throws IOException, URISyntaxException, CoreException {
        Bundle bundle = Platform.getBundle((String)BUNDLE);
        URL fileURL = FileLocator.toFileURL((URL)bundle.getEntry(DATA_PATH + filePath));
        File dataSource = new File(fileURL.toURI());
        File destination = testProject.getOrCreateFile(testProject.getProject(), filePath);
        SynchronizationModelDiagnosticTest.copyFile(dataSource, destination);
        return testProject.getIFile(testProject.getProject(), destination);
    }
}

