/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.match;

import java.io.IOException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.match.data.MatchInputData;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.junit.Assert;
import org.junit.Test;

public class XMIMatchingTest {
    private MatchInputData input = new MatchInputData();

    @Test
    public void testSetIDAttribute() throws IOException {
        Resource left = this.input.getSetIDAttributeLeft();
        Resource right = this.input.getSetIDAttributeRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList matches = comparison.getMatches();
        Assert.assertEquals((long)1L, (long)matches.size());
        Match rootMatch = (Match)matches.get(0);
        EList subMatches = rootMatch.getSubmatches();
        Assert.assertEquals((long)2L, (long)subMatches.size());
        for (Match match : subMatches) {
            EObject leftObject = match.getLeft();
            EObject rightObject = match.getRight();
            Resource leftResource = leftObject.eResource();
            Resource rightResource = rightObject.eResource();
            String leftID = ((XMIResource)leftResource).getID(leftObject);
            String rightID = ((XMIResource)rightResource).getID(rightObject);
            Assert.assertEquals((Object)leftID, (Object)rightID);
        }
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
    }

    @Test
    public void testXMIIDPriorityA1() throws IOException {
        Resource left = this.input.getXMIIDPriorityA1Left();
        Resource right = this.input.getXMIIDPriorityA1Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList matches = comparison.getMatches();
        Assert.assertEquals((long)1L, (long)matches.size());
        Match rootMatch = (Match)matches.get(0);
        EList subMatches = rootMatch.getSubmatches();
        Assert.assertEquals((long)2L, (long)subMatches.size());
        for (Match match : subMatches) {
            EObject leftObject = match.getLeft();
            EObject rightObject = match.getRight();
            Resource leftResource = leftObject.eResource();
            Resource rightResource = rightObject.eResource();
            String leftID = ((XMIResource)leftResource).getID(leftObject);
            String rightID = ((XMIResource)rightResource).getID(rightObject);
            Assert.assertEquals((Object)leftID, (Object)rightID);
        }
    }

    @Test
    public void testXMIIDPriorityA2() throws IOException {
        Resource left = this.input.getXMIIDPriorityA2Left();
        Resource right = this.input.getXMIIDPriorityA2Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList matches = comparison.getMatches();
        Assert.assertEquals((long)1L, (long)matches.size());
        Match rootMatch = (Match)matches.get(0);
        EList subMatches = rootMatch.getSubmatches();
        Assert.assertEquals((long)4L, (long)subMatches.size());
        for (Match match : subMatches) {
            EObject leftObject = match.getLeft();
            EObject rightObject = match.getRight();
            boolean leftIsNull = leftObject == null && rightObject != null;
            boolean rightIsNull = rightObject == null && leftObject != null;
            Assert.assertTrue((leftIsNull || rightIsNull ? 1 : 0) != 0);
        }
    }
}

