/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.unit;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.graph.IGraph;
import org.eclipse.emf.compare.graph.IGraphView;
import org.eclipse.emf.compare.graph.PruningIterator;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.CrossReferenceResolutionScope;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ThreadedModelResolver;
import org.eclipse.emf.compare.ide.ui.tests.egit.CompareGitTestCase;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;
import org.eclipse.emf.compare.ide.utils.StorageTraversal;
import org.eclipse.emf.compare.internal.utils.Graph;
import org.eclipse.jface.preference.IPreferenceStore;

public class LogicalModelGraphTest
extends CompareGitTestCase {
    protected ResolvingResult resolveTraversalOf(IFile file) throws Exception {
        ThreadedModelResolver resolver = new ThreadedModelResolver();
        resolver.setGraph((IGraph)new Graph());
        resolver.initialize();
        StorageTraversal traversal = resolver.resolveLocalModel((IResource)file, (IProgressMonitor)new NullProgressMonitor());
        Set<Set<URI>> subGraphs = this.getSubGraphs((IGraphView<URI>)resolver.getGraphView());
        return new ResolvingResult(subGraphs, traversal);
    }

    protected void setResolutionScope(CrossReferenceResolutionScope scope) {
        IPreferenceStore store = EMFCompareIDEUIPlugin.getDefault().getPreferenceStore();
        store.setValue("org.eclipse.emf.compare.ide.ui.preference.resolutionScope", scope.name());
    }

    protected Set<Set<URI>> getSubGraphs(IGraphView<URI> graph) {
        PruningIterator iterator = graph.breadthFirstIterator();
        LinkedHashSet<URI> roots = new LinkedHashSet<URI>();
        while (iterator.hasNext()) {
            roots.add((URI)iterator.next());
            iterator.prune();
        }
        LinkedHashSet<Set<URI>> subgraphs = new LinkedHashSet<Set<URI>>();
        HashSet knownURIs = new HashSet();
        for (URI root : roots) {
            if (knownURIs.contains(root)) continue;
            ImmutableSet subgraph = graph.getSubgraphContaining((Object)root);
            knownURIs.addAll(subgraph);
            subgraphs.add((Set<URI>)subgraph);
        }
        return subgraphs;
    }

    protected static URI resourceURI(String path) {
        return URI.createPlatformResourceURI((String)path, (boolean)true);
    }

    protected static Set<URI> uriSet(IStorage ... storages) {
        return ImmutableSet.copyOf((Iterable)Iterables.transform(Arrays.asList(storages), (Function)ResourceUtil.asURI()));
    }

    protected static Set<IStorage> storageSet(IStorage ... storages) {
        return Sets.newLinkedHashSet(Arrays.asList(storages));
    }

    protected static ExpectedResult expectError(Set<? extends Set<URI>> expectedGraph, Set<? extends IStorage> expectedTraversal) {
        return new ExpectedResult(expectedGraph, expectedTraversal, 4);
    }

    protected static ExpectedResult expectOk(Set<? extends Set<URI>> expectedGraph, Set<? extends IStorage> expectedTraversal) {
        return new ExpectedResult(expectedGraph, expectedTraversal, 0);
    }

    public static class ExpectedResult {
        private final Set<? extends Set<URI>> subGraphs;
        private final int diagnosticSeverity;
        private final Set<? extends IStorage> storagesInModel;

        public ExpectedResult(Set<? extends Set<URI>> subGraphs, Set<? extends IStorage> storagesInModel, int diagnosticSeverity) {
            this.subGraphs = subGraphs;
            this.storagesInModel = storagesInModel;
            this.diagnosticSeverity = diagnosticSeverity;
        }

        public Set<? extends Set<URI>> getSubGraphs() {
            return this.subGraphs;
        }

        public int getDiagnosticSeverity() {
            return this.diagnosticSeverity;
        }

        public Set<? extends IStorage> getStoragesInModel() {
            return this.storagesInModel;
        }
    }

    public static class ResolvingResult {
        private final Set<Set<URI>> subGraphs;
        private final StorageTraversal traversal;

        public ResolvingResult(Set<Set<URI>> subGraphs, StorageTraversal traversal) {
            this.subGraphs = subGraphs;
            this.traversal = traversal;
        }

        public Set<Set<URI>> getSubGraphs() {
            return this.subGraphs;
        }

        public StorageTraversal getTraversal() {
            return this.traversal;
        }
    }
}

