/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.utils.tests;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.compare.ide.utils.tests.AbstractStorageTest;
import org.eclipse.emf.compare.ide.utils.tests.helper.FileInputStreamProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class Bug507157Test
extends AbstractStorageTest {
    private static final String PATH = "src/org/eclipse/emf/compare/ide/utils/tests/data/bug507157";
    private File file;
    private IStorage storage;

    @Before
    public void setUp() throws IOException {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.emf.compare.ide.tests");
        URL file1Entry = bundle.getEntry(PATH);
        URL file1URL = FileLocator.resolve((URL)file1Entry);
        String file1Path = file1URL.getPath();
        this.file = new File(file1Path);
        this.storage = Bug507157Test.mockStorage(new FileInputStreamProvider(this.file));
    }

    @Test
    public void testNewInstances() throws CoreException, IOException {
        InputStream firstCall = null;
        InputStream secondCall = null;
        try {
            firstCall = this.storage.getContents();
            secondCall = this.storage.getContents();
            Assert.assertNotSame((Object)firstCall, (Object)secondCall);
        }
        finally {
            if (firstCall != null) {
                firstCall.close();
            }
            if (secondCall != null) {
                secondCall.close();
            }
        }
    }

    @Test
    public void testMultipleRead() throws CoreException, IOException {
        String firstRead = this.read(this.storage.getContents());
        String secondRead = this.read(this.storage.getContents());
        Assert.assertTrue((boolean)firstRead.equals(secondRead));
    }

    private String read(InputStream stream) throws IOException {
        int val;
        String returnStr = "";
        InputStreamReader reader = new InputStreamReader(stream);
        while ((val = reader.read()) != -1) {
            returnStr = String.valueOf(returnStr) + val;
        }
        stream.close();
        return returnStr;
    }
}

