/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.internal.postprocessor;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.compare.uml2.internal.MultiplicityElementChange;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class MultiplicityElementChangePostProcessor
implements IPostProcessor {
    public void postMatch(Comparison comparison, Monitor monitor) {
    }

    public void postDiff(Comparison comparison, Monitor monitor) {
    }

    public void postRequirements(Comparison comparison, Monitor monitor) {
    }

    public void postEquivalences(Comparison comparison, Monitor monitor) {
    }

    public void postConflicts(Comparison comparison, Monitor monitor) {
    }

    public void postComparison(Comparison comparison, Monitor monitor) {
        this.updateRequiresAndRefines(comparison);
        this.verifyConflicts(comparison);
    }

    private void updateRequiresAndRefines(Comparison comparison) {
        UnmodifiableIterator multiplicityChanges = Iterators.filter((Iterator)comparison.getDifferences().iterator(), (Predicate)Predicates.instanceOf(MultiplicityElementChange.class));
        while (multiplicityChanges.hasNext()) {
            MultiplicityElementChange refChange = (MultiplicityElementChange)multiplicityChanges.next();
            for (Diff refiningDiff : refChange.getRefinedBy()) {
                ArrayList<Diff> refinedChangesToUpdate = new ArrayList<Diff>();
                for (Diff refinedDiff : refiningDiff.getRefines()) {
                    if (refinedDiff == refChange) continue;
                    refinedChangesToUpdate.add(refinedDiff);
                }
                for (Diff refined : refinedChangesToUpdate) {
                    refined.getRefinedBy().remove((Object)refiningDiff);
                    refined.getRefinedBy().add((Object)refChange);
                    refined.getRequires().remove((Object)refChange);
                }
            }
        }
    }

    private void verifyConflicts(Comparison comparison) {
        for (Conflict conflict : comparison.getConflicts()) {
            if (!Iterables.all((Iterable)conflict.getDifferences(), (Predicate)EMFComparePredicates.anyRefined((Predicate)Predicates.instanceOf(MultiplicityElementChange.class)))) continue;
            Iterable<Diff> leftDiffs = this.collectRefinedDiffs((List<Diff>)conflict.getLeftDifferences(), (Predicate<Object>)Predicates.instanceOf(MultiplicityElementChange.class));
            for (Diff leftDiff : leftDiffs) {
                MultiplicityElementChange leftMultiplicityChange = (MultiplicityElementChange)leftDiff;
                Match match = leftMultiplicityChange.getMatch();
                Iterable<Diff> rightDiffs = this.collectRefinedDiffs((List<Diff>)conflict.getRightDifferences(), (Predicate<Object>)Predicates.instanceOf(MultiplicityElementChange.class));
                for (Diff rightDiff : rightDiffs) {
                    this.verifyConflict(match, leftMultiplicityChange, (MultiplicityElementChange)rightDiff);
                }
            }
        }
    }

    private Iterable<Diff> collectRefinedDiffs(List<Diff> diffs, Predicate<Object> predicate) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Diff diff : diffs) {
            builder.addAll(Iterables.filter((Iterable)diff.getRefines(), predicate));
        }
        return builder.build();
    }

    private void verifyConflict(Match match, MultiplicityElementChange leftChange, MultiplicityElementChange rightChange) {
        EReference rightReference;
        Optional<ReferenceChange> leftReferenceChange = this.tryGetReferenceChange(leftChange);
        Optional<ReferenceChange> rightReferenceChange = this.tryGetReferenceChange(rightChange);
        if (!leftReferenceChange.isPresent() || !rightReferenceChange.isPresent()) {
            return;
        }
        EReference leftReference = ((ReferenceChange)leftReferenceChange.get()).getReference();
        if (!leftReference.equals(rightReference = ((ReferenceChange)rightReferenceChange.get()).getReference())) {
            return;
        }
        boolean sameValue = this.sameValue((EStructuralFeature)leftReference, match.getLeft(), match.getRight());
        this.updateConflict((Diff)leftReferenceChange.get(), (Diff)rightReferenceChange.get(), sameValue);
    }

    private void updateConflict(Diff diff, Diff diff2, boolean sameValue) {
        if (sameValue && diff.getConflict().getKind() != ConflictKind.PSEUDO) {
            diff.getConflict().setKind(ConflictKind.PSEUDO);
        } else if (!(sameValue || diff.getConflict().getKind() == ConflictKind.REAL && diff2.getConflict().getKind() == ConflictKind.REAL)) {
            Conflict conflict = diff.getConflict();
            conflict.setKind(ConflictKind.REAL);
            diff.setConflict(conflict);
            diff2.setConflict(conflict);
        }
    }

    private Optional<ReferenceChange> tryGetReferenceChange(MultiplicityElementChange change) {
        Iterable refChanges = Iterables.filter((Iterable)change.getRefinedBy(), ReferenceChange.class);
        return Optional.fromNullable((Object)((ReferenceChange)Iterables.getFirst((Iterable)refChanges, null)));
    }

    private boolean sameValue(EStructuralFeature feature, EObject object1, EObject object2) {
        if (object1 == null || object2 == null) {
            return object1 == object2;
        }
        Object value1 = object1.eGet(feature);
        Object value2 = object2.eGet(feature);
        if (value1 == null || value2 == null) {
            return value1 == value2;
        }
        if (value1 instanceof EObject && value2 instanceof EObject) {
            return EcoreUtil.equals((EObject)((EObject)value1), (EObject)((EObject)value2));
        }
        return value1.equals(value2);
    }
}

