/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.compare.INavigatable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.command.ICompareCopyCommand;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.compare.domain.IMergeRunnable;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.MergeRunnableImpl;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.merge.IDiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.provider.ITooltipLabelProvider;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroup;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class MergeAction
extends BaseSelectionListenerAction {
    protected static final Function<? super Adapter, ? extends Notifier> ADAPTER__TARGET = new Function<Adapter, Notifier>(){

        public Notifier apply(Adapter adapter) {
            return adapter.getTarget();
        }
    };
    protected final IMerger.Registry mergerRegistry;
    protected ICompareEditingDomain editingDomain;
    private boolean leftToRight;
    protected IMergeRunnable mergeRunnable;
    private final List<Diff> selectedDifferences;
    private final INavigatable navigatable;
    private final MergeMode selectedMode;
    private AdapterFactory adapterFactory;
    private IDiffRelationshipComputer diffRelationshipComputer;
    private boolean isMirrored;
    private final boolean isLeftEditable;
    private final boolean isRightEditable;

    public MergeAction(IEMFCompareConfiguration compareConfiguration, IMerger.Registry mergerRegistry, MergeMode mode, INavigatable navigatable) {
        super("");
        this.adapterFactory = compareConfiguration.getAdapterFactory();
        this.diffRelationshipComputer = compareConfiguration.getDiffRelationshipComputer();
        this.isLeftEditable = compareConfiguration.isLeftEditable();
        this.isRightEditable = compareConfiguration.isRightEditable();
        this.navigatable = navigatable;
        Preconditions.checkNotNull((Object)mode);
        Preconditions.checkState((this.isLeftEditable || this.isRightEditable ? 1 : 0) != 0);
        if (this.isLeftEditable && this.isRightEditable) {
            Preconditions.checkState((mode == MergeMode.LEFT_TO_RIGHT || mode == MergeMode.RIGHT_TO_LEFT ? 1 : 0) != 0);
        }
        if (this.isLeftEditable != this.isRightEditable) {
            Preconditions.checkState((mode == MergeMode.ACCEPT || mode == MergeMode.REJECT ? 1 : 0) != 0);
        }
        this.editingDomain = compareConfiguration.getEditingDomain();
        this.mergerRegistry = mergerRegistry;
        this.leftToRight = mode.isLeftToRight(this.isLeftEditable, this.isRightEditable);
        this.mergeRunnable = this.createMergeRunnable(mode, this.isLeftEditable, this.isRightEditable, this.diffRelationshipComputer);
        this.selectedDifferences = Lists.newArrayList();
        this.selectedMode = mode;
        this.initToolTipAndImage(mode);
    }

    public MergeAction(IEMFCompareConfiguration compareConfiguration, IMerger.Registry mergerRegistry, MergeMode mode, INavigatable navigatable, IStructuredSelection selection) {
        this(compareConfiguration, mergerRegistry, mode, navigatable);
        this.updateSelection(selection);
    }

    protected IMergeRunnable createMergeRunnable(MergeMode mode, boolean leftEditable, boolean rightEditable, IDiffRelationshipComputer relationshipComputer) {
        return new MergeRunnableImpl(leftEditable, rightEditable, mode, relationshipComputer);
    }

    protected void initToolTipAndImage(MergeMode mode) {
        switch (mode) {
            case LEFT_TO_RIGHT: {
                this.setText(EMFCompareIDEUIMessages.getString("merged.to.right.tooltip"));
                this.setToolTipText(EMFCompareIDEUIMessages.getString("merged.to.right.tooltip"));
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/merge_to_right.gif"));
                break;
            }
            case RIGHT_TO_LEFT: {
                this.setText(EMFCompareIDEUIMessages.getString("merged.to.left.tooltip"));
                this.setToolTipText(EMFCompareIDEUIMessages.getString("merged.to.left.tooltip"));
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/merge_to_left.gif"));
                break;
            }
            case ACCEPT: {
                this.setText(EMFCompareIDEUIMessages.getString("accept.change.tooltip"));
                this.setToolTipText(EMFCompareIDEUIMessages.getString("accept.change.tooltip"));
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/accept_change.gif"));
                break;
            }
            case REJECT: {
                this.setText(EMFCompareIDEUIMessages.getString("reject.change.tooltip"));
                this.setToolTipText(EMFCompareIDEUIMessages.getString("reject.change.tooltip"));
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/reject_change.gif"));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    protected void contextualizeTooltip() {
        if (this.selectedDifferences.size() > 1) {
            this.setMultipleTooltip(this.selectedMode);
        } else if (this.selectedDifferences.isEmpty()) {
            this.initToolTipAndImage(this.selectedMode);
        } else {
            Diff diff = this.selectedDifferences.get(0);
            Adapter adapter = this.adapterFactory.adapt((Notifier)diff, ITooltipLabelProvider.class);
            if (adapter instanceof ITooltipLabelProvider) {
                String tooltip = ((ITooltipLabelProvider)adapter).getTooltip(this.selectedMode);
                this.setToolTipText(tooltip);
            } else {
                this.initToolTipAndImage(this.selectedMode);
            }
        }
    }

    private void setMultipleTooltip(MergeMode mode) {
        switch (mode) {
            case LEFT_TO_RIGHT: {
                this.setToolTipText(EMFCompareIDEUIMessages.getString("merged.multiple.to.right.tooltip"));
                break;
            }
            case RIGHT_TO_LEFT: {
                this.setToolTipText(EMFCompareIDEUIMessages.getString("merged.multiple.to.left.tooltip"));
                break;
            }
            case ACCEPT: {
                this.setToolTipText(EMFCompareIDEUIMessages.getString("accept.multiple.changes.tooltip"));
                break;
            }
            case REJECT: {
                this.setToolTipText(EMFCompareIDEUIMessages.getString("reject.multiple.changes.tooltip"));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public void run() {
        ICompareCopyCommand mergeCommand = this.editingDomain.createCopyCommand(this.selectedDifferences, this.leftToRight, this.mergerRegistry, this.mergeRunnable);
        this.editingDomain.getCommandStack().execute((Command)mergeCommand);
        if (this.navigatable != null) {
            this.navigatable.selectChange(80);
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        Iterables.addAll(this.selectedDifferences, this.getSelectedDifferences(selection));
        if (this.adapterFactory != null) {
            this.contextualizeTooltip();
        }
        return selection.toList().size() == this.selectedDifferences.size();
    }

    protected void clearCache() {
        this.selectedDifferences.clear();
    }

    protected Iterable<Diff> getSelectedDifferences(IStructuredSelection selection) {
        List selectedObjects = selection.toList();
        Iterable selectedAdapters = Iterables.filter((Iterable)selectedObjects, Adapter.class);
        Iterable selectedNotifiers = Iterables.transform((Iterable)selectedAdapters, ADAPTER__TARGET);
        Iterable selectedTreeNode = Iterables.filter((Iterable)selectedNotifiers, TreeNode.class);
        Iterable selectedEObjects = Iterables.transform((Iterable)selectedTreeNode, (Function)IDifferenceGroup.TREE_NODE_DATA);
        return Iterables.filter((Iterable)selectedEObjects, Diff.class);
    }

    public final void setEditingDomain(ICompareEditingDomain editingDomain) {
        this.editingDomain = editingDomain;
        this.clearCache();
        this.setEnabled(editingDomain != null && this.updateSelection(this.getStructuredSelection()));
    }

    public final void setAdapterFactory(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
        if (adapterFactory != null) {
            this.contextualizeTooltip();
        }
    }

    public void setMirrored(boolean mirrored) {
        if (this.selectedMode == MergeMode.ACCEPT || this.selectedMode == MergeMode.REJECT) {
            return;
        }
        if (this.isMirrored != mirrored) {
            this.isMirrored = mirrored;
            if (mirrored) {
                MergeMode mirroredMode = this.selectedMode.inverse();
                this.leftToRight = mirroredMode.isLeftToRight(this.isRightEditable, this.isLeftEditable);
                this.mergeRunnable = this.createMergeRunnable(mirroredMode, this.isRightEditable, this.isLeftEditable, this.diffRelationshipComputer);
            } else {
                this.leftToRight = this.selectedMode.isLeftToRight(this.isLeftEditable, this.isRightEditable);
                this.mergeRunnable = this.createMergeRunnable(this.selectedMode, this.isLeftEditable, this.isRightEditable, this.diffRelationshipComputer);
            }
        }
    }

    protected final boolean isLeftToRight() {
        return this.leftToRight;
    }
}

