/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.merge;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.EMFCompareMessages;
import org.eclipse.emf.compare.merge.AdditiveConflictMerger;
import org.eclipse.emf.compare.merge.AdditiveReferenceChangeMerger;
import org.eclipse.emf.compare.merge.AttributeChangeMerger;
import org.eclipse.emf.compare.merge.ConflictMerger;
import org.eclipse.emf.compare.merge.FeatureMapChangeMerger;
import org.eclipse.emf.compare.merge.IMergeCriterion;
import org.eclipse.emf.compare.merge.IMergeCriterionAware;
import org.eclipse.emf.compare.merge.PseudoConflictMerger;
import org.eclipse.emf.compare.merge.ReferenceChangeMerger;
import org.eclipse.emf.compare.merge.ResourceAttachmentChangeMerger;

public interface IMerger {
    public boolean isMergerFor(Diff var1);

    public int getRanking();

    public void setRanking(int var1);

    public void copyRightToLeft(Diff var1, Monitor var2);

    public void copyLeftToRight(Diff var1, Monitor var2);

    public void setRegistry(Registry var1);

    public Registry getRegistry();

    public static interface Registry {
        public IMerger getHighestRankingMerger(Diff var1);

        public Collection<IMerger> getMergers(Diff var1);

        public IMerger add(IMerger var1);

        public IMerger remove(String var1);

        public void clear();
    }

    public static interface Registry2
    extends Registry {
        public Iterator<IMerger> getMergersByRankDescending(Diff var1, IMergeCriterion var2);
    }

    public static class RegistryImpl
    implements Registry2 {
        private final Map<String, IMerger> map = new ConcurrentHashMap<String, IMerger>();

        public static Registry createStandaloneInstance() {
            RegistryImpl registry = new RegistryImpl();
            int defaultRanking = 10;
            int pseudoConflictRanking = 75;
            int conflictRanking = 100;
            AttributeChangeMerger attributeMerger = new AttributeChangeMerger();
            attributeMerger.setRanking(10);
            ReferenceChangeMerger referenceMerger = new ReferenceChangeMerger();
            referenceMerger.setRanking(10);
            AdditiveReferenceChangeMerger additiveReferenceMerger = new AdditiveReferenceChangeMerger();
            additiveReferenceMerger.setRanking(10);
            FeatureMapChangeMerger featureMapMerger = new FeatureMapChangeMerger();
            featureMapMerger.setRanking(10);
            ResourceAttachmentChangeMerger resourceAttachmentMerger = new ResourceAttachmentChangeMerger();
            resourceAttachmentMerger.setRanking(10);
            PseudoConflictMerger pseudoConflictMerger = new PseudoConflictMerger();
            pseudoConflictMerger.setRanking(75);
            ConflictMerger conflictMerger = new ConflictMerger();
            conflictMerger.setRanking(100);
            AdditiveConflictMerger additiveConflictMerger = new AdditiveConflictMerger();
            additiveConflictMerger.setRanking(100);
            registry.add(attributeMerger);
            registry.add(referenceMerger);
            registry.add(additiveReferenceMerger);
            registry.add(featureMapMerger);
            registry.add(resourceAttachmentMerger);
            registry.add(pseudoConflictMerger);
            registry.add(conflictMerger);
            registry.add(additiveConflictMerger);
            return registry;
        }

        private static Predicate<IMerger> isMergerFor(final Diff target) {
            return new Predicate<IMerger>(){

                public boolean apply(IMerger d) {
                    return d.isMergerFor(target);
                }
            };
        }

        @Override
        public IMerger add(IMerger merger) {
            Preconditions.checkNotNull((Object)merger);
            merger.setRegistry(this);
            return this.map.put(merger.getClass().getName(), merger);
        }

        @Override
        public IMerger remove(String className) {
            IMerger previous = this.map.remove(className);
            if (previous != null) {
                previous.setRegistry(null);
            }
            return previous;
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public IMerger getHighestRankingMerger(Diff target) {
            Iterator<IMerger> mergers = this.getMergersByRankDescending(target, null);
            if (mergers.hasNext()) {
                return mergers.next();
            }
            throw new IllegalStateException(EMFCompareMessages.getString("IMerger.MissingMerger", target.getClass().getSimpleName()));
        }

        @Override
        public Iterator<IMerger> getMergersByRankDescending(Diff diff, final IMergeCriterion criterion) {
            ArrayList<IMerger> mergers = new ArrayList<IMerger>(this.getMergers(diff));
            Collections.sort(mergers, new Comparator<IMerger>(){

                @Override
                public int compare(IMerger o1, IMerger o2) {
                    return o2.getRanking() - o1.getRanking();
                }
            });
            return Iterators.filter(mergers.iterator(), (Predicate)new Predicate<IMerger>(){

                public boolean apply(IMerger input) {
                    if (input instanceof IMergeCriterionAware) {
                        return ((IMergeCriterionAware)((Object)input)).apply(criterion);
                    }
                    return true;
                }
            });
        }

        @Override
        public Collection<IMerger> getMergers(Diff target) {
            Predicate<IMerger> mergerFor = target == null ? Predicates.alwaysTrue() : RegistryImpl.isMergerFor(target);
            Iterable mergers = Iterables.filter(this.map.values(), mergerFor);
            ArrayList ret = Lists.newArrayList((Iterable)mergers);
            return ret;
        }
    }
}

