/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.unit;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.File;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.compare.graph.IGraph;
import org.eclipse.emf.compare.ide.ui.internal.logical.StorageTypedElement;
import org.eclipse.emf.compare.ide.ui.internal.logical.StreamAccessorStorage;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ThreadedModelResolver;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProviderAccessor;
import org.eclipse.emf.compare.ide.ui.logical.SynchronizationModel;
import org.eclipse.emf.compare.ide.ui.tests.unit.AbstractGitLogicalModelTest;
import org.eclipse.emf.compare.ide.utils.StorageTraversal;
import org.eclipse.emf.compare.internal.utils.Graph;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.Assert;
import org.junit.Test;

public class ThreadedModelResolverResolutionTest
extends AbstractGitLogicalModelTest {
    private IProgressMonitor monitor = new NullProgressMonitor();
    private Resource resource3;
    private File file3;
    private IFile iFile3;
    private Resource resource4;
    private File file4;
    private IFile iFile4;

    @Test
    public void testRemoteResolutionWithIncomingLogicalModel() throws Exception {
        this.setupRepositoryWithRemoteIncomingLogicalModel();
        ThreadedModelResolver resolver = new ThreadedModelResolver();
        resolver.setGraph((IGraph)new Graph());
        resolver.initialize();
        IStorageProviderAccessor storageAccessor = this.createRemoteAccessorForComparison("refs/heads/master", "refs/heads/branch", this.iFile3);
        StreamAccessorStorage file3Storage = StreamAccessorStorage.fromTypedElement((ITypedElement)new StorageTypedElement((IStorage)this.iFile3, this.iFile3.getFullPath().toOSString()));
        SynchronizationModel synchronizationModel = resolver.resolveModels(storageAccessor, (IStorage)this.iFile3, (IStorage)file3Storage, null, this.monitor);
        StorageTraversal rightTraversal = synchronizationModel.getRightTraversal();
        StorageTraversal leftTraversal = synchronizationModel.getLeftTraversal();
        Assert.assertTrue((boolean)leftTraversal.getStorages().isEmpty());
        Assert.assertEquals((long)2L, (long)rightTraversal.getStorages().size());
        this.assertContainsFile(rightTraversal, this.iFile3);
        this.assertContainsFile(rightTraversal, this.iFile4);
    }

    private void setupRepositoryWithRemoteIncomingLogicalModel() throws Exception {
        this.resource1.getContents().add((Object)this.createBasicModel("1"));
        this.resource2.getContents().add((Object)this.createBasicModel("2"));
        this.makeCrossReference(this.resource1, this.resource2);
        this.save(new Resource[]{this.resource1, this.resource2});
        this.repository.addAndCommit(this.project, "master-commit-1", this.file1, this.file2);
        this.resource3 = this.createAndConnectResource("file3.ecore");
        this.resource3.getContents().add((Object)this.createBasicModel("3"));
        this.save(new Resource[]{this.resource3});
        this.file3 = this.project.getOrCreateFile(this.iProject, "file3.ecore");
        this.iFile3 = this.project.getIFile(this.iProject, this.file3);
        this.resource4 = this.createAndConnectResource("file4.ecore");
        this.resource4.getContents().add((Object)this.createBasicModel("4"));
        this.save(new Resource[]{this.resource4});
        this.file4 = this.project.getOrCreateFile(this.iProject, "file4.ecore");
        this.iFile4 = this.project.getIFile(this.iProject, this.file4);
        this.makeCrossReference(this.resource3, this.resource4);
        this.save(new Resource[]{this.resource3, this.resource4});
        this.repository.createBranch("refs/heads/master", "refs/heads/branch");
        this.repository.checkoutBranch("refs/heads/branch");
        this.reload(new Resource[]{this.resource1, this.resource2, this.resource3, this.resource4});
        this.repository.addAndCommit(this.project, "branch-commit-1", this.file3, this.file4);
        this.repository.checkoutBranch("refs/heads/master");
        this.reload(new Resource[]{this.resource1, this.resource2});
    }

    private void assertContainsFile(StorageTraversal traversal, IFile iFile) {
        Assert.assertTrue((boolean)Iterables.any((Iterable)traversal.getStorages(), ThreadedModelResolverResolutionTest.containsFile(iFile)));
    }

    private static Predicate<IStorage> containsFile(final IFile iFile) {
        return new Predicate<IStorage>(){

            public boolean apply(IStorage input) {
                return iFile.getName().equals(input.getName());
            }
        };
    }
}

