/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.adapterfactory;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.adapterfactory.context.IContextTester;
import org.eclipse.emf.compare.internal.adapterfactory.RankedAdapterFactoryDescriptor;
import org.eclipse.emf.compare.internal.adapterfactory.RankedAdapterFactoryDescriptorRegistryImpl;
import org.eclipse.emf.compare.provider.IItemStyledLabelProvider;
import org.eclipse.emf.compare.provider.spec.CompareItemProviderAdapterFactorySpec;
import org.eclipse.emf.compare.provider.spec.ComparisonItemProviderSpec;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.junit.Assert;
import org.junit.Test;

public class EMFCompareAdapterFactoryTest {
    @Test
    public void testEMFCompareAdapterFactory() throws IOException {
        ArrayListMultimap registry = ArrayListMultimap.create();
        RankedAdapterFactoryDescriptorRegistryImpl rankedRegistry = new RankedAdapterFactoryDescriptorRegistryImpl(ComposedAdapterFactory.Descriptor.Registry.INSTANCE, (Multimap)registry);
        ArrayList<String> key = new ArrayList<String>();
        key.add("http://www.eclipse.org/emf/compare");
        key.add("org.eclipse.emf.compare.provider.IItemStyledLabelProvider");
        registry.put(key, (Object)new TestEMFCompareAdapterFactoryDescriptor((AdapterFactory)new CompareItemProviderAdapterFactorySpec2(), 10));
        registry.put(key, (Object)new TestEMFCompareAdapterFactoryDescriptor((AdapterFactory)new CompareItemProviderAdapterFactorySpec3(), 20));
        ArrayList<String> keyIItemLabelProvider = new ArrayList<String>();
        keyIItemLabelProvider.add("http://www.eclipse.org/emf/compare");
        keyIItemLabelProvider.add("org.eclipse.emf.edit.provider.IItemLabelProvider");
        registry.put(keyIItemLabelProvider, (Object)new TestEMFCompareAdapterFactoryDescriptor((AdapterFactory)new CompareItemProviderAdapterFactorySpec2(), 30));
        ComposedAdapterFactory fAdapterFactory = new ComposedAdapterFactory((ComposedAdapterFactory.Descriptor.Registry)rankedRegistry);
        Comparison comparison = CompareFactory.eINSTANCE.createComparison();
        Adapter adapter = fAdapterFactory.adapt((Notifier)comparison, IItemStyledLabelProvider.class);
        Assert.assertTrue((boolean)(adapter instanceof ComparisonItemProviderSpec3));
        IStyledString.IComposedStyledString styledText = ((IItemStyledLabelProvider)adapter).getStyledText((Object)comparison);
        Assert.assertEquals((Object)"ComparisonItemProviderSpecRanking20", (Object)styledText.getString());
    }

    public class CompareItemProviderAdapterFactorySpec2
    extends CompareItemProviderAdapterFactorySpec {
        public Adapter createComparisonAdapter() {
            return new ComparisonItemProviderSpec2((AdapterFactory)this);
        }
    }

    public class CompareItemProviderAdapterFactorySpec3
    extends CompareItemProviderAdapterFactorySpec {
        public Adapter createComparisonAdapter() {
            return new ComparisonItemProviderSpec3((AdapterFactory)this);
        }
    }

    public class ComparisonItemProviderSpec2
    extends ComparisonItemProviderSpec {
        public ComparisonItemProviderSpec2(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public IStyledString.IComposedStyledString getStyledText(Object object) {
            return new ComposedStyledString("ComparisonItemProviderSpecRanking10");
        }
    }

    public class ComparisonItemProviderSpec3
    extends ComparisonItemProviderSpec {
        public ComparisonItemProviderSpec3(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public IStyledString.IComposedStyledString getStyledText(Object object) {
            return new ComposedStyledString("ComparisonItemProviderSpecRanking20");
        }
    }

    public class TestEMFCompareAdapterFactoryDescriptor
    implements RankedAdapterFactoryDescriptor {
        AdapterFactory adapterFactory;
        int ranking;

        public TestEMFCompareAdapterFactoryDescriptor(AdapterFactory adapterFactory, int ranking) {
            this.adapterFactory = adapterFactory;
            this.ranking = ranking;
        }

        public AdapterFactory createAdapterFactory() {
            return this.adapterFactory;
        }

        public int getRanking() {
            return this.ranking;
        }

        public IContextTester getContextTester() {
            return null;
        }

        public String getId() {
            return this.adapterFactory.getClass().getName();
        }

        public String getLabel() {
            return "";
        }

        public String getDescription() {
            return null;
        }

        public boolean isOptional() {
            return false;
        }
    }
}

