/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.preferences;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.compare.rcp.internal.tracer.TracingConstant;
import org.eclipse.emf.compare.rcp.ui.EMFCompareRCPUIPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.EMFCompareRCPUIMessages;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.impl.DifferenceFilterManager;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.filters.IDifferenceFilter;
import org.eclipse.jface.databinding.viewers.IViewerObservableSet;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class FiltersPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "org.eclipse.emf.compare.rcp.ui.preferencePage.filters";
    public static final String SYNCHRONIZATION_BEHAVIOR = "org.eclipse.emf.compare.rcp.ui.filters.syncbehavior";
    private static final int INTRO_TEXT_WIDTH_HINT = 400;
    private static final List<String> SYNC_VALUES = ImmutableList.of((Object)"always", (Object)"never", (Object)"prompt");
    private DifferenceFilterManager filterManager = null;
    private InteractiveFilterUIContent defaultFilterInteractiveContent;
    private InteractiveFilterUIContent activateFilterInteractiveContent;
    private Composite enabledFilterTabComposite;
    private Composite activateFilterTabComposite;
    private Combo combo;
    private String synchronizationBehaviorValue;

    public void init(IWorkbench workbench) {
        ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.eclipse.emf.compare.rcp.ui");
        this.setPreferenceStore((IPreferenceStore)store);
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(container);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        this.createSynchronizationBehaviorContent(container);
        this.setComboInput(this.getCurrentSynchronizationBehavior());
        TabFolder tabFolder = new TabFolder(container, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tabFolder);
        this.createDefaultEnabledFilterTab(tabFolder);
        this.createActivateFilterTab(tabFolder);
        return container;
    }

    private void createDefaultEnabledFilterTab(TabFolder tabFolder) {
        this.enabledFilterTabComposite = this.createTabSkeleton(tabFolder, EMFCompareRCPUIMessages.getString("FiltersPreferencePage.select.tab.label"), EMFCompareRCPUIMessages.getString("FiltersPreferencePage.selectIntro.text"));
        if (this.filterManager == null) {
            this.filterManager = EMFCompareRCPUIPlugin.getDefault().getDifferenceFilterManager();
        }
        this.defaultFilterInteractiveContent = new InteractiveFilterUIContent(this.enabledFilterTabComposite, this.filterManager.getAllFilters(), this.filterManager.getCurrentByDefaultFilters(), false);
    }

    private void createActivateFilterTab(TabFolder tabFolder) {
        this.activateFilterTabComposite = this.createTabSkeleton(tabFolder, EMFCompareRCPUIMessages.getString("FiltersPreferencePage.activate.tab.label"), EMFCompareRCPUIMessages.getString("FiltersPreferencePage.activateIntro.text"));
        if (this.filterManager == null) {
            this.filterManager = EMFCompareRCPUIPlugin.getDefault().getDifferenceFilterManager();
        }
        this.activateFilterInteractiveContent = new InteractiveFilterUIContent(this.activateFilterTabComposite, this.filterManager.getAllFilters(), this.filterManager.getCurrentInactiveFilters(), true);
    }

    private Composite createTabSkeleton(TabFolder tabFolder, String tabLabel, String introText) {
        TabItem tbtmMain = new TabItem(tabFolder, 0);
        tbtmMain.setText(tabLabel);
        Composite tabComposite = new Composite((Composite)tabFolder, 0);
        tbtmMain.setControl((Control)tabComposite);
        GridLayout layout = new GridLayout(1, true);
        tabComposite.setLayout((Layout)layout);
        GridData layoutData = new GridData(4, 4, false, false, 1, 1);
        tabComposite.setLayoutData((Object)layoutData);
        Label introductionText = new Label(tabComposite, 64);
        GridDataFactory.fillDefaults().grab(true, false).hint(400, -1).applyTo((Control)introductionText);
        introductionText.setText(introText);
        return tabComposite;
    }

    private void createSynchronizationBehaviorContent(Composite parent) {
        Composite synchronizationComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(synchronizationComposite);
        Label label = new Label(synchronizationComposite, 64);
        label.setText(EMFCompareRCPUIMessages.getString("InteractiveFilterUIContent.sync.behavior.label"));
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.combo = new Combo(synchronizationComposite, 12);
        for (String comboLabel : SYNC_VALUES) {
            this.combo.add(comboLabel);
        }
        this.combo.setLayoutData((Object)new GridData(16384, 0x1000000, false, true));
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FiltersPreferencePage.this.combo.equals(e.getSource())) {
                    FiltersPreferencePage.this.synchronizationBehaviorValue = FiltersPreferencePage.this.combo.getItem(FiltersPreferencePage.this.combo.getSelectionIndex());
                }
            }
        });
    }

    public void setComboInput(String behavior) {
        int index = 0;
        for (String value : SYNC_VALUES) {
            if (value.equals(behavior)) {
                this.combo.select(index);
                this.synchronizationBehaviorValue = behavior;
            }
            ++index;
        }
    }

    public String getCurrentSynchronizationBehavior() {
        String value = this.getPreferenceStore().getString(SYNCHRONIZATION_BEHAVIOR);
        if (value == null || !SYNC_VALUES.contains(value)) {
            value = this.getDefaultSynchronizationBehavior();
        }
        return value;
    }

    public String getDefaultSynchronizationBehavior() {
        return "prompt";
    }

    public void setCurrentSynchronizationBehavior(String newBehavior) {
        if (this.getDefaultSynchronizationBehavior().equals(newBehavior)) {
            this.getPreferenceStore().setToDefault(SYNCHRONIZATION_BEHAVIOR);
        } else {
            this.getPreferenceStore().setValue(SYNCHRONIZATION_BEHAVIOR, newBehavior);
        }
        if (TracingConstant.CONFIGURATION_TRACING_ACTIVATED) {
            StringBuilder builder = new StringBuilder();
            builder.append("Preference ").append(SYNCHRONIZATION_BEHAVIOR).append(":\n");
            String preferenceValue = this.getPreferenceStore().getString(SYNCHRONIZATION_BEHAVIOR);
            builder.append(preferenceValue);
            EMFCompareRCPUIPlugin.getDefault().log(1, builder.toString());
        }
    }

    public boolean performOk() {
        this.filterManager.setCurrentByDefaultFilters(this.defaultFilterInteractiveContent.getCheckedFilter());
        this.filterManager.setCurrentActiveFilters(this.activateFilterInteractiveContent.getCheckedFilter());
        this.setCurrentSynchronizationBehavior(this.synchronizationBehaviorValue);
        return super.performOk();
    }

    protected void performDefaults() {
        if (this.activateFilterTabComposite.isVisible()) {
            this.activateFilterInteractiveContent.checkElements(this.filterManager.getAllFilters());
        }
        if (this.enabledFilterTabComposite.isVisible()) {
            this.defaultFilterInteractiveContent.checkElements(this.filterManager.getInitialByDefaultFilters());
            this.setComboInput(this.getDefaultSynchronizationBehavior());
        }
        super.performDefaults();
    }

    private static class InteractiveFilterUIContent {
        private static final int DESCRIPTION_LABEL_HEIGHT_HINT = 50;
        private static final int DESCRIPTION_LABEL_WIDTH_HINT = 400;
        private final Label descriptionText;
        private CheckboxTableViewer viewer;
        private FilterDataHolder dataHolder = new FilterDataHolder();
        private FilterDataHolder allFilters = new FilterDataHolder();

        private InteractiveFilterUIContent(Composite parent, Collection<? extends IDifferenceFilter> filters, Collection<? extends IDifferenceFilter> defaultCheck, boolean isDeactivateTab) {
            Composite contentComposite = new Composite(parent, 0);
            GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 10, 0).applyTo(contentComposite);
            contentComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            Label introductionText = new Label(contentComposite, 64);
            if (isDeactivateTab) {
                introductionText.setText(EMFCompareRCPUIMessages.getString("FiltersPreferencePage.INTRO_DEACTIVATE_TEXT"));
            } else {
                introductionText.setText(EMFCompareRCPUIMessages.getString("FiltersPreferencePage.INTRO_SELECT_TEXT"));
            }
            introductionText.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
            Composite viewerComposite = new Composite(contentComposite, 0);
            GridLayoutFactory.fillDefaults().applyTo(viewerComposite);
            viewerComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            this.viewer = this.createViewer(viewerComposite);
            this.descriptionText = this.createDescriptionComposite(contentComposite);
            this.setViewerInput(Lists.newArrayList(filters));
            if (isDeactivateTab) {
                Sets.SetView activatedFilters = Sets.difference((Set)Sets.newLinkedHashSet(filters), (Set)Sets.newLinkedHashSet(defaultCheck));
                this.bindAndInit((Set<IDifferenceFilter>)activatedFilters);
            } else {
                this.bindAndInit(Sets.newLinkedHashSet(defaultCheck));
            }
            this.allFilters.setFilters(Sets.newLinkedHashSet(filters));
        }

        public Set<IDifferenceFilter> getCheckedFilter() {
            return this.dataHolder.getFilters();
        }

        private void setViewerInput(List<IDifferenceFilter> filters) {
            Collections.sort(filters, new Comparator<IDifferenceFilter>(){

                @Override
                public int compare(IDifferenceFilter o1, IDifferenceFilter o2) {
                    if (o1 == o2) {
                        return 0;
                    }
                    if (o1 == null || o1.getLabel() == null) {
                        return -1;
                    }
                    if (o2 == null || o2.getLabel() == null) {
                        return 1;
                    }
                    return o1.getLabel().compareTo(o2.getLabel());
                }
            });
            this.viewer.setInput(filters);
            this.select(filters.iterator().next());
        }

        private CheckboxTableViewer createViewer(Composite viewerCompsite) {
            CheckboxTableViewer descriptorViewer = CheckboxTableViewer.newCheckList((Composite)viewerCompsite, (int)68096);
            descriptorViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            descriptorViewer.setLabelProvider((IBaseLabelProvider)new FilterLabelProvider());
            GridData gd = new GridData(4, 4, true, true, 1, 1);
            descriptorViewer.getControl().setLayoutData((Object)gd);
            this.setViewer(descriptorViewer);
            return descriptorViewer;
        }

        private void bindAndInit(Set<IDifferenceFilter> defaultCheck) {
            if (this.dataHolder != null) {
                if (defaultCheck != null) {
                    this.dataHolder.setFilters(defaultCheck);
                }
                this.bindMultipleData(this.viewer, this.dataHolder);
            }
        }

        private void bindMultipleData(CheckboxTableViewer descriptorViewer, FilterDataHolder dataObject) {
            DataBindingContext ctx = new DataBindingContext();
            IViewerObservableSet target = ViewersObservables.observeCheckedElements((CheckboxTableViewer)descriptorViewer, IDifferenceFilter.class);
            IObservableSet model = PojoProperties.set(FilterDataHolder.class, (String)"filters").observe((Object)dataObject);
            ctx.bindSet((IObservableSet)target, model);
        }

        public void checkElements(Set<IDifferenceFilter> checkedFilter) {
            this.viewer.setCheckedElements(checkedFilter.toArray());
            this.dataHolder.setFilters(checkedFilter);
        }

        private Label createDescriptionComposite(Composite composite) {
            Group descriptionComposite = new Group(composite, 0);
            descriptionComposite.setText(EMFCompareRCPUIMessages.getString("InteractiveUIContent.descriptionComposite.label"));
            GridLayoutFactory.swtDefaults().applyTo((Composite)descriptionComposite);
            descriptionComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            Label engineDescriptionLabel = new Label((Composite)descriptionComposite, 64);
            GridDataFactory.fillDefaults().grab(true, false).hint(400, 50).applyTo((Control)engineDescriptionLabel);
            return engineDescriptionLabel;
        }

        public void select(IDifferenceFilter descriptor) {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)descriptor), true);
            String description = descriptor.getDescription();
            if (description != null) {
                this.descriptionText.setText(description);
            } else {
                this.descriptionText.setText("");
            }
        }

        public void setViewer(CheckboxTableViewer inputViewer) {
            this.viewer = inputViewer;
            this.viewer.addSelectionChangedListener((ISelectionChangedListener)new DescriptionListener());
        }

        private final class DescriptionListener
        implements ISelectionChangedListener {
            private DescriptionListener() {
            }

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection structSelection;
                Object selected;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (selected = (structSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IDifferenceFilter) {
                    IDifferenceFilter desc = (IDifferenceFilter)selected;
                    String description = desc.getDescription();
                    if (description != null) {
                        InteractiveFilterUIContent.this.descriptionText.setText(description);
                    } else {
                        InteractiveFilterUIContent.this.descriptionText.setText("");
                    }
                }
            }
        }

        private static final class FilterDataHolder {
            private static final String FIELD_NAME = "filters";
            private Set<IDifferenceFilter> filters;

            private FilterDataHolder() {
            }

            public Set<IDifferenceFilter> getFilters() {
                return this.filters;
            }

            public void setFilters(Set<IDifferenceFilter> filters) {
                this.filters = filters;
            }
        }

        private static final class FilterLabelProvider
        extends LabelProvider {
            private FilterLabelProvider() {
            }

            public String getText(Object element) {
                if (element instanceof IDifferenceFilter) {
                    return ((IDifferenceFilter)element).getLabel();
                }
                return super.getText(element);
            }
        }
    }
}

