/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.conflict;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.internal.conflict.AbstractConflictSearch;
import org.eclipse.emf.compare.internal.conflict.ComparisonIndex;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;

public class AttributeChangeConflictSearch {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Add
    extends AbstractConflictSearch<AttributeChange> {
        public Add(AttributeChange diff, ComparisonIndex index, Monitor monitor) {
            super(diff, index, monitor);
        }

        @Override
        public void detectConflicts() {
            EAttribute feature = ((AttributeChange)this.diff).getAttribute();
            if (feature.isUnique()) {
                Object value = ((AttributeChange)this.diff).getValue();
                EList<Diff> diffsInSameMatch = ((AttributeChange)this.diff).getMatch().getDifferences();
                for (Diff candidate : Iterables.filter(diffsInSameMatch, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.possiblyConflictingWith(this.diff), Predicates.instanceOf(AttributeChange.class), EMFComparePredicates.onFeature((EStructuralFeature)feature), EMFComparePredicates.ofKind(DifferenceKind.ADD)}))) {
                    Object candidateValue = ((AttributeChange)candidate).getValue();
                    if (!this.comparison.getEqualityHelper().matchingValues(value, candidateValue)) continue;
                    if (MatchUtil.matchingIndices(((AttributeChange)this.diff).getMatch(), (EStructuralFeature)feature, value, candidateValue)) {
                        this.conflict(candidate, ConflictKind.PSEUDO);
                        continue;
                    }
                    this.conflict(candidate, ConflictKind.REAL);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Change
    extends AbstractConflictSearch<AttributeChange> {
        public Change(AttributeChange diff, ComparisonIndex index, Monitor monitor) {
            super(diff, index, monitor);
        }

        @Override
        public void detectConflicts() {
            Object value = ((AttributeChange)this.diff).getValue();
            EAttribute feature = ((AttributeChange)this.diff).getAttribute();
            EList<Diff> diffsInSameMatch = ((AttributeChange)this.diff).getMatch().getDifferences();
            for (Diff candidate : Iterables.filter(diffsInSameMatch, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.possiblyConflictingWith(this.diff), Predicates.instanceOf(AttributeChange.class), EMFComparePredicates.onFeature((EStructuralFeature)feature), EMFComparePredicates.ofKind(DifferenceKind.CHANGE)}))) {
                Object candidateValue = ((AttributeChange)candidate).getValue();
                if (this.comparison.getEqualityHelper().matchingValues(value, candidateValue)) {
                    this.conflict(candidate, ConflictKind.PSEUDO);
                    continue;
                }
                if (this.isFeatureMapChangeOrMergeableStringAttributeChange(this.diff, candidate)) continue;
                this.conflict(candidate, ConflictKind.REAL);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Delete
    extends AbstractConflictSearch<AttributeChange> {
        public Delete(AttributeChange diff, ComparisonIndex index, Monitor monitor) {
            super(diff, index, monitor);
        }

        @Override
        public void detectConflicts() {
            Object value = ((AttributeChange)this.diff).getValue();
            EAttribute feature = ((AttributeChange)this.diff).getAttribute();
            EList<Diff> diffsInSameMatch = ((AttributeChange)this.diff).getMatch().getDifferences();
            for (Diff candidate : Iterables.filter(diffsInSameMatch, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.possiblyConflictingWith(this.diff), Predicates.instanceOf(AttributeChange.class), EMFComparePredicates.onFeature((EStructuralFeature)feature), EMFComparePredicates.ofKind(DifferenceKind.MOVE, DifferenceKind.DELETE)}))) {
                Object candidateValue = ((AttributeChange)candidate).getValue();
                if (!this.comparison.getEqualityHelper().matchingValues(value, candidateValue)) continue;
                if (candidate.getKind() == DifferenceKind.MOVE) {
                    this.conflict(candidate, ConflictKind.REAL);
                    continue;
                }
                if (((AttributeChange)this.diff).getMatch() != candidate.getMatch()) continue;
                this.conflict(candidate, ConflictKind.PSEUDO);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Move
    extends AbstractConflictSearch<AttributeChange> {
        public Move(AttributeChange diff, ComparisonIndex index, Monitor monitor) {
            super(diff, index, monitor);
        }

        @Override
        public void detectConflicts() {
            Object value = ((AttributeChange)this.diff).getValue();
            EAttribute feature = ((AttributeChange)this.diff).getAttribute();
            EList<Diff> diffsInSameMatch = ((AttributeChange)this.diff).getMatch().getDifferences();
            for (Diff candidate : Iterables.filter(diffsInSameMatch, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.possiblyConflictingWith(this.diff), Predicates.instanceOf(AttributeChange.class), EMFComparePredicates.onFeature((EStructuralFeature)feature), EMFComparePredicates.ofKind(DifferenceKind.MOVE)}))) {
                Object candidateValue = ((AttributeChange)candidate).getValue();
                if (MatchUtil.matchingIndices(((AttributeChange)this.diff).getMatch(), (EStructuralFeature)feature, value, candidateValue)) {
                    this.conflict(candidate, ConflictKind.PSEUDO);
                    continue;
                }
                this.conflict(candidate, ConflictKind.REAL);
            }
        }
    }
}

