/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.merge;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.EMFCompareMessages;
import org.eclipse.emf.compare.merge.AttributeChangeMerger;
import org.eclipse.emf.compare.merge.ConflictMerger;
import org.eclipse.emf.compare.merge.FeatureMapChangeMerger;
import org.eclipse.emf.compare.merge.PseudoConflictMerger;
import org.eclipse.emf.compare.merge.ReferenceChangeMerger;
import org.eclipse.emf.compare.merge.ResourceAttachmentChangeMerger;

public interface IMerger {
    public boolean isMergerFor(Diff var1);

    public int getRanking();

    public void setRanking(int var1);

    public void copyRightToLeft(Diff var1, Monitor var2);

    public void copyLeftToRight(Diff var1, Monitor var2);

    public void setRegistry(Registry var1);

    public Registry getRegistry();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Registry {
        public IMerger getHighestRankingMerger(Diff var1);

        public Collection<IMerger> getMergers(Diff var1);

        public IMerger add(IMerger var1);

        public IMerger remove(String var1);

        public void clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RegistryImpl
    implements Registry {
        private final Map<String, IMerger> map = new ConcurrentHashMap<String, IMerger>();

        public static Registry createStandaloneInstance() {
            RegistryImpl registry = new RegistryImpl();
            AttributeChangeMerger attributeMerger = new AttributeChangeMerger();
            attributeMerger.setRanking(10);
            ReferenceChangeMerger referenceMerger = new ReferenceChangeMerger();
            referenceMerger.setRanking(10);
            FeatureMapChangeMerger featureMapMerger = new FeatureMapChangeMerger();
            featureMapMerger.setRanking(10);
            ResourceAttachmentChangeMerger resourceAttachmentMerger = new ResourceAttachmentChangeMerger();
            resourceAttachmentMerger.setRanking(10);
            PseudoConflictMerger pseudoConflictMerger = new PseudoConflictMerger();
            pseudoConflictMerger.setRanking(75);
            ConflictMerger conflictMerger = new ConflictMerger();
            conflictMerger.setRanking(100);
            registry.add(attributeMerger);
            registry.add(referenceMerger);
            registry.add(featureMapMerger);
            registry.add(resourceAttachmentMerger);
            registry.add(pseudoConflictMerger);
            registry.add(conflictMerger);
            return registry;
        }

        private static Predicate<IMerger> isMergerFor(final Diff target) {
            return new Predicate<IMerger>(){

                public boolean apply(IMerger d) {
                    return d.isMergerFor(target);
                }
            };
        }

        @Override
        public IMerger add(IMerger merger) {
            Preconditions.checkNotNull((Object)merger);
            merger.setRegistry(this);
            return this.map.put(merger.getClass().getName(), merger);
        }

        @Override
        public IMerger remove(String className) {
            IMerger previous = this.map.remove(className);
            if (previous != null) {
                previous.setRegistry(null);
            }
            return previous;
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public IMerger getHighestRankingMerger(Diff target) {
            Iterator<IMerger> mergers = this.getMergers(target).iterator();
            IMerger ret = null;
            if (mergers.hasNext()) {
                IMerger highestRanking = mergers.next();
                while (mergers.hasNext()) {
                    IMerger merger = mergers.next();
                    if (merger.getRanking() <= highestRanking.getRanking()) continue;
                    highestRanking = merger;
                }
                ret = highestRanking;
            }
            if (ret == null) {
                throw new IllegalStateException(EMFCompareMessages.getString("IMerger.MissingMerger", target.getClass().getSimpleName()));
            }
            return ret;
        }

        @Override
        public Collection<IMerger> getMergers(Diff target) {
            Predicate<IMerger> mergerFor = target == null ? Predicates.alwaysTrue() : RegistryImpl.isMergerFor(target);
            Iterable mergers = Iterables.filter(this.map.values(), mergerFor);
            ArrayList ret = Lists.newArrayList();
            for (IMerger merger : mergers) {
                ret.add(merger);
            }
            return ret;
        }
    }
}

