/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.internal.provider.custom;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.provider.ExtendedAdapterFactoryItemDelegator;
import org.eclipse.emf.compare.provider.IItemDescriptionProvider;
import org.eclipse.emf.compare.provider.IItemStyledLabelProvider;
import org.eclipse.emf.compare.provider.spec.Strings;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.compare.uml2.internal.UMLDiff;
import org.eclipse.emf.compare.uml2.internal.provider.UMLDiffItemProvider;
import org.eclipse.emf.ecore.EObject;

public class UMLDiffCustomItemProvider
extends UMLDiffItemProvider
implements IItemStyledLabelProvider,
IItemDescriptionProvider {
    private static final int MAX_LENGTH = 50;
    private final ExtendedAdapterFactoryItemDelegator itemDelegator = new ExtendedAdapterFactoryItemDelegator(this.getRootAdapterFactory());

    public UMLDiffCustomItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public String getDescription(Object object) {
        return this.itemDelegator.getDescription(object);
    }

    public IStyledString.IComposedStyledString getStyledText(Object object) {
        UMLDiff umlDiff = (UMLDiff)object;
        String valueText = this.getValueText(umlDiff);
        String referenceText = UMLDiffCustomItemProvider.getReferenceText(umlDiff);
        ComposedStyledString ret = new ComposedStyledString(valueText);
        ret.append(" [" + referenceText, IStyledString.Style.DECORATIONS_STYLER);
        switch (umlDiff.getKind()) {
            case ADD: {
                ret.append(" add", IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            case DELETE: {
                ret.append(" delete", IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            case CHANGE: {
                ret.append(" change", IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            case MOVE: {
                ret.append(" move", IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported " + DifferenceKind.class.getSimpleName() + " value: " + umlDiff.getKind());
            }
        }
        ret.append("]", IStyledString.Style.DECORATIONS_STYLER);
        return ret;
    }

    private String getValueText(UMLDiff umlDiff) {
        String value = this.itemDelegator.getText((Object)umlDiff.getDiscriminant());
        value = value == null ? "<null>" : Strings.elide((String)value, (int)50, (String)"...");
        return value;
    }

    private static String getReferenceText(UMLDiff umlDiff) {
        String ret = "";
        switch (umlDiff.getKind()) {
            case ADD: 
            case DELETE: 
            case MOVE: {
                EObject discriminant = umlDiff.getDiscriminant();
                ret = discriminant.eContainingFeature().getName();
                break;
            }
            case CHANGE: {
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported " + DifferenceKind.class.getSimpleName() + " value: " + umlDiff.getKind());
            }
        }
        return ret;
    }

    protected ExtendedAdapterFactoryItemDelegator getItemDelegator() {
        return this.itemDelegator;
    }
}

