/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.resolver;

import com.google.common.util.concurrent.FutureCallback;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.DiagnosticSupport;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ResolutionUtil;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ResourceComputationScheduler;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ResourceUnloader;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.SynchronizedResourceSet;
import org.eclipse.emf.compare.ide.ui.internal.util.ThreadSafeProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractResourceResolver
implements Runnable {
    protected final ResourceComputationScheduler<URI> scheduler;
    protected final SynchronizedResourceSet resourceSet;
    protected final URI uri;
    protected final ThreadSafeProgressMonitor tspm;
    protected final DiagnosticSupport diagnostic;

    public AbstractResourceResolver(ResourceComputationScheduler<URI> scheduler, DiagnosticSupport diagnostic, SynchronizedResourceSet resourceSet, URI uri, ThreadSafeProgressMonitor monitor) {
        this.scheduler = scheduler;
        this.diagnostic = diagnostic;
        this.resourceSet = resourceSet;
        this.uri = uri;
        this.tspm = monitor;
    }

    protected void demandUnload(Resource resource) {
        this.tspm.setWorkRemaining(1000);
        this.scheduler.scheduleUnload(new ResourceUnloader(this.resourceSet, resource, (IProgressMonitor)this.tspm), new FutureCallback<Object>(){

            public void onSuccess(Object result) {
                if (!ResolutionUtil.isInterruptedOrCanceled((IProgressMonitor)AbstractResourceResolver.this.tspm)) {
                    AbstractResourceResolver.this.tspm.worked(1);
                }
            }

            public void onFailure(Throwable t) {
                if (!ResolutionUtil.isInterruptedOrCanceled((IProgressMonitor)AbstractResourceResolver.this.tspm)) {
                    AbstractResourceResolver.this.tspm.worked(1);
                    AbstractResourceResolver.this.diagnostic.merge(BasicDiagnostic.toDiagnostic((Throwable)t));
                }
            }
        });
    }
}

