/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.provider.spec;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.ResourceLocationChange;
import org.eclipse.emf.compare.internal.EMFCompareEditMessages;
import org.eclipse.emf.compare.provider.IItemDescriptionProvider;
import org.eclipse.emf.compare.provider.IItemStyledLabelProvider;
import org.eclipse.emf.compare.provider.ResourceLocationChangeItemProvider;
import org.eclipse.emf.compare.provider.spec.OverlayImageProvider;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;

public class ResourceLocationChangeItemProviderSpec
extends ResourceLocationChangeItemProvider
implements IItemStyledLabelProvider,
IItemDescriptionProvider {
    private static final String UNSUPPORTED = "Unsupported ";
    private final OverlayImageProvider overlayProvider;
    private final AdapterFactoryItemDelegator itemDelegator = new AdapterFactoryItemDelegator(this.getRootAdapterFactory());

    public ResourceLocationChangeItemProviderSpec(AdapterFactory adapterFactory) {
        super(adapterFactory);
        this.overlayProvider = new OverlayImageProvider(this.getResourceLocator());
    }

    public Object getImage(Object object) {
        EObject container = ((ResourceLocationChange)object).eContainer();
        Object ret = this.itemDelegator.getImage((Object)container);
        if (ret == null) {
            ret = super.getImage(object);
        }
        Object matchImage = this.overlayProvider.getComposedImage((Diff)((ResourceLocationChange)object), ret);
        ret = this.overlayImage(object, matchImage);
        return ret;
    }

    public String getText(Object object) {
        return this.getStyledText(object).getString();
    }

    public IStyledString.IComposedStyledString getStyledText(Object object) {
        ResourceLocationChange resourceLocationChange = (ResourceLocationChange)object;
        String baseLocation = resourceLocationChange.getBaseLocation();
        String changedLocation = resourceLocationChange.getChangedLocation();
        ComposedStyledString ret = new ComposedStyledString(baseLocation);
        ret.append(" [", IStyledString.Style.DECORATIONS_STYLER);
        switch (resourceLocationChange.getKind()) {
            case CHANGE: {
                ret.append(EMFCompareEditMessages.getString("ResourceNameChangeItemProviderSpec.text.locationChanged", changedLocation), IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
        }
        return ret.append("]", IStyledString.Style.DECORATIONS_STYLER);
    }

    public String getDescription(Object object) {
        String ret;
        ResourceLocationChange resourceLocationChange = (ResourceLocationChange)object;
        String baseLocation = resourceLocationChange.getBaseLocation();
        String changedLocation = resourceLocationChange.getChangedLocation();
        String hasBeenAndSide = EMFCompareEditMessages.getString("change.local");
        if (resourceLocationChange.getSource() == DifferenceSource.RIGHT) {
            hasBeenAndSide = EMFCompareEditMessages.getString("change.remote");
        }
        DifferenceKind labelValue = resourceLocationChange.getKind();
        switch (labelValue) {
            case CHANGE: {
                ret = EMFCompareEditMessages.getString("ResourceNameChangeItemProviderSpec.description.locationChanged", baseLocation, hasBeenAndSide, changedLocation);
                break;
            }
            default: {
                throw new IllegalStateException(UNSUPPORTED + DifferenceKind.class.getSimpleName() + " value: " + resourceLocationChange.getKind());
            }
        }
        return ret;
    }
}

