/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.merge;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.merge.IBatchMerger;
import org.eclipse.emf.compare.merge.IMerger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchMerger
implements IBatchMerger {
    private final IMerger.Registry registry;
    private final Predicate<? super Diff> filter;

    public BatchMerger(IMerger.Registry registry) {
        this(registry, (Predicate<? super Diff>)Predicates.alwaysTrue());
    }

    public BatchMerger(IMerger.Registry registry, Predicate<? super Diff> filter) {
        this.registry = (IMerger.Registry)Preconditions.checkNotNull((Object)registry);
        this.filter = (Predicate)Preconditions.checkNotNull(filter);
    }

    @Override
    public void copyAllLeftToRight(Iterable<? extends Diff> differences, Monitor monitor) {
        if (this.filter == Predicates.alwaysTrue()) {
            for (Diff diff : differences) {
                if (diff.getState() == DifferenceState.MERGED) continue;
                IMerger merger = this.registry.getHighestRankingMerger(diff);
                merger.copyLeftToRight(diff, monitor);
            }
        } else {
            for (Diff diff : Iterables.filter(differences, this.filter)) {
                if (diff.getState() == DifferenceState.MERGED) continue;
                IMerger merger = this.registry.getHighestRankingMerger(diff);
                merger.copyLeftToRight(diff, monitor);
            }
        }
    }

    @Override
    public void copyAllRightToLeft(Iterable<? extends Diff> differences, Monitor monitor) {
        if (this.filter == Predicates.alwaysTrue()) {
            for (Diff diff : differences) {
                if (diff.getState() == DifferenceState.MERGED) continue;
                IMerger merger = this.registry.getHighestRankingMerger(diff);
                merger.copyRightToLeft(diff, monitor);
            }
        } else {
            for (Diff diff : Iterables.filter(differences, this.filter)) {
                if (diff.getState() == DifferenceState.MERGED) continue;
                IMerger merger = this.registry.getHighestRankingMerger(diff);
                merger.copyRightToLeft(diff, monitor);
            }
        }
    }
}

