/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.RemoteResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.logical.ComparisonScopeBuilder;
import org.eclipse.emf.compare.ide.ui.internal.logical.EMFResourceMapping;
import org.eclipse.emf.compare.ide.ui.internal.logical.IdenticalResourceMinimizer;
import org.eclipse.emf.compare.ide.ui.internal.logical.RemoteMappingContextStorageAccessor;
import org.eclipse.emf.compare.ide.ui.internal.logical.StorageTypedElement;
import org.eclipse.emf.compare.ide.ui.logical.IModelResolver;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProvider;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProviderAccessor;
import org.eclipse.emf.compare.ide.ui.logical.SynchronizationModel;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;
import org.eclipse.emf.compare.ide.utils.StorageTraversal;

public class EMFModelProvider
extends ModelProvider {
    public static final String PROVIDER_ID = "org.eclipse.emf.compare.model.provider";
    public static final long CACHE_EXPIRATION = 120L;
    private static final Logger LOGGER = Logger.getLogger(EMFModelProvider.class);
    private final LoadingCache<ResourceMappingContext, Cache<IResource, SynchronizationModel>> contextToResourceMappingCache = CacheBuilder.newBuilder().initialCapacity(10).build((CacheLoader)new CacheLoader<ResourceMappingContext, Cache<IResource, SynchronizationModel>>(){

        public Cache<IResource, SynchronizationModel> load(ResourceMappingContext key) throws Exception {
            return CacheBuilder.newBuilder().expireAfterAccess(120L, TimeUnit.SECONDS).initialCapacity(10).build();
        }
    });

    public ResourceMapping[] getMappings(IResource resource, ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("getMappings() - START for " + resource));
        }
        if (resource instanceof IFile) {
            try {
                SynchronizationModel syncModel = this.getOrComputeLogicalModel((IFile)resource, context, monitor);
                if (syncModel != null) {
                    EMFResourceMapping mapping = new EMFResourceMapping(resource, context, syncModel, PROVIDER_ID);
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info((Object)"getMappings() - FINISH NORMALLY");
                    }
                    return new ResourceMapping[]{mapping};
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"getMappings() - fallback to super.");
        }
        return super.getMappings(resource, context, monitor);
    }

    public void clear() {
        this.contextToResourceMappingCache.invalidateAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SynchronizationModel getOrComputeLogicalModel(IFile file, ResourceMappingContext context, IProgressMonitor monitor) throws CoreException, InterruptedException {
        SynchronizationModel syncModel;
        LoadingCache<ResourceMappingContext, Cache<IResource, SynchronizationModel>> loadingCache = this.contextToResourceMappingCache;
        synchronized (loadingCache) {
            Cache resourceMappingCache = (Cache)this.contextToResourceMappingCache.getUnchecked((Object)context);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Retrieved cache with ~ " + resourceMappingCache.size() + " entries  for context " + context));
            }
            if ((syncModel = (SynchronizationModel)resourceMappingCache.getIfPresent((Object)file)) == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Cache MISSED for " + file));
                }
                if ((syncModel = this.computeLogicalModel(file, context, monitor)) != null) {
                    for (IResource res : syncModel.getResources()) {
                        resourceMappingCache.put((Object)res, (Object)syncModel);
                    }
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Cache FOUND entry for " + file));
            }
        }
        return syncModel;
    }

    private SynchronizationModel computeLogicalModel(IFile file, ResourceMappingContext context, IProgressMonitor monitor) throws CoreException, InterruptedException {
        SynchronizationModel syncModel;
        IProgressMonitor actualMonitor;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"computeLogicalModel() - START");
        }
        if ((actualMonitor = monitor) == null) {
            actualMonitor = new NullProgressMonitor();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"computeLogicalModel() - resolving local model");
        }
        IModelResolver resolver = EMFCompareIDEUIPlugin.getDefault().getModelResolverRegistry().getBestResolverFor((IStorage)file);
        StorageTraversal localTraversal = resolver.resolveLocalModel((IResource)file, actualMonitor);
        if (context instanceof RemoteResourceMappingContext) {
            RemoteMappingContextStorageAccessor accessor = new RemoteMappingContextStorageAccessor((RemoteResourceMappingContext)context);
            ITypedElement left = null;
            ITypedElement right = null;
            ITypedElement origin = null;
            if (((RemoteResourceMappingContext)context).isThreeWay()) {
                left = this.findTypedElement(localTraversal, accessor, actualMonitor, IStorageProviderAccessor.DiffSide.SOURCE);
                right = this.findTypedElement(localTraversal, accessor, actualMonitor, IStorageProviderAccessor.DiffSide.REMOTE);
                origin = this.findTypedElement(localTraversal, accessor, actualMonitor, IStorageProviderAccessor.DiffSide.ORIGIN);
            } else {
                left = this.findTypedElement(localTraversal, accessor, actualMonitor, IStorageProviderAccessor.DiffSide.SOURCE);
                right = this.findTypedElement(localTraversal, accessor, actualMonitor, IStorageProviderAccessor.DiffSide.REMOTE);
            }
            IStorage leftStorage = null;
            if (left instanceof IAdaptable) {
                leftStorage = (IStorage)((IAdaptable)left).getAdapter(IStorage.class);
            }
            if (left == null || right == null) {
                return null;
            }
            IModelResolver remoteResolver = EMFCompareIDEUIPlugin.getDefault().getModelResolverRegistry().getBestResolverFor(leftStorage);
            IdenticalResourceMinimizer minimizer = new IdenticalResourceMinimizer();
            ComparisonScopeBuilder builder = new ComparisonScopeBuilder(remoteResolver, minimizer, accessor);
            syncModel = builder.buildSynchronizationModel(left, right, origin, actualMonitor);
        } else {
            syncModel = new SynchronizationModel(localTraversal, new StorageTraversal(Collections.emptySet()), new StorageTraversal(Collections.emptySet()));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"computeLogicalModel() - FINISH");
        }
        return syncModel;
    }

    private ITypedElement findTypedElement(StorageTraversal traversal, IStorageProviderAccessor storageAccessor, IProgressMonitor monitor, IStorageProviderAccessor.DiffSide side) throws CoreException {
        if (traversal != null && !traversal.getStorages().isEmpty()) {
            for (IStorage storage : traversal.getStorages()) {
                IStorageProvider storageProvider;
                if (!(storage instanceof IFile) || (storageProvider = storageAccessor.getStorageProvider((IResource)((IFile)storage), side)) == null) continue;
                return new StorageTypedElement(storageProvider.getStorage(monitor), ResourceUtil.getFixedPath((IStorage)storage).toString());
            }
        }
        return null;
    }
}

