/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.utils;

import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.compare.ide.EMFCompareIDEPlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceUtil {
    private static final String[] MODEL_CONTENT_TYPES = new String[]{"org.eclipse.emf.compare.content.type", "org.eclipse.emf.ecore", "org.eclipse.emf.ecore.xmi"};

    private ResourceUtil() {
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Resource loadResource(IStorage storage, ResourceSet resourceSet, Map<?, ?> options) {
        URI uri = ResourceUtil.createURIFor(storage);
        InputStream stream = null;
        Resource resource = null;
        try {
            resource = resourceSet.createResource(uri);
            stream = storage.getContents();
            resource.load(stream, options);
        }
        catch (IOException iOException) {
            if (stream == null) return resource;
            try {
                stream.close();
                return resource;
            }
            catch (IOException iOException2) {}
            return resource;
        }
        catch (CoreException coreException) {
            if (stream == null) return resource;
            try {
                stream.close();
                return resource;
            }
            catch (IOException iOException) {}
            return resource;
        }
        catch (WrappedException wrappedException) {
            if (stream == null) return resource;
            {
                catch (Throwable throwable) {
                    if (stream == null) throw throwable;
                    try {
                        stream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                stream.close();
                return resource;
            }
            catch (IOException iOException) {}
            return resource;
        }
        if (stream == null) return resource;
        try {
            stream.close();
            return resource;
        }
        catch (IOException iOException) {}
        return resource;
    }

    /*
     * Loose catch block
     * WARNING - bad return control flow
     */
    public static boolean binaryIdentical(IStorage left, IStorage right) {
        boolean bl;
        BufferedReader rightReader;
        block12: {
            BufferedReader leftReader = null;
            rightReader = null;
            try {
                leftReader = new BufferedReader(new InputStreamReader(left.getContents()));
                rightReader = new BufferedReader(new InputStreamReader(right.getContents()));
                char[] leftBuff = new char[16384];
                char[] rightBuff = new char[16384];
                int readLeft = leftReader.read(leftBuff);
                int readRight = rightReader.read(rightBuff);
                while (readLeft > 0 && readRight > 0 && ResourceUtil.equalArrays(readLeft, readRight, leftBuff, rightBuff)) {
                    readLeft = leftReader.read(leftBuff);
                    readRight = rightReader.read(rightBuff);
                }
                bl = ResourceUtil.equalArrays(readLeft, readRight, leftBuff, rightBuff);
                if (leftReader == null) break block12;
            }
            catch (CoreException e) {
                block13: {
                    ResourceUtil.logError((Exception)((Object)e));
                    if (leftReader == null) break block13;
                    Closeables.closeQuietly((Closeable)leftReader);
                }
                if (rightReader != null) {
                    Closeables.closeQuietly(rightReader);
                }
            }
            catch (IOException e2) {
                block14: {
                    ResourceUtil.logError(e2);
                    if (leftReader == null) break block14;
                    {
                        catch (Throwable throwable) {
                            if (leftReader != null) {
                                Closeables.closeQuietly(leftReader);
                            }
                            if (rightReader != null) {
                                Closeables.closeQuietly(rightReader);
                            }
                            throw throwable;
                        }
                    }
                    Closeables.closeQuietly((Closeable)leftReader);
                }
                if (rightReader != null) {
                    Closeables.closeQuietly(rightReader);
                }
            }
            Closeables.closeQuietly((Closeable)leftReader);
        }
        if (rightReader != null) {
            Closeables.closeQuietly((Closeable)rightReader);
        }
        return bl;
        return false;
    }

    /*
     * Loose catch block
     * WARNING - bad return control flow
     */
    public static boolean binaryIdentical(IStorage left, IStorage right, IStorage origin) {
        boolean bl;
        BufferedReader originReader;
        BufferedReader rightReader;
        block16: {
            BufferedReader leftReader = null;
            rightReader = null;
            originReader = null;
            try {
                leftReader = new BufferedReader(new InputStreamReader(left.getContents()));
                rightReader = new BufferedReader(new InputStreamReader(right.getContents()));
                originReader = new BufferedReader(new InputStreamReader(origin.getContents()));
                char[] leftBuff = new char[16384];
                char[] rightBuff = new char[16384];
                char[] originBuff = new char[16384];
                int readLeft = leftReader.read(leftBuff);
                int readRight = rightReader.read(rightBuff);
                int readOrigin = originReader.read(originBuff);
                while (readLeft > 0 && readRight > 0 && readOrigin > 0 && ResourceUtil.equalArrays(readLeft, readRight, readOrigin, leftBuff, rightBuff, originBuff)) {
                    readLeft = leftReader.read(leftBuff);
                    readRight = rightReader.read(rightBuff);
                    readOrigin = originReader.read(originBuff);
                }
                bl = ResourceUtil.equalArrays(readLeft, readRight, readOrigin, leftBuff, rightBuff, originBuff);
                if (leftReader == null) break block16;
            }
            catch (CoreException e) {
                block17: {
                    ResourceUtil.logError((Exception)((Object)e));
                    if (leftReader == null) break block17;
                    Closeables.closeQuietly((Closeable)leftReader);
                }
                if (rightReader != null) {
                    Closeables.closeQuietly(rightReader);
                }
                if (originReader != null) {
                    Closeables.closeQuietly(originReader);
                }
            }
            catch (IOException e2) {
                block18: {
                    ResourceUtil.logError(e2);
                    if (leftReader == null) break block18;
                    {
                        catch (Throwable throwable) {
                            if (leftReader != null) {
                                Closeables.closeQuietly(leftReader);
                            }
                            if (rightReader != null) {
                                Closeables.closeQuietly(rightReader);
                            }
                            if (originReader != null) {
                                Closeables.closeQuietly(originReader);
                            }
                            throw throwable;
                        }
                    }
                    Closeables.closeQuietly((Closeable)leftReader);
                }
                if (rightReader != null) {
                    Closeables.closeQuietly(rightReader);
                }
                if (originReader != null) {
                    Closeables.closeQuietly(originReader);
                }
            }
            Closeables.closeQuietly((Closeable)leftReader);
        }
        if (rightReader != null) {
            Closeables.closeQuietly((Closeable)rightReader);
        }
        if (originReader != null) {
            Closeables.closeQuietly((Closeable)originReader);
        }
        return bl;
        return false;
    }

    public static URI createURIFor(IFile file) {
        return URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
    }

    public static URI createURIFor(IStorage storage) {
        if (storage instanceof IFile) {
            return ResourceUtil.createURIFor((IFile)storage);
        }
        String resourceName = storage.getName();
        String path = storage.getFullPath().toString();
        if (!path.endsWith(resourceName)) {
            int endIndex = path.indexOf(resourceName) + resourceName.length();
            path = path.substring(0, endIndex);
        }
        URI uri = path.startsWith("platform:/plugin/") ? URI.createURI((String)path) : (path.startsWith("file:/") ? URI.createURI((String)path) : URI.createFileURI((String)path));
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Path iPath = new Path(path);
        if (root != null && iPath.segmentCount() >= 2) {
            if (root.getFile((IPath)iPath).exists()) {
                uri = URI.createPlatformResourceURI((String)path, (boolean)true);
            } else {
                IPath trimmed = iPath.removeFirstSegments(1);
                if (trimmed.segmentCount() >= 2 && root.getFile(trimmed).exists()) {
                    uri = URI.createPlatformResourceURI((String)trimmed.toString(), (boolean)true);
                }
            }
        }
        return uri;
    }

    public static void saveAllResources(ResourceSet resourceSet, Map<?, ?> options) {
        EList resources = resourceSet.getResources();
        for (Resource resource : resources) {
            ResourceUtil.saveResource(resource, options);
        }
    }

    public static void saveResource(Resource resource, Map<?, ?> options) {
        if (ResourceUtil.supportsOutput(resource)) {
            try {
                resource.save(options);
            }
            catch (IOException e) {
                ResourceUtil.logError(e);
            }
        }
    }

    public static boolean hasContentType(String contentTypeId, List<IContentType> contentTypes) {
        IContentTypeManager ctManager = Platform.getContentTypeManager();
        IContentType expected = ctManager.getContentType(contentTypeId);
        if (expected == null) {
            return false;
        }
        boolean hasContentType = false;
        int i = 0;
        while (i < contentTypes.size() && !hasContentType) {
            if (contentTypes.get(i).isKindOf(expected)) {
                hasContentType = true;
            }
            ++i;
        }
        return hasContentType;
    }

    public static boolean hasModelType(IFile file) {
        boolean isModel = false;
        IContentTypeManager ctManager = Platform.getContentTypeManager();
        ArrayList fileNameTypes = Lists.newArrayList((Object[])ctManager.findContentTypesFor(file.getName()));
        int i = 0;
        while (i < MODEL_CONTENT_TYPES.length && !isModel) {
            isModel = ResourceUtil.hasContentType(MODEL_CONTENT_TYPES[i], fileNameTypes);
            ++i;
        }
        if (isModel) {
            return true;
        }
        ArrayList contentTypes = Lists.newArrayList((Object[])ResourceUtil.getContentTypes(file));
        contentTypes.removeAll(fileNameTypes);
        int i2 = 0;
        while (i2 < MODEL_CONTENT_TYPES.length && !isModel) {
            isModel = ResourceUtil.hasContentType(MODEL_CONTENT_TYPES[i2], contentTypes);
            ++i2;
        }
        return isModel;
    }

    public static IContentType[] getContentTypes(IFile file) {
        IContentTypeManager ctManager = Platform.getContentTypeManager();
        InputStream resourceContent = null;
        IContentType[] contentTypes = new IContentType[]{};
        try {
            try {
                resourceContent = file.getContents();
                contentTypes = ctManager.findContentTypesFor(resourceContent, file.getName());
            }
            catch (CoreException coreException) {
                ctManager.findContentTypesFor(file.getName());
                Closeables.closeQuietly((Closeable)resourceContent);
            }
            catch (IOException iOException) {
                ctManager.findContentTypesFor(file.getName());
                Closeables.closeQuietly((Closeable)resourceContent);
            }
        }
        finally {
            Closeables.closeQuietly((Closeable)resourceContent);
        }
        return contentTypes;
    }

    private static boolean supportsOutput(Resource resource) {
        URI uri = resource.getURI();
        return uri.isPlatformResource() || uri.isRelative() || uri.isFile();
    }

    private static boolean equalArrays(int length1, int length2, char[] array1, char[] array2) {
        if (length1 == length2) {
            boolean result = true;
            if (array1 == array2) {
                result = true;
            } else if (array1 == null || array2 == null) {
                result = false;
            } else {
                int i = 0;
                while (i < length1 && result) {
                    result = array1[i] == array2[i];
                    ++i;
                }
            }
            return result;
        }
        return false;
    }

    private static boolean equalArrays(int length1, int length2, int length3, char[] array1, char[] array2, char[] array3) {
        if (length1 == length2 && length1 == length3) {
            boolean result = true;
            if (array1 == array2 && array1 == array3) {
                result = true;
            } else if (array1 == null || array2 == null || array3 == null) {
                result = false;
            } else {
                int i = 0;
                while (i < length1 && result) {
                    result = array1[i] == array2[i] && array1[i] == array3[i];
                    ++i;
                }
            }
            return result;
        }
        return false;
    }

    private static void logError(Exception e) {
        Status status = new Status(4, "org.eclipse.emf.compare.ide", e.getMessage(), (Throwable)e);
        EMFCompareIDEPlugin.getDefault().getLog().log((IStatus)status);
    }
}

