/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.emf.compare.rcp.extension.AbstractRegistryEventListener;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.DifferenceGroupProviderDescriptorImpl;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroupProvider;

public class DifferenceGroupProviderExtensionRegistryListener
extends AbstractRegistryEventListener {
    static final String TAG_GROUP_PROVIDER = "group";
    static final String ATT_CLASS = "class";
    static final String ATT_LABEL = "label";
    static final String ATT_ACTIVE = "activeByDefault";
    private final IDifferenceGroupProvider.Descriptor.Registry groupProviderRegistry;

    public DifferenceGroupProviderExtensionRegistryListener(String pluginID, String extensionPointID, ILog log, IDifferenceGroupProvider.Descriptor.Registry registry) {
        super(pluginID, extensionPointID, log);
        this.groupProviderRegistry = registry;
    }

    protected boolean validateExtensionElement(IConfigurationElement element) {
        boolean valid;
        if (element.getName().equals(TAG_GROUP_PROVIDER)) {
            if (element.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(element, ATT_CLASS);
                valid = false;
            } else if (element.getAttribute(ATT_LABEL) == null) {
                this.logMissingAttribute(element, ATT_LABEL);
                valid = false;
            } else if (element.getAttribute(ATT_ACTIVE) == null) {
                this.logMissingAttribute(element, ATT_ACTIVE);
                valid = false;
            } else {
                valid = true;
            }
        } else {
            valid = false;
        }
        return valid;
    }

    protected boolean addedValid(IConfigurationElement element) {
        DifferenceGroupProviderDescriptorImpl providerDescriptor = new DifferenceGroupProviderDescriptorImpl(element, element.getAttribute(ATT_LABEL), Boolean.valueOf(element.getAttribute(ATT_ACTIVE)));
        IDifferenceGroupProvider.Descriptor previous = this.groupProviderRegistry.add(providerDescriptor, element.getAttribute(ATT_CLASS));
        if (previous != null) {
            this.log(2, element, "The group provider descriptor'" + element.getAttribute(ATT_CLASS) + "' is registered twice.");
        }
        return true;
    }

    protected boolean removedValid(IConfigurationElement element) {
        this.groupProviderRegistry.remove(element.getAttribute(ATT_CLASS));
        return true;
    }
}

