/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.BasicDifferenceGroupImpl;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.IDifferenceGroup;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.utils.EMFComparePredicates;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreeWayComparisonGroupProvider
implements IDifferenceGroupProvider {
    private String label;
    private boolean activeByDefault;

    @Override
    public Iterable<? extends IDifferenceGroup> getGroups(Comparison comparison) {
        EList diffs = comparison.getDifferences();
        ConflictsGroupImpl conflicts = new ConflictsGroupImpl(comparison, (Iterable<? extends Diff>)diffs, (Predicate<? super Diff>)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL, ConflictKind.PSEUDO}), "Conflicts");
        BasicDifferenceGroupImpl leftSide = new BasicDifferenceGroupImpl(comparison, (Iterable<? extends Diff>)diffs, (Predicate<? super Diff>)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL, ConflictKind.PSEUDO}))), "Left side");
        BasicDifferenceGroupImpl rightSide = new BasicDifferenceGroupImpl(comparison, (Iterable<? extends Diff>)diffs, (Predicate<? super Diff>)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL, ConflictKind.PSEUDO}))), "Right side");
        return ImmutableList.of((Object)conflicts, (Object)leftSide, (Object)rightSide);
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public boolean defaultSelected() {
        return this.activeByDefault;
    }

    @Override
    public void setDefaultSelected(boolean active) {
        this.activeByDefault = active;
    }

    @Override
    public boolean isEnabled(IComparisonScope scope, Comparison comparison) {
        return comparison != null && comparison.isThreeWay();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ConflictsGroupImpl
    extends BasicDifferenceGroupImpl {
        public ConflictsGroupImpl(Comparison comparison, Iterable<? extends Diff> unfiltered, Predicate<? super Diff> filter, String name) {
            super(comparison, unfiltered, filter, name);
        }

        @Override
        public IStyledString.IComposedStyledString getStyledName() {
            ComposedStyledString ret = new ComposedStyledString(this.getName());
            int unresolvedRealDiffs = Iterables.size((Iterable)Iterables.filter(this.getDifferences(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED}), (Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL}))));
            int unresolvedPseudoDiffs = Iterables.size((Iterable)Iterables.filter(this.getDifferences(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED}), (Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO}))));
            ret.append(" [" + unresolvedRealDiffs + " real and " + unresolvedPseudoDiffs + " pseudo unresolved difference", IStyledString.Style.DECORATIONS_STYLER);
            if (unresolvedRealDiffs + unresolvedPseudoDiffs > 1) {
                ret.append("s", IStyledString.Style.DECORATIONS_STYLER);
            }
            ret.append("]", IStyledString.Style.DECORATIONS_STYLER);
            return ret;
        }
    }
}

