/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.impl;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;

abstract class TableOrTreeItemWrapper {
    TableOrTreeItemWrapper() {
    }

    public static TableOrTreeItemWrapper create(Item item) {
        if (item instanceof TreeItem) {
            return new TreeItemWrapper((TreeItem)item);
        }
        if (item instanceof TableItem) {
            return new TableItemWrapper((TableItem)item);
        }
        if (item == null) {
            return null;
        }
        throw new IllegalArgumentException("Item must be instance of TreeItem or TableItem");
    }

    protected abstract Item getItem();

    public abstract Rectangle getBounds();

    public abstract Scrollable getParent();

    public abstract int getParentColumnCount();

    public abstract Rectangle getImageBounds(int var1);

    public abstract Rectangle getTextBounds(int var1);

    public abstract String getText(int var1);

    public abstract Image getImage(int var1);

    public abstract TableOrTreeItemWrapper getParentItem();

    public abstract int getParentItemHeight();

    public Object getData() {
        return this.getItem().getData();
    }

    private static class TableItemWrapper
    extends TableOrTreeItemWrapper {
        private final TableItem fItem;

        public TableItemWrapper(TableItem item) {
            this.fItem = item;
        }

        protected Item getItem() {
            return this.fItem;
        }

        public Rectangle getBounds() {
            return this.fItem.getBounds();
        }

        public Scrollable getParent() {
            return this.fItem.getParent();
        }

        public int getParentColumnCount() {
            return this.fItem.getParent().getColumnCount();
        }

        public Rectangle getImageBounds(int index) {
            return this.fItem.getImageBounds(index);
        }

        public TableOrTreeItemWrapper getParentItem() {
            return null;
        }

        public int getParentItemHeight() {
            return this.fItem.getParent().getItemHeight();
        }

        public Rectangle getTextBounds(int index) {
            return this.fItem.getTextBounds(index);
        }

        public String getText(int index) {
            return this.fItem.getText(index);
        }

        public Image getImage(int index) {
            return this.fItem.getImage(index);
        }
    }

    private static class TreeItemWrapper
    extends TableOrTreeItemWrapper {
        private final TreeItem fItem;

        public TreeItemWrapper(TreeItem item) {
            this.fItem = item;
        }

        protected Item getItem() {
            return this.fItem;
        }

        public Rectangle getBounds() {
            return this.fItem.getBounds();
        }

        public Scrollable getParent() {
            return this.fItem.getParent();
        }

        public int getParentColumnCount() {
            return this.fItem.getParent().getColumnCount();
        }

        public Rectangle getImageBounds(int index) {
            return this.fItem.getImageBounds(index);
        }

        public TableOrTreeItemWrapper getParentItem() {
            return TableOrTreeItemWrapper.create((Item)this.fItem.getParentItem());
        }

        public int getParentItemHeight() {
            return this.fItem.getParent().getItemHeight();
        }

        public Rectangle getTextBounds(int index) {
            return this.fItem.getTextBounds(index);
        }

        public String getText(int index) {
            return this.fItem.getText(index);
        }

        public Image getImage(int index) {
            return this.fItem.getImage(index);
        }
    }
}

