/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.eobject.internal;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.compare.match.eobject.WeightProvider;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;

public class ReflectiveWeightProvider
implements WeightProvider {
    private static final int SMALL = 5;
    private static final int NORMAL = 10;
    private static final int SIGNIFICANT = 20;
    private static final int MAJOR = 150;
    private static final int MASSIVE = 350;
    private static final int UNLIKELY_TO_MATCH = 1000;
    private Map<EStructuralFeature, Integer> weights = Maps.newHashMap();
    private Set<EStructuralFeature> toBeIgnored = Sets.newLinkedHashSet();
    private int referenceChangeCoef = 10;
    private int attributeChangeCoef = 20;

    public int getWeight(EStructuralFeature feature) {
        if (this.irrelevant(feature) || this.toBeIgnored.contains(feature)) {
            return 0;
        }
        Integer found = this.weights.get(feature);
        if (found == null) {
            found = 5;
            if ("name".equals(feature.getName()) || "id".equals(feature.getName())) {
                found = 20;
            }
            if (feature instanceof EReference && ((EReference)feature).isContainment()) {
                found = 10;
            }
        }
        found = feature instanceof EReference ? Integer.valueOf(this.referenceChangeCoef * found) : Integer.valueOf(this.attributeChangeCoef * found);
        return found;
    }

    protected boolean irrelevant(EStructuralFeature feat) {
        boolean irrelevantFeature;
        boolean bl = irrelevantFeature = feat.isDerived() || feat.isTransient();
        if (!irrelevantFeature && feat instanceof EReference) {
            EReference ref = (EReference)feat;
            irrelevantFeature = ref.isContainment() || ref.isContainer();
        }
        return irrelevantFeature;
    }

    public int getParentWeight(EObject a) {
        if (a instanceof EStructuralFeature) {
            return 350;
        }
        if (a instanceof EAnnotation) {
            return 1000;
        }
        if (a instanceof EOperation) {
            return 150;
        }
        if (a instanceof EParameter) {
            return 1000;
        }
        if (a instanceof EStringToStringMapEntryImpl) {
            return 1000;
        }
        return 20;
    }

    public int getContainingFeatureWeight(EObject a) {
        if (a instanceof EStructuralFeature || a instanceof EAnnotation || a instanceof EOperation) {
            return 150;
        }
        return 20;
    }
}

